/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.seam.structure;

import com.intellij.ide.util.treeView.NodeDescriptor;
import com.intellij.jam.model.util.JamCommonUtil;
import com.intellij.javaee.module.view.nodes.JavaeeNodeDescriptor;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleType;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.JarFileSystem;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiCompiledElement;
import com.intellij.psi.xml.XmlFile;
import com.intellij.seam.constants.SeamDataKeys;
import com.intellij.seam.facet.SeamFacet;
import com.intellij.seam.model.jam.SeamJamComponent;
import com.intellij.seam.model.jam.SeamJamModel;
import com.intellij.seam.model.xml.SeamDomModelManager;
import com.intellij.seam.structure.SeamComponentNodeDescriptor;
import com.intellij.seam.structure.SeamDomModelNodeDescriptor;
import com.intellij.seam.structure.SeamModuleLibrariesNodeDescriptor;
import com.intellij.seam.utils.SeamConfigFileUtils;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;

public class SeamFacetNodeDescriptor
extends JavaeeNodeDescriptor<SeamFacet> {
    public SeamFacetNodeDescriptor(Project project, SeamFacet facet, NodeDescriptor parentDescriptor, Object parameters) {
        super(project, parentDescriptor, parameters, (Object)facet);
    }

    protected String getNewNodeText() {
        return ((SeamFacet)((Object)this.getElement())).getModule().getName();
    }

    @NotNull
    public JavaeeNodeDescriptor[] getChildren() {
        ArrayList<JavaeeNodeDescriptor> nodes = new ArrayList<JavaeeNodeDescriptor>();
        ArrayList<SeamJamComponent> compiledElements = new ArrayList<SeamJamComponent>();
        ArrayList<XmlFile> libElements = new ArrayList<XmlFile>();
        this.addJamNodes(nodes, compiledElements);
        this.addDomNodes(nodes, libElements);
        if (!compiledElements.isEmpty() || !libElements.isEmpty()) {
            nodes.add(new SeamModuleLibrariesNodeDescriptor(compiledElements, libElements, this.getProject(), (NodeDescriptor)this, this.getParameters(), ((SeamFacet)((Object)this.getElement())).getModule()));
        }
        JavaeeNodeDescriptor[] javaeeNodeDescriptorArray = nodes.toArray(JavaeeNodeDescriptor.EMPTY_ARRAY);
        if (javaeeNodeDescriptorArray == null) {
            SeamFacetNodeDescriptor.$$$reportNull$$$0(0);
        }
        return javaeeNodeDescriptorArray;
    }

    private void addDomNodes(List<JavaeeNodeDescriptor> nodes, List<XmlFile> libFiles) {
        SeamDomModelManager modelManager = SeamDomModelManager.getInstance(this.getProject());
        Set<XmlFile> files = SeamConfigFileUtils.getConfigurationFiles(((SeamFacet)((Object)this.getElement())).getModule());
        for (XmlFile file : files) {
            if (!modelManager.isSeamComponents(file)) continue;
            if (SeamFacetNodeDescriptor.isLibrary(file)) {
                libFiles.add(file);
                continue;
            }
            nodes.add(new SeamDomModelNodeDescriptor(this.getProject(), (NodeDescriptor)this, this.getParameters(), file, this.getProject().getBaseDir()));
        }
    }

    private static boolean isLibrary(XmlFile xmlFile) {
        VirtualFile file = xmlFile.getVirtualFile();
        assert (file != null);
        return file.getFileSystem() instanceof JarFileSystem;
    }

    private void addJamNodes(List<JavaeeNodeDescriptor> nodes, List<SeamJamComponent> compiledElements) {
        Module module = ((SeamFacet)((Object)this.getElement())).getModule();
        this.addJamNodes(nodes, compiledElements, module, true);
        for (Module moduleDependency : JamCommonUtil.getAllModuleDependencies((Module)module)) {
            this.addJamNodes(nodes, compiledElements, moduleDependency, false);
        }
    }

    private void addJamNodes(List<JavaeeNodeDescriptor> nodes, List<SeamJamComponent> compiledElements, Module module, boolean fromLibs) {
        for (SeamJamComponent component : SeamJamModel.getModel(module).getSeamComponents(false, fromLibs)) {
            if (component.getPsiElement() instanceof PsiCompiledElement) {
                compiledElements.add(component);
                continue;
            }
            nodes.add((JavaeeNodeDescriptor)new SeamComponentNodeDescriptor(component, this, this.getParameters()));
        }
    }

    protected Icon getNewIcon() {
        return ModuleType.get((Module)((SeamFacet)((Object)this.getElement())).getModule()).getIcon();
    }

    public Object getData(@NotNull String dataId) {
        if (dataId == null) {
            SeamFacetNodeDescriptor.$$$reportNull$$$0(1);
        }
        if (SeamDataKeys.SEAM_FACET.is(dataId)) {
            return this.getElement();
        }
        return super.getData(dataId);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 1: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 1: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/seam/structure/SeamFacetNodeDescriptor";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dataId";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getChildren";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/seam/structure/SeamFacetNodeDescriptor";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "getData";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 1: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

