/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.seam.model.references;

import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiReference;
import com.intellij.psi.PsiReferenceBase;
import com.intellij.psi.PsiReferenceProvider;
import com.intellij.psi.xml.XmlAttributeValue;
import com.intellij.seam.model.jam.SeamJamComponent;
import com.intellij.seam.model.jam.SeamJamModel;
import com.intellij.seam.model.jam.jsf.SeamJamValidator;
import com.intellij.util.ArrayUtil;
import com.intellij.util.ProcessingContext;
import com.intellij.util.containers.ContainerUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public class SeamValidatorReferenceProvider
extends PsiReferenceProvider {
    @NotNull
    public PsiReference[] getReferencesByElement(@NotNull PsiElement element, @NotNull ProcessingContext context) {
        if (element == null) {
            SeamValidatorReferenceProvider.$$$reportNull$$$0(0);
        }
        if (context == null) {
            SeamValidatorReferenceProvider.$$$reportNull$$$0(1);
        }
        if (element instanceof XmlAttributeValue) {
            PsiReference[] psiReferenceArray = new PsiReference[]{new SeamValidatorPsiReference(element)};
            if (psiReferenceArray == null) {
                SeamValidatorReferenceProvider.$$$reportNull$$$0(2);
            }
            return psiReferenceArray;
        }
        if (PsiReference.EMPTY_ARRAY == null) {
            SeamValidatorReferenceProvider.$$$reportNull$$$0(3);
        }
        return PsiReference.EMPTY_ARRAY;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: 
            case 3: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: 
            case 3: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 2: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/seam/model/references/SeamValidatorReferenceProvider";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/seam/model/references/SeamValidatorReferenceProvider";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getReferencesByElement";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getReferencesByElement";
                break;
            }
            case 2: 
            case 3: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: 
            case 3: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static class SeamValidatorPsiReference
    extends PsiReferenceBase {
        SeamValidatorPsiReference(PsiElement element) {
            super(element, true);
        }

        public PsiElement resolve() {
            String value = this.getValue();
            if (StringUtil.isEmptyOrSpaces((String)value)) {
                return null;
            }
            List<SeamJamComponent> validorComponents = SeamValidatorPsiReference.getValidorComponents(this.getElement());
            for (SeamJamComponent validorComponent : validorComponents) {
                SeamJamValidator jamValidator = validorComponent.getValidator();
                if (jamValidator != null && value.equals(jamValidator.getId())) {
                    return jamValidator.getIdentifyingAnnotation();
                }
                if (!value.equals(validorComponent.getComponentName())) continue;
                return validorComponent.getIdentifyingPsiElement();
            }
            return null;
        }

        private static String getValidatorName(SeamJamComponent validorComponent) {
            String validatorName;
            SeamJamValidator jamValidator = validorComponent.getValidator();
            if (jamValidator != null && !StringUtil.isEmptyOrSpaces((String)(validatorName = jamValidator.getId()))) {
                return validatorName;
            }
            return validorComponent.getComponentName();
        }

        @NotNull
        public Object[] getVariants() {
            List variants = ContainerUtil.mapNotNull(SeamValidatorPsiReference.getValidorComponents(this.getElement()), seamJamComponent -> SeamValidatorPsiReference.getValidatorName(seamJamComponent));
            Object[] objectArray = ArrayUtil.toObjectArray((Collection)variants);
            if (objectArray == null) {
                SeamValidatorPsiReference.$$$reportNull$$$0(0);
            }
            return objectArray;
        }

        @NotNull
        private static List<SeamJamComponent> getValidorComponents(PsiElement element) {
            ArrayList<SeamJamComponent> validators = new ArrayList<SeamJamComponent>();
            Module module = ModuleUtil.findModuleForPsiElement((PsiElement)element);
            if (module != null) {
                for (SeamJamComponent seamJamComponent : SeamJamModel.getModel(module).getSeamComponents()) {
                    if (seamJamComponent.getValidator() == null) continue;
                    validators.add(seamJamComponent);
                }
            }
            ArrayList<SeamJamComponent> arrayList = validators;
            if (arrayList == null) {
                SeamValidatorPsiReference.$$$reportNull$$$0(1);
            }
            return arrayList;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[2];
            objectArray2[0] = "com/intellij/seam/model/references/SeamValidatorReferenceProvider$SeamValidatorPsiReference";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getVariants";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getValidorComponents";
                    break;
                }
            }
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", objectArray));
        }
    }
}

