/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.seam.jsf;

import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleUtil;
import com.intellij.openapi.project.Project;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiType;
import com.intellij.psi.impl.source.jsp.ELImplicitVariable;
import com.intellij.psi.jsp.JspImplicitVariable;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.seam.utils.SeamCommonUtils;
import com.intellij.seam.utils.beans.ContextVariable;
import com.intellij.seam.utils.beans.DomFactoryContextVariable;
import com.intellij.util.containers.hash.HashMap;
import java.util.Collection;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class JsfContextBeansUtils {
    private JsfContextBeansUtils() {
    }

    public static Collection<JspImplicitVariable> getJspImplicitVariables(String name, PsiFile file) {
        Module module;
        HashMap resultVars = new HashMap();
        if (file != null && (module = ModuleUtil.findModuleForPsiElement((PsiElement)file)) != null) {
            for (ContextVariable contextVariable : SeamCommonUtils.getSeamContextVariablesWithDependencies(module)) {
                if (name != null && !contextVariable.getName().startsWith(name)) continue;
                JsfContextBeansUtils.addSeamImplicitVariable(contextVariable.getModelElement().getIdentifyingPsiElement(), contextVariable.getName(), (Map<String, JspImplicitVariable>)resultVars, JsfContextBeansUtils.getType(contextVariable), file);
            }
        }
        return resultVars.values();
    }

    private static PsiType getType(ContextVariable variable) {
        if (variable instanceof DomFactoryContextVariable) {
            DomFactoryContextVariable factoryContextVariable = (DomFactoryContextVariable)variable;
            PsiType expressionType = factoryContextVariable.getELExpressionType();
            return expressionType == null ? variable.getType() : expressionType;
        }
        return variable.getType();
    }

    public static Collection<JspImplicitVariable> getJspImplicitVariables(PsiFile file) {
        Module module;
        HashMap resultVars = new HashMap();
        if (file != null && (module = ModuleUtil.findModuleForPsiElement((PsiElement)file)) != null && SeamCommonUtils.isSeamFacetDefined(module)) {
            JsfContextBeansUtils.addPredefinedSeamVariable(file, (Map<String, JspImplicitVariable>)resultVars, module);
            for (ContextVariable contextVariable : SeamCommonUtils.getSeamContextVariablesWithDependencies(module)) {
                JsfContextBeansUtils.addSeamImplicitVariable(contextVariable.getModelElement().getIdentifyingPsiElement(), contextVariable.getName(), (Map<String, JspImplicitVariable>)resultVars, contextVariable.getType(), file);
            }
        }
        return resultVars.values();
    }

    private static void addPredefinedSeamVariable(@NotNull PsiFile file, @NotNull Map<String, JspImplicitVariable> vars, Module module) {
        if (file == null) {
            JsfContextBeansUtils.$$$reportNull$$$0(0);
        }
        if (vars == null) {
            JsfContextBeansUtils.$$$reportNull$$$0(1);
        }
        JsfContextBeansUtils.addMessagesComponent(file, vars, module);
    }

    private static void addMessagesComponent(PsiFile file, Map<String, JspImplicitVariable> vars, @NotNull Module module) {
        if (module == null) {
            JsfContextBeansUtils.$$$reportNull$$$0(2);
        }
        String varName = "messages";
        vars.put("messages", (JspImplicitVariable)new ELImplicitVariable((PsiElement)file, "messages", (PsiType)JavaPsiFacade.getInstance((Project)file.getProject()).getElementFactory().createTypeByFQClassName("java.util.PropertyResourceBundle", GlobalSearchScope.moduleWithDependenciesAndLibrariesScope((Module)module)), file));
    }

    private static void addSeamImplicitVariable(PsiElement psiElement, @Nullable String name, Map<String, JspImplicitVariable> result, @Nullable PsiType type, PsiFile file) {
        if (name == null || name.length() == 0 || type == null || result.containsKey(name)) {
            return;
        }
        result.put(name, (JspImplicitVariable)new ELImplicitVariable((PsiElement)file, name, type, psiElement, "NESTED"));
        if (name.contains(".")) {
            String otherName = JsfContextBeansUtils.formatName(name);
            result.put(otherName, (JspImplicitVariable)new ELImplicitVariable((PsiElement)file, otherName, type, psiElement, "NESTED"));
        }
    }

    private static String formatName(String name) {
        return name.replace('.', '$');
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "vars";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "module";
                break;
            }
        }
        objectArray2[1] = "com/intellij/seam/jsf/JsfContextBeansUtils";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "addPredefinedSeamVariable";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "addMessagesComponent";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

