/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.javaee.oss.glassfish;

import com.intellij.javaee.facet.JavaeeFacet;
import com.intellij.javaee.model.xml.JavaeeDomModelElement;
import com.intellij.javaee.oss.glassfish.model.GlassfishAppRoot;
import com.intellij.javaee.oss.glassfish.model.GlassfishOracleAppRoot;
import com.intellij.javaee.oss.glassfish.model.GlassfishOracleWebRoot;
import com.intellij.javaee.oss.glassfish.model.GlassfishSunAppRoot;
import com.intellij.javaee.oss.glassfish.model.GlassfishSunWebRoot;
import com.intellij.javaee.oss.glassfish.model.GlassfishWebRoot;
import com.intellij.javaee.oss.glassfish.server.GlassfishIntegration;
import com.intellij.javaee.oss.util.Version;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class GlassfishUtil {
    private GlassfishUtil() {
    }

    @Nullable
    private static <T extends JavaeeDomModelElement> T getRootElement(Class<T> rootClass, @Nullable JavaeeFacet facet) {
        return (T)GlassfishIntegration.getInstance().getDescriptorsManager().getRootElement(rootClass, facet);
    }

    @Nullable
    private static <T extends JavaeeDomModelElement> T getMainRootElement(Class<? extends T> oracleAppRootClass, Class<? extends T> sunAppRootClass, @Nullable JavaeeFacet facet) {
        T result = GlassfishUtil.getRootElement(oracleAppRootClass, facet);
        return result == null ? GlassfishUtil.getRootElement(sunAppRootClass, facet) : result;
    }

    @Nullable
    public static GlassfishAppRoot getAppRoot(@Nullable JavaeeFacet facet) {
        return GlassfishUtil.getMainRootElement(GlassfishOracleAppRoot.class, GlassfishSunAppRoot.class, facet);
    }

    @Nullable
    public static GlassfishWebRoot getWebRoot(@Nullable JavaeeFacet facet) {
        return GlassfishUtil.getMainRootElement(GlassfishOracleWebRoot.class, GlassfishSunWebRoot.class, facet);
    }

    public static boolean isGlassfish4(String version) {
        return new Version(version).getMajor() == 4;
    }

    public static boolean isGlassfish5(String version) {
        return new Version(version).getMajor() == 5;
    }

    public static boolean isGlassfish4Plus(String version) {
        return new Version(version).getMajor() >= 4;
    }

    public static boolean isGlassfish3Plus(String version) {
        return new Version(version).getMajor() >= 3;
    }

    public static boolean isGlassfish31Plus(String versionName) {
        return new Version(versionName).compare(3, 1, 0) >= 0;
    }

    public static boolean isGlassfish5Higher(@NotNull String version) {
        if (version == null) {
            GlassfishUtil.$$$reportNull$$$0(0);
        }
        return new Version(version).compare(5, 0, 0) > 0;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "version", "com/intellij/javaee/oss/glassfish/GlassfishUtil", "isGlassfish5Higher"));
    }
}

