/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.grails.util;

import com.intellij.openapi.util.Condition;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiSubstitutor;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiTypeParameter;
import com.intellij.psi.util.PsiTypesUtil;
import java.util.Collection;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.plugins.grails.util.GrailsPsiUtil;
import org.jetbrains.plugins.grails.util.PredefinedReturnType;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.params.GrParameter;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.typedef.GrTypeDefinition;
import org.jetbrains.plugins.groovy.lang.psi.impl.synthetic.GrLightMethodBuilder;
import org.jetbrains.plugins.groovy.lang.psi.impl.synthetic.GrLightParameterListBuilder;

public class GrailsArtifactTransformerUtils {
    private GrailsArtifactTransformerUtils() {
    }

    public static boolean isCandidateMethod(PsiMethod method) {
        return method.getName().indexOf(36) == -1 && method.hasModifierProperty("public") && !method.hasModifierProperty("abstract") && !method.hasModifierProperty("static");
    }

    public static void enhanceAst(@NotNull PsiClass apiClass, @NotNull GrTypeDefinition enhancedClass, Collection<? super PsiMethod> results, boolean isStatic, @NotNull Condition<? super PsiMethod> methodFilter) {
        if (apiClass == null) {
            GrailsArtifactTransformerUtils.$$$reportNull$$$0(0);
        }
        if (enhancedClass == null) {
            GrailsArtifactTransformerUtils.$$$reportNull$$$0(1);
        }
        if (methodFilter == null) {
            GrailsArtifactTransformerUtils.$$$reportNull$$$0(2);
        }
        PsiClassType enhancedClassType = PsiTypesUtil.getClassType((PsiClass)enhancedClass);
        PsiSubstitutor returnTypeSubstitutor = null;
        PsiSubstitutor substitutor = PsiSubstitutor.EMPTY;
        PsiTypeParameter[] typeParameters = apiClass.getTypeParameters();
        if (typeParameters.length == 1) {
            if (isStatic) {
                returnTypeSubstitutor = PsiSubstitutor.EMPTY.put(typeParameters[0], (PsiType)enhancedClassType);
                substitutor = PsiSubstitutor.EMPTY.put(typeParameters[0], null);
            } else {
                substitutor = PsiSubstitutor.EMPTY.put(typeParameters[0], (PsiType)enhancedClassType);
            }
        }
        for (PsiMethod method : apiClass.getAllMethods()) {
            String qName;
            PsiClass containingClass;
            if (method.isConstructor() || (containingClass = method.getContainingClass()) == null || (qName = containingClass.getQualifiedName()) == null || qName.startsWith("java.") || qName.startsWith("groovy.") || !methodFilter.value((Object)method)) continue;
            GrLightMethodBuilder m = GrailsPsiUtil.substitute(method, substitutor);
            if (isStatic) {
                PsiType realReturnType;
                m.addModifier(8);
                PsiType methodReturnType = method.getReturnType();
                if (methodReturnType != null && returnTypeSubstitutor != null && !methodReturnType.equals(realReturnType = returnTypeSubstitutor.substitute(methodReturnType))) {
                    m.putUserData(PredefinedReturnType.PREDEFINED_RETURN_TYPE_KEY, (Object)realReturnType);
                }
            } else {
                GrParameter parameter;
                GrLightParameterListBuilder parameterList = m.getParameterList();
                if (parameterList.getParametersCount() == 0 || !(parameter = parameterList.removeParameter(0)).getType().isAssignableFrom((PsiType)enhancedClassType)) continue;
            }
            m.setData((Object)enhancedClass);
            if (enhancedClass.findCodeMethodsBySignature((PsiMethod)m, false).length != 0) continue;
            results.add((PsiMethod)m);
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[3];
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[0] = "apiClass";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[0] = "enhancedClass";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[0] = "methodFilter";
                break;
            }
        }
        objectArray[1] = "org/jetbrains/plugins/grails/util/GrailsArtifactTransformerUtils";
        objectArray[2] = "enhanceAst";
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    public static class DefaultFilter
    implements Condition<PsiMethod> {
        public static final DefaultFilter INSTANCE = new DefaultFilter();

        public boolean value(PsiMethod method) {
            return GrailsArtifactTransformerUtils.isCandidateMethod(method);
        }
    }
}

