/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.grails.ui;

import com.intellij.ide.util.PropertiesComponent;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.fileTypes.PlainTextFileType;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.ComboBox;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.ui.EditorTextField;
import com.intellij.ui.StringComboboxEditor;
import com.intellij.util.containers.ContainerUtil;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.stream.Collectors;
import javax.swing.AbstractListModel;
import javax.swing.ComboBoxEditor;
import javax.swing.ComboBoxModel;
import org.jetbrains.annotations.NotNull;

public class EditorComboBoxWithHistory
extends ComboBox {
    @NotNull
    private final String myDataKey;

    public EditorComboBoxWithHistory(@NotNull Project project, @NotNull String key) {
        if (project == null) {
            EditorComboBoxWithHistory.$$$reportNull$$$0(0);
        }
        if (key == null) {
            EditorComboBoxWithHistory.$$$reportNull$$$0(1);
        }
        super((ComboBoxModel)EditorComboBoxWithHistory.createModel(key));
        this.setEditor((ComboBoxEditor)new StringComboboxEditor(project, (FileType)PlainTextFileType.INSTANCE, (ComboBox)this));
        this.myDataKey = key;
    }

    @NotNull
    public EditorTextField getEditorComponent() {
        EditorTextField editorTextField = (EditorTextField)super.getEditor().getEditorComponent();
        if (editorTextField == null) {
            EditorComboBoxWithHistory.$$$reportNull$$$0(2);
        }
        return editorTextField;
    }

    @NotNull
    public String getText() {
        String string = this.getEditorComponent().getText();
        if (string == null) {
            EditorComboBoxWithHistory.$$$reportNull$$$0(3);
        }
        return string;
    }

    public MyModel getModel() {
        return (MyModel)super.getModel();
    }

    public void save() {
        String text = this.getText();
        ArrayList<String> strings = new ArrayList<String>(this.getModel().myStrings);
        int index = strings.indexOf(text);
        if (index > -1) {
            strings.remove(index);
        }
        strings.add(0, text);
        PropertiesComponent.getInstance().setValue(this.myDataKey, StringUtil.join(strings, (String)"\n"));
    }

    @NotNull
    private static MyModel createModel(@NotNull String dataKey) {
        String history;
        if (dataKey == null) {
            EditorComboBoxWithHistory.$$$reportNull$$$0(4);
        }
        MyModel myModel = (history = PropertiesComponent.getInstance().getValue(dataKey)) == null ? new MyModel() : new MyModel(Arrays.stream(history.split("\n")).filter(StringUtil::isNotEmpty).collect(Collectors.toList()));
        if (myModel == null) {
            EditorComboBoxWithHistory.$$$reportNull$$$0(5);
        }
        return myModel;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: 
            case 3: 
            case 5: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: 
            case 3: 
            case 5: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "key";
                break;
            }
            case 2: 
            case 3: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/plugins/grails/ui/EditorComboBoxWithHistory";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dataKey";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/plugins/grails/ui/EditorComboBoxWithHistory";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getEditorComponent";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getText";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "createModel";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: 
            case 3: 
            case 5: {
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "createModel";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: 
            case 3: 
            case 5: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    public static class MyModel
    extends AbstractListModel<String>
    implements ComboBoxModel<String> {
        private final List<String> myStrings = ContainerUtil.newArrayList();
        private String myCurrentString;

        public MyModel() {
        }

        public MyModel(Collection<String> strings) {
            this.myStrings.addAll(strings);
        }

        @Override
        public void setSelectedItem(Object anItem) {
            int oldIndex = this.myStrings.indexOf(this.myCurrentString);
            this.myCurrentString = String.valueOf(anItem);
            int newIndex = this.myStrings.indexOf(this.myCurrentString);
            this.fireContentsChanged(anItem, oldIndex, newIndex);
        }

        @Override
        public Object getSelectedItem() {
            return this.myCurrentString;
        }

        @Override
        public int getSize() {
            return this.myStrings.size();
        }

        @Override
        public String getElementAt(int index) {
            return this.myStrings.get(index);
        }
    }
}

