/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.grails.references.providers;

import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiReference;
import com.intellij.psi.impl.source.resolve.reference.impl.providers.JavaClassReference;
import com.intellij.psi.impl.source.resolve.reference.impl.providers.JavaClassReferenceProvider;
import com.intellij.psi.impl.source.resolve.reference.impl.providers.JavaClassReferenceSet;
import gnu.trove.THashMap;
import java.util.ArrayList;
import java.util.Map;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;

public class GspImportListReferenceProvider
extends JavaClassReferenceProvider {
    @NonNls
    private static final String STATIC_PREFIX = "static ";

    public GspImportListReferenceProvider() {
        THashMap options = new THashMap();
        options.put(RESOLVE_QUALIFIED_CLASS_NAME, Boolean.TRUE);
        options.put(ADVANCED_RESOLVE, Boolean.TRUE);
        this.setOptions((Map)options);
    }

    @NotNull
    public PsiReference[] getReferencesByString(String str, @NotNull PsiElement position, int offsetInPosition) {
        if (position == null) {
            GspImportListReferenceProvider.$$$reportNull$$$0(0);
        }
        ArrayList<JavaClassReference> results = new ArrayList<JavaClassReference>();
        int lastReferencePosition = 0;
        do {
            JavaClassReference[] allReferences;
            int asIndex = str.indexOf(" as ", lastReferencePosition);
            int i2 = str.indexOf(59, lastReferencePosition);
            int nextReferenceStart = i2 >= 0 ? i2 : str.length();
            String identifier = str.substring(lastReferencePosition, asIndex >= 0 && asIndex + 1 < nextReferenceStart ? asIndex + 1 : nextReferenceStart);
            if (identifier.length() == 0) {
                lastReferencePosition = nextReferenceStart + 1;
                continue;
            }
            int whitespaceShift = 0;
            while (whitespaceShift < identifier.length() && Character.isWhitespace(identifier.charAt(whitespaceShift++))) {
            }
            lastReferencePosition += whitespaceShift - 1;
            identifier = identifier.substring(whitespaceShift - 1);
            boolean isStatic = false;
            if (identifier.startsWith(STATIC_PREFIX)) {
                identifier = identifier.substring(STATIC_PREFIX.length());
                lastReferencePosition += STATIC_PREFIX.length();
                isStatic = true;
            }
            JavaClassReferenceSet referenceSet = new JavaClassReferenceSet(identifier.trim(), position, offsetInPosition + lastReferencePosition, isStatic, (JavaClassReferenceProvider)this);
            for (JavaClassReference allReference : allReferences = referenceSet.getAllReferences()) {
                String text = allReference.getCanonicalText();
                if ("*".equals(text)) continue;
                results.add(allReference);
            }
            lastReferencePosition = nextReferenceStart + 1;
        } while (lastReferencePosition < str.length());
        PsiReference[] psiReferenceArray = results.toArray(PsiReference.EMPTY_ARRAY);
        if (psiReferenceArray == null) {
            GspImportListReferenceProvider.$$$reportNull$$$0(1);
        }
        return psiReferenceArray;
    }

    public boolean isSoft() {
        return false;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "position";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/plugins/grails/references/providers/GspImportListReferenceProvider";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/plugins/grails/references/providers/GspImportListReferenceProvider";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getReferencesByString";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getReferencesByString";
                break;
            }
            case 1: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

