/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.grails.lang.gsp.editor.actions;

import com.intellij.codeInsight.editorActions.TypedHandlerDelegate;
import com.intellij.ide.DataManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.EditorModificationUtil;
import com.intellij.openapi.editor.actionSystem.EditorActionHandler;
import com.intellij.openapi.editor.actionSystem.EditorActionManager;
import com.intellij.openapi.editor.ex.EditorEx;
import com.intellij.openapi.editor.highlighter.EditorHighlighter;
import com.intellij.openapi.editor.highlighter.HighlighterIterator;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiFile;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.xml.XmlTokenType;
import java.awt.Component;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.plugins.grails.addins.js.JavaScriptIntegrationUtil;
import org.jetbrains.plugins.grails.lang.gsp.editor.actions.GspEditorActionsUtil;
import org.jetbrains.plugins.grails.lang.gsp.lexer.core.GspTokenTypes;
import org.jetbrains.plugins.grails.lang.gsp.psi.gsp.api.GspFile;
import org.jetbrains.plugins.groovy.editor.HandlerUtils;

public class GspTypedHandler
extends TypedHandlerDelegate {
    private static final Logger LOG = Logger.getInstance(GspTypedHandler.class);

    @NotNull
    public TypedHandlerDelegate.Result beforeCharTyped(char c, @NotNull Project project, @NotNull Editor editor, @NotNull PsiFile file, @NotNull FileType fileType) {
        if (project == null) {
            GspTypedHandler.$$$reportNull$$$0(0);
        }
        if (editor == null) {
            GspTypedHandler.$$$reportNull$$$0(1);
        }
        if (file == null) {
            GspTypedHandler.$$$reportNull$$$0(2);
        }
        if (fileType == null) {
            GspTypedHandler.$$$reportNull$$$0(3);
        }
        if (GspTypedHandler.handleTyping(editor, c, project)) {
            TypedHandlerDelegate.Result result2 = TypedHandlerDelegate.Result.STOP;
            if (result2 == null) {
                GspTypedHandler.$$$reportNull$$$0(4);
            }
            return result2;
        }
        TypedHandlerDelegate.Result result3 = TypedHandlerDelegate.Result.CONTINUE;
        if (result3 == null) {
            GspTypedHandler.$$$reportNull$$$0(5);
        }
        return result3;
    }

    private static boolean handleTyping(Editor editor, char charTyped, Project project) {
        if (project == null || !HandlerUtils.canBeInvoked((Editor)editor, (Project)project)) {
            return false;
        }
        PsiFile file = HandlerUtils.getPsiFile((Editor)editor, (Project)project);
        if (!(file instanceof GspFile)) {
            return false;
        }
        int caret = editor.getCaretModel().getOffset();
        EditorHighlighter highlighter = ((EditorEx)editor).getHighlighter();
        if (caret < 1) {
            return false;
        }
        HighlighterIterator iterator = highlighter.createIterator(caret - 1);
        IElementType tokenType = iterator.getTokenType();
        CharSequence text = editor.getDocument().getCharsSequence();
        if (tokenType == GspTokenTypes.JSCRIPT_BEGIN && GspEditorActionsUtil.areSciptletSeparatorsUnbalanced(highlighter.createIterator(caret - 1))) {
            if ('=' == charTyped) {
                return GspTypedHandler.handleJspLikeEqualTyped(editor, text, caret);
            }
            if ('@' == charTyped) {
                return GspTypedHandler.handleJspLikeDirectiveTyped(editor, text, caret);
            }
            if ('!' == charTyped) {
                return GspTypedHandler.handleJspLikeDeclarationTyped(editor, text, caret);
            }
        }
        if ('/' == charTyped && tokenType == XmlTokenType.XML_TAG_NAME && caret == iterator.getEnd()) {
            return GspTypedHandler.handleSlash(editor, text, caret, iterator);
        }
        if ('{' == charTyped) {
            if (tokenType == XmlTokenType.XML_DATA_CHARACTERS || JavaScriptIntegrationUtil.isJSElementType(tokenType)) {
                return GspTypedHandler.handleGspLeftBraceTyped(editor, text, caret, false, project);
            }
            if (tokenType == XmlTokenType.XML_ATTRIBUTE_VALUE_TOKEN) {
                return GspTypedHandler.handleGspLeftBraceTyped(editor, text, caret, true, project);
            }
            if (tokenType == GspTokenTypes.GSTRING_DOLLAR) {
                iterator.advance();
                if (iterator.getTokenType() == GspTokenTypes.GSP_ATTRIBUTE_VALUE_TOKEN) {
                    return GspTypedHandler.handleGspLeftBraceTyped(editor, text, caret, true, project);
                }
            }
        }
        if ('}' == charTyped) {
            return GspTypedHandler.handleGspRightBraceTyped(editor, text, caret);
        }
        if ('[' == charTyped && tokenType == XmlTokenType.XML_ATTRIBUTE_VALUE_START_DELIMITER) {
            iterator.advance();
            if (iterator.getTokenType() == XmlTokenType.XML_ATTRIBUTE_VALUE_END_DELIMITER) {
                EditorModificationUtil.insertStringAtCaret((Editor)editor, (String)"[]");
                editor.getCaretModel().moveCaretRelatively(-1, 0, false, false, true);
                return true;
            }
        }
        return false;
    }

    private static boolean handleSlash(Editor editor, CharSequence text, int caret, HighlighterIterator iterator) {
        for (int i2 = iterator.getStart(); i2 < caret; ++i2) {
            if (text.charAt(i2) != ':') continue;
            if ("tmpl".contentEquals(text.subSequence(iterator.getStart(), i2))) {
                return false;
            }
            if (caret < text.length() && text.charAt(caret) == '>') {
                EditorModificationUtil.insertStringAtCaret((Editor)editor, (String)"/");
            } else {
                EditorModificationUtil.insertStringAtCaret((Editor)editor, (String)"/>");
            }
            return true;
        }
        return false;
    }

    private static boolean handleGspRightBraceTyped(Editor editor, CharSequence text, int caret) {
        if (caret == 0 || text.length() < 2 || text.length() < caret + 1) {
            return false;
        }
        if (GspTypedHandler.mustNotPlaceBrace(editor, caret)) {
            editor.getCaretModel().moveCaretRelatively(1, 0, false, false, true);
            return true;
        }
        return false;
    }

    private static boolean mustNotPlaceBrace(Editor editor, int caret) {
        String text = editor.getDocument().getText();
        EditorHighlighter highlighter = ((EditorEx)editor).getHighlighter();
        if (caret < 1) {
            return false;
        }
        HighlighterIterator iterator = highlighter.createIterator(caret);
        return text.charAt(caret) == '}' && iterator.getTokenType() == GspTokenTypes.GEXPR_END;
    }

    private static boolean handleGspLeftBraceTyped(Editor editor, CharSequence text, int caret, boolean inGrailsTagArgValue, Project project) {
        if (caret < 1 || text.length() < Math.min(caret - 1, 1)) {
            return false;
        }
        EditorActionManager manager = EditorActionManager.getInstance();
        EditorActionHandler handler = manager.getActionHandler("EditorEnter");
        LOG.assertTrue(project != null);
        if (text.charAt(caret - 1) == '$') {
            if (text.length() > caret && text.charAt(caret) == '}') {
                return false;
            }
            EditorModificationUtil.insertStringAtCaret((Editor)editor, (String)"{}");
            editor.getCaretModel().moveCaretRelatively(-1, 0, false, false, true);
            return true;
        }
        if (!inGrailsTagArgValue && text.charAt(caret - 1) == '@') {
            if (text.length() > caret && text.charAt(caret) == '}') {
                return false;
            }
            EditorModificationUtil.insertStringAtCaret((Editor)editor, (String)"{  }");
            editor.getCaretModel().moveCaretRelatively(-2, 0, false, false, true);
            return true;
        }
        if (!inGrailsTagArgValue && text.charAt(caret - 1) == '!') {
            if (text.length() > caret && text.charAt(caret) == '}') {
                return false;
            }
            EditorModificationUtil.insertStringAtCaret((Editor)editor, (String)"{}!");
            editor.getCaretModel().moveCaretRelatively(-2, 0, false, false, true);
            PsiDocumentManager.getInstance((Project)project).commitDocument(editor.getDocument());
            handler.execute(editor, DataManager.getInstance().getDataContext((Component)editor.getContentComponent()));
            GspEditorActionsUtil.insertSpacesByGspIndent(editor, project);
            return true;
        }
        return false;
    }

    private static boolean handleJspLikeEqualTyped(Editor editor, CharSequence text, int caret) {
        if (caret < 2 || text.length() < Math.min(caret - 2, 2)) {
            return false;
        }
        if (text.charAt(caret - 1) == '%' && text.charAt(caret - 2) == '<') {
            if (text.length() > caret && text.charAt(caret) == '%') {
                return false;
            }
            EditorModificationUtil.insertStringAtCaret((Editor)editor, (String)"=  %>");
            editor.getCaretModel().moveCaretRelatively(-3, 0, false, false, true);
            return true;
        }
        return false;
    }

    private static boolean handleJspLikeDirectiveTyped(Editor editor, CharSequence text, int caret) {
        if (caret < 2 || text.length() < Math.min(caret - 2, 2)) {
            return false;
        }
        if (text.charAt(caret - 1) == '%' && text.charAt(caret - 2) == '<') {
            if (text.length() > caret && text.charAt(caret) == '%') {
                return false;
            }
            EditorModificationUtil.insertStringAtCaret((Editor)editor, (String)"@  %>");
            editor.getCaretModel().moveCaretRelatively(-3, 0, false, false, true);
            return true;
        }
        return false;
    }

    private static boolean handleJspLikeDeclarationTyped(Editor editor, CharSequence text, int caret) {
        if (caret < 2 || text.length() < Math.min(caret - 2, 2)) {
            return false;
        }
        if (text.charAt(caret - 1) == '%' && text.charAt(caret - 2) == '<') {
            if (text.length() > caret && text.charAt(caret) == '%') {
                return false;
            }
            EditorModificationUtil.insertStringAtCaret((Editor)editor, (String)"!  %>");
            editor.getCaretModel().moveCaretRelatively(-3, 0, false, false, true);
            return true;
        }
        return false;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 4: 
            case 5: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 4: 
            case 5: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "editor";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fileType";
                break;
            }
            case 4: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/plugins/grails/lang/gsp/editor/actions/GspTypedHandler";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/plugins/grails/lang/gsp/editor/actions/GspTypedHandler";
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "beforeCharTyped";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "beforeCharTyped";
                break;
            }
            case 4: 
            case 5: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 4: 
            case 5: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

