/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.grails.lang.gsp.editor.actions;

import com.intellij.application.options.CodeStyle;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.EditorModificationUtil;
import com.intellij.openapi.editor.highlighter.HighlighterIterator;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.tree.IElementType;
import org.jetbrains.plugins.grails.fileType.GspFileType;
import org.jetbrains.plugins.grails.lang.gsp.lexer.GspTokenTypesEx;
import org.jetbrains.plugins.groovy.lang.lexer.GroovyElementType;
import org.jetbrains.plugins.groovy.lang.lexer.GroovyTokenTypes;

public class GspEditorActionsUtil {
    private GspEditorActionsUtil() {
    }

    public static void insertSpacesByGspIndent(Editor editor, Project project) {
        int indentSize = CodeStyle.getSettings((Editor)editor).getIndentSize((FileType)GspFileType.GSP_FILE_TYPE);
        EditorModificationUtil.insertStringAtCaret((Editor)editor, (String)StringUtil.repeatSymbol((char)' ', (int)indentSize));
    }

    public static boolean areSciptletSeparatorsUnbalanced(HighlighterIterator iterator) {
        IElementType firstElementType = iterator.getTokenType();
        assert (firstElementType == GspTokenTypesEx.JSCRIPT_BEGIN || firstElementType == GspTokenTypesEx.GSCRIPT_BEGIN);
        iterator.advance();
        IElementType prev = null;
        while (!iterator.atEnd()) {
            IElementType element = iterator.getTokenType();
            if (element instanceof GroovyElementType) {
                if (element == GroovyTokenTypes.mMOD && prev == GroovyTokenTypes.mLT || element == GroovyTokenTypes.mLCURLY && prev == GroovyTokenTypes.mMOD || element == GroovyTokenTypes.mMOD_ASSIGN && prev == GroovyTokenTypes.mLT) {
                    return true;
                }
            } else if (element == GspTokenTypesEx.JSCRIPT_END || element == GspTokenTypesEx.GSCRIPT_END || element == GspTokenTypesEx.JEXPR_BEGIN) {
                return false;
            }
            prev = element;
            iterator.advance();
        }
        return true;
    }
}

