/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.grails.gson;

import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ProjectFileIndex;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.psi.search.GlobalSearchScope;
import com.sun.jdi.ReferenceType;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.Regex;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.grails.gson.GsonUtilsKt;
import org.jetbrains.plugins.grails.structure.GrailsApplication;
import org.jetbrains.plugins.grails.structure.GrailsApplicationManager;
import org.jetbrains.plugins.groovy.extensions.debugger.ScriptPositionManagerHelper;
import org.jetbrains.plugins.groovy.lang.psi.GroovyFile;

@Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000B\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0004\u0018\u0000 \u00172\u00020\u0001:\u0001\u0017B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0012\u0010\u0003\u001a\u0004\u0018\u00010\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0016J*\u0010\u0007\u001a\u0004\u0018\u00010\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\u00042\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000fH\u0016J\u0012\u0010\u0010\u001a\u0004\u0018\u00010\u00042\u0006\u0010\u0011\u001a\u00020\u0012H\u0016J\u0010\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u000b\u001a\u00020\u0004H\u0016J\u0010\u0010\u0015\u001a\u00020\u00142\u0006\u0010\u0016\u001a\u00020\u0012H\u0016\u00a8\u0006\u0018"}, d2={"Lorg/jetbrains/plugins/grails/gson/GsonPositionManagerDelegate;", "Lorg/jetbrains/plugins/groovy/extensions/debugger/ScriptPositionManagerHelper;", "()V", "customizeClassName", "", "psiClass", "Lcom/intellij/psi/PsiClass;", "getExtraScriptIfNotFound", "Lcom/intellij/psi/PsiFile;", "refType", "Lcom/sun/jdi/ReferenceType;", "runtimeName", "project", "Lcom/intellij/openapi/project/Project;", "scope", "Lcom/intellij/psi/search/GlobalSearchScope;", "getRuntimeScriptName", "groovyFile", "Lorg/jetbrains/plugins/groovy/lang/psi/GroovyFile;", "isAppropriateRuntimeName", "", "isAppropriateScriptFile", "scriptFile", "Companion", "intellij.groovy.grails"})
public final class GsonPositionManagerDelegate
extends ScriptPositionManagerHelper {
    private static final String suffix = "_gson";
    public static final Companion Companion = new Companion(null);

    public boolean isAppropriateScriptFile(@NotNull GroovyFile scriptFile) {
        Intrinsics.checkParameterIsNotNull((Object)scriptFile, (String)"scriptFile");
        return GsonUtilsKt.isGsonFile((PsiFile)scriptFile) && GrailsApplicationManager.findApplication((PsiElement)scriptFile) != null;
    }

    @Nullable
    public String getRuntimeScriptName(@NotNull GroovyFile groovyFile) {
        Intrinsics.checkParameterIsNotNull((Object)groovyFile, (String)"groovyFile");
        GrailsApplication grailsApplication2 = GrailsApplicationManager.findApplication((PsiElement)groovyFile);
        if (grailsApplication2 == null) {
            return null;
        }
        Intrinsics.checkExpressionValueIsNotNull((Object)grailsApplication2, (String)"GrailsApplicationManager\u2026roovyFile) ?: return null");
        GrailsApplication application = grailsApplication2;
        VirtualFile virtualFile = groovyFile.getVirtualFile();
        if (virtualFile == null) {
            return null;
        }
        VirtualFile file = virtualFile;
        VirtualFile virtualFile2 = ProjectFileIndex.SERVICE.getInstance((Project)groovyFile.getProject()).getSourceRootForFile(file);
        if (virtualFile2 == null) {
            return null;
        }
        Intrinsics.checkExpressionValueIsNotNull((Object)virtualFile2, (String)"ProjectFileIndex.SERVICE\u2026File(file) ?: return null");
        VirtualFile viewsRoot = virtualFile2;
        String string = VfsUtilCore.getRelativePath((VirtualFile)file, (VirtualFile)viewsRoot);
        if (string == null) {
            return null;
        }
        Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"VfsUtilCore.getRelativeP\u2026viewsRoot) ?: return null");
        String path = string;
        return GsonPositionManagerDelegate.Companion.clean(application.getName()) + "_" + StringsKt.replace$default((String)StringsKt.replace$default((String)path, (String)"/", (String)"_", (boolean)false, (int)4, null), (String)".", (String)"_", (boolean)false, (int)4, null);
    }

    public boolean isAppropriateRuntimeName(@NotNull String runtimeName) {
        Intrinsics.checkParameterIsNotNull((Object)runtimeName, (String)"runtimeName");
        return StringsKt.endsWith$default((String)runtimeName, (String)suffix, (boolean)false, (int)2, null);
    }

    @Nullable
    public String customizeClassName(@NotNull PsiClass psiClass) {
        String string;
        Intrinsics.checkParameterIsNotNull((Object)psiClass, (String)"psiClass");
        PsiFile psiFile = psiClass.getContainingFile();
        if (!(psiFile instanceof GroovyFile)) {
            psiFile = null;
        }
        GroovyFile groovyFile = (GroovyFile)psiFile;
        if (groovyFile != null) {
            GroovyFile groovyFile2;
            GroovyFile it = groovyFile2 = groovyFile;
            string = this.getRuntimeScriptName(it);
        } else {
            string = null;
        }
        return string;
    }

    @Nullable
    public PsiFile getExtraScriptIfNotFound(@NotNull ReferenceType refType, @NotNull String runtimeName, @NotNull Project project, @NotNull GlobalSearchScope scope2) {
        Intrinsics.checkParameterIsNotNull((Object)refType, (String)"refType");
        Intrinsics.checkParameterIsNotNull((Object)runtimeName, (String)"runtimeName");
        Intrinsics.checkParameterIsNotNull((Object)project, (String)"project");
        Intrinsics.checkParameterIsNotNull((Object)scope2, (String)"scope");
        String appNameAndViewPath = StringsKt.removeSuffix((String)runtimeName, (CharSequence)suffix);
        GrailsApplicationManager grailsApplicationManager = GrailsApplicationManager.getInstance(project);
        Intrinsics.checkExpressionValueIsNotNull((Object)grailsApplicationManager, (String)"GrailsApplicationManager.getInstance(project)");
        for (GrailsApplication app : grailsApplicationManager.getApplications()) {
            PsiFile psiFile;
            VirtualFile view;
            String viewPath = StringsKt.replace$default((String)StringsKt.removePrefix((String)appNameAndViewPath, (CharSequence)GsonPositionManagerDelegate.Companion.clean(app.getName())), (String)"_", (String)"/", (boolean)false, (int)4, null);
            String viewFilePath = "views" + viewPath + ".gson";
            if (app.getAppRoot().findFileByRelativePath(viewFilePath) == null) {
                continue;
            }
            Intrinsics.checkExpressionValueIsNotNull((Object)view, (String)"app.appRoot.findFileByRe\u2026viewFilePath) ?: continue");
            if (!scope2.contains(view)) continue;
            PsiFile psiFile2 = PsiManager.getInstance((Project)project).findFile(view);
            if (psiFile2 == null) continue;
            PsiFile it = psiFile = psiFile2;
            return it;
        }
        return null;
    }

    @Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\f\u0010\u0005\u001a\u00020\u0004*\u00020\u0004H\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0006"}, d2={"Lorg/jetbrains/plugins/grails/gson/GsonPositionManagerDelegate$Companion;", "", "()V", "suffix", "", "clean", "intellij.groovy.grails"})
    public static final class Companion {
        private final String clean(@NotNull String $receiver) {
            CharSequence charSequence = $receiver;
            String string = "[\\W\\s]";
            string = new Regex(string);
            String string2 = "_";
            return string.replace(charSequence, string2);
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

