/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.j2meplugin.util;

import com.intellij.execution.configurations.ConfigurationUtil;
import com.intellij.ide.util.TreeClassChooser;
import com.intellij.ide.util.TreeClassChooserFactory;
import com.intellij.j2meplugin.J2MEBundle;
import com.intellij.j2meplugin.module.J2MEModuleProperties;
import com.intellij.j2meplugin.module.settings.MobileApplicationType;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.TextFieldWithBrowseButton;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiClass;
import com.intellij.psi.search.GlobalSearchScope;
import org.jetbrains.annotations.NotNull;

public class J2MEClassBrowser {
    private final TreeClassChooser myClassChooser;

    public J2MEClassBrowser(@NotNull Module module) {
        if (module == null) {
            J2MEClassBrowser.$$$reportNull$$$0(0);
        }
        MobileApplicationType mobileApplicationType = J2MEModuleProperties.getInstance(module).getMobileApplicationType();
        PsiClass psiClass = JavaPsiFacade.getInstance((Project)module.getProject()).findClass(mobileApplicationType.getBaseClassName(), GlobalSearchScope.moduleWithLibrariesScope((Module)module));
        this.myClassChooser = TreeClassChooserFactory.getInstance((Project)module.getProject()).createInheritanceClassChooser(J2MEBundle.message("run.configuration.klass.to.start", mobileApplicationType.getPresentableClassName()), GlobalSearchScope.moduleScope((Module)module), psiClass, false, false, ConfigurationUtil.PUBLIC_INSTANTIATABLE_CLASS);
    }

    public void show() {
        this.myClassChooser.showDialog();
    }

    public void setField(TextFieldWithBrowseButton field) {
        PsiClass selectedClass = this.myClassChooser.getSelected();
        if (selectedClass != null) {
            field.setText(selectedClass.getQualifiedName());
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "module", "com/intellij/j2meplugin/util/J2MEClassBrowser", "<init>"));
    }
}

