/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.j2meplugin.emulator.midp.wtk;

import com.intellij.j2meplugin.emulator.Emulator;
import com.intellij.j2meplugin.emulator.MobileSdkUtil;
import com.intellij.j2meplugin.emulator.midp.MIDPEmulatorType;
import com.intellij.j2meplugin.emulator.midp.wtk.ConfigurationUtil;
import com.intellij.j2meplugin.emulator.ui.MobileApiSettingsEditor;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.options.ConfigurationException;
import com.intellij.openapi.projectRoots.Sdk;
import com.intellij.openapi.projectRoots.SdkModificator;
import com.intellij.openapi.roots.OrderRootType;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.vfs.VfsUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.uiDesigner.core.GridConstraints;
import com.intellij.uiDesigner.core.GridLayoutManager;
import com.intellij.util.containers.ContainerUtil;
import java.awt.Component;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.util.ArrayList;
import java.util.Properties;
import java.util.ResourceBundle;
import javax.swing.AbstractButton;
import javax.swing.ButtonGroup;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import org.jetbrains.annotations.NotNull;

class WTKApiEditor
extends MobileApiSettingsEditor {
    private JComboBox myProfile;
    private final DefaultComboBoxModel myProfilesModel;
    private JComboBox myConfiguration;
    private final DefaultComboBoxModel myConfigurationsModel;
    private JPanel myMIDPPanel;
    private JRadioButton myDefaultConfigs;
    private JRadioButton myCustomConfigs;
    private JLabel myDefaultProfile;
    private JLabel myDefaultConfig;
    private final MIDPEmulatorType myMIDPType;
    private final Sdk mySdk;
    private final SdkModificator mySdkModificator;
    private static final Logger LOG = Logger.getInstance(WTKApiEditor.class);

    WTKApiEditor(MIDPEmulatorType type, Sdk sdk, SdkModificator sdkModificator) {
        this.$$$setupUI$$$();
        this.myProfilesModel = new DefaultComboBoxModel();
        this.myConfigurationsModel = new DefaultComboBoxModel();
        this.myMIDPType = type;
        this.mySdk = sdk;
        this.mySdkModificator = sdkModificator;
    }

    @Override
    @NotNull
    public JComponent createEditor() {
        this.myProfile.setModel(this.myProfilesModel);
        this.myConfiguration.setModel(this.myConfigurationsModel);
        ButtonGroup useConfigs = new ButtonGroup();
        useConfigs.add(this.myDefaultConfigs);
        useConfigs.add(this.myCustomConfigs);
        this.myDefaultConfigs.setSelected(true);
        this.myProfilesModel.removeAllElements();
        String[] profiles = this.myMIDPType.getAvailableProfiles(this.mySdk.getHomePath());
        for (int i = 0; profiles != null && i < profiles.length; ++i) {
            this.myProfilesModel.addElement(profiles[i]);
        }
        this.myConfigurationsModel.removeAllElements();
        String[] configurations = this.myMIDPType.getAvailableConfigurations(this.mySdk.getHomePath());
        for (int i = 0; configurations != null && i < configurations.length; ++i) {
            this.myConfigurationsModel.addElement(configurations[i]);
        }
        this.myDefaultConfigs.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (!WTKApiEditor.this.myDefaultConfigs.isSelected()) {
                    return;
                }
                WTKApiEditor.this.doStateChanged(true);
                WTKApiEditor.this.myModified = true;
            }
        });
        ActionListener changeRoots = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (!WTKApiEditor.this.myCustomConfigs.isSelected()) {
                    return;
                }
                WTKApiEditor.this.doStateChanged(false);
                WTKApiEditor.this.myModified = true;
            }
        };
        this.myCustomConfigs.addActionListener(changeRoots);
        this.myProfile.addActionListener(changeRoots);
        this.myConfiguration.addActionListener(changeRoots);
        JPanel jPanel = this.myMIDPPanel;
        if (jPanel == null) {
            WTKApiEditor.$$$reportNull$$$0(0);
        }
        return jPanel;
    }

    private void doStateChanged(boolean isDefault) {
        VirtualFile[] jarsToAdd;
        VirtualFile[] jarsToRemove = this.getJarsToRemove();
        if (jarsToRemove != null) {
            for (VirtualFile jarToRemove : jarsToRemove) {
                this.mySdkModificator.removeRoot(jarToRemove, OrderRootType.CLASSES);
            }
        }
        if ((jarsToAdd = this.getJarsToAdd(isDefault)) != null) {
            for (VirtualFile jarToAdd : jarsToAdd) {
                this.mySdkModificator.addRoot(jarToAdd, OrderRootType.CLASSES);
            }
        }
    }

    @Override
    public void resetEditorFrom(@NotNull Emulator emulator) {
        MIDPEmulatorType midpEmulatorType;
        if (emulator == null) {
            WTKApiEditor.$$$reportNull$$$0(1);
        }
        LOG.assertTrue((midpEmulatorType = (MIDPEmulatorType)emulator.getEmulatorType()) != null);
        String defaultProfile = midpEmulatorType.getDefaultProfile(emulator.getHome());
        this.myDefaultProfile.setText(defaultProfile);
        String defaultConfiguration = midpEmulatorType.getDefaultConfiguration(emulator.getHome());
        this.myDefaultConfig.setText(defaultConfiguration);
        if (Comparing.equal((String)defaultProfile, (String)emulator.getProfile()) && Comparing.equal((String)defaultConfiguration, (String)emulator.getConfiguration()) || emulator.getProfile() == null || emulator.getConfiguration() == null) {
            this.myDefaultConfigs.setSelected(true);
        } else {
            this.myCustomConfigs.setSelected(true);
        }
        this.myProfile.setSelectedItem(emulator.getCustomProfile());
        this.myConfiguration.setSelectedItem(emulator.getCustomConfiguration());
        this.myModified = false;
    }

    @Override
    public void applyEditorTo(@NotNull Emulator emulator) throws ConfigurationException {
        if (emulator == null) {
            WTKApiEditor.$$$reportNull$$$0(2);
        }
        if (this.myCustomConfigs.isSelected()) {
            emulator.setProfile((String)this.myProfile.getSelectedItem());
            emulator.setConfiguration((String)this.myConfiguration.getSelectedItem());
        } else {
            emulator.setProfile(this.myDefaultProfile.getText());
            emulator.setConfiguration(this.myDefaultConfig.getText());
        }
        emulator.setCustomProfile((String)this.myProfile.getSelectedItem());
        emulator.setCustomConfiguration((String)this.myConfiguration.getSelectedItem());
        this.myModified = false;
    }

    private VirtualFile getJarBySettingName(String settingName, String homePath) {
        Properties apiSettings = ConfigurationUtil.getApiSettings(homePath);
        if (apiSettings == null || apiSettings.isEmpty()) {
            return null;
        }
        String jar = apiSettings.getProperty(settingName.replaceAll("-", "") + ".file");
        if (jar != null) {
            VirtualFile[] apiClasses = MobileSdkUtil.findApiClasses(new String[]{homePath + File.separator + "lib" + File.separator + jar});
            if (apiClasses == null || apiClasses.length == 0) {
                return null;
            }
            return apiClasses[0];
        }
        return null;
    }

    private VirtualFile[] getJarsToRemove() {
        int i;
        String homePath = this.mySdk.getHomePath();
        ArrayList<VirtualFile> result = new ArrayList<VirtualFile>();
        for (i = 0; i < this.myProfilesModel.getSize(); ++i) {
            result.add(this.getJarBySettingName((String)this.myProfilesModel.getElementAt(i), homePath));
        }
        for (i = 0; i < this.myConfigurationsModel.getSize(); ++i) {
            result.add(this.getJarBySettingName((String)this.myConfigurationsModel.getElementAt(i), homePath));
        }
        ContainerUtil.addAll(result, (Object[])this.getJarsToAdd(true));
        return VfsUtil.toVirtualFileArray(result);
    }

    private VirtualFile[] getJarsToAdd(boolean isDefault) {
        String homePath = this.mySdk.getHomePath();
        if (isDefault) {
            return new VirtualFile[]{this.getJarBySettingName(this.myDefaultProfile.getText(), homePath), this.getJarBySettingName(this.myDefaultConfig.getText(), homePath)};
        }
        if (this.myProfile.getSelectedItem() == null || this.myConfiguration.getSelectedItem() == null) {
            return null;
        }
        return new VirtualFile[]{this.getJarBySettingName((String)this.myProfile.getSelectedItem(), homePath), this.getJarBySettingName((String)this.myConfiguration.getSelectedItem(), homePath)};
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 1: 
            case 2: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 1: 
            case 2: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/j2meplugin/emulator/midp/wtk/WTKApiEditor";
                break;
            }
            case 1: 
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "emulator";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "createEditor";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/j2meplugin/emulator/midp/wtk/WTKApiEditor";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "resetEditorFrom";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "applyEditorTo";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 1: 
            case 2: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private /* synthetic */ void $$$setupUI$$$() {
        JComboBox jComboBox;
        JComboBox jComboBox2;
        JLabel jLabel;
        JLabel jLabel2;
        JRadioButton jRadioButton;
        JRadioButton jRadioButton2;
        JPanel jPanel;
        this.myMIDPPanel = jPanel = new JPanel();
        jPanel.setLayout((LayoutManager)new GridLayoutManager(4, 3, new Insets(2, 0, 2, 0), -1, -1, false, false));
        JLabel jLabel3 = new JLabel();
        this.$$$loadLabelText$$$(jLabel3, ResourceBundle.getBundle("com/intellij/j2meplugin/J2MEBundle").getString("emulator.profile.version"));
        jPanel.add((Component)jLabel3, new GridConstraints(2, 1, 1, 1, 8, 0, 0, 0, null, null, null));
        JLabel jLabel4 = new JLabel();
        this.$$$loadLabelText$$$(jLabel4, ResourceBundle.getBundle("com/intellij/j2meplugin/J2MEBundle").getString("emulator.configuration.version"));
        jPanel.add((Component)jLabel4, new GridConstraints(3, 1, 1, 1, 8, 0, 0, 0, null, null, null));
        this.myCustomConfigs = jRadioButton2 = new JRadioButton();
        this.$$$loadButtonText$$$(jRadioButton2, ResourceBundle.getBundle("com/intellij/j2meplugin/J2MEBundle").getString("emulator.custom.profile.configuration.versions"));
        jPanel.add((Component)jRadioButton2, new GridConstraints(2, 0, 2, 1, 8, 0, 3, 0, null, null, null));
        this.myDefaultConfigs = jRadioButton = new JRadioButton();
        this.$$$loadButtonText$$$(jRadioButton, ResourceBundle.getBundle("com/intellij/j2meplugin/J2MEBundle").getString("emulator.default.profile.configuration.versions"));
        jPanel.add((Component)jRadioButton, new GridConstraints(0, 0, 2, 1, 8, 0, 3, 0, null, null, null));
        this.myDefaultProfile = jLabel2 = new JLabel();
        jLabel2.setText("");
        jPanel.add((Component)jLabel2, new GridConstraints(0, 2, 1, 1, 8, 0, 0, 0, null, null, null));
        this.myDefaultConfig = jLabel = new JLabel();
        jLabel.setText("");
        jPanel.add((Component)jLabel, new GridConstraints(1, 2, 1, 1, 8, 0, 0, 0, null, null, null));
        JLabel jLabel5 = new JLabel();
        this.$$$loadLabelText$$$(jLabel5, ResourceBundle.getBundle("com/intellij/j2meplugin/J2MEBundle").getString("emulator.profile.version"));
        jPanel.add((Component)jLabel5, new GridConstraints(0, 1, 1, 1, 8, 0, 0, 0, null, null, null));
        JLabel jLabel6 = new JLabel();
        this.$$$loadLabelText$$$(jLabel6, ResourceBundle.getBundle("com/intellij/j2meplugin/J2MEBundle").getString("emulator.configuration.version"));
        jPanel.add((Component)jLabel6, new GridConstraints(1, 1, 1, 1, 8, 0, 0, 0, null, null, null));
        this.myProfile = jComboBox2 = new JComboBox();
        jPanel.add(jComboBox2, new GridConstraints(2, 2, 1, 1, 8, 1, 2, 0, null, null, null));
        this.myConfiguration = jComboBox = new JComboBox();
        jPanel.add(jComboBox, new GridConstraints(3, 2, 1, 1, 8, 1, 2, 0, null, null, null));
    }

    public /* synthetic */ JComponent $$$getRootComponent$$$() {
        return this.myMIDPPanel;
    }

    private /* synthetic */ void $$$loadLabelText$$$(JLabel jLabel, String string) {
        StringBuffer stringBuffer = new StringBuffer();
        boolean bl = false;
        char c = '\u0000';
        int n = -1;
        for (int i = 0; i < string.length(); ++i) {
            if (string.charAt(i) == '&') {
                if (++i == string.length()) break;
                if (!bl && string.charAt(i) != '&') {
                    bl = true;
                    c = string.charAt(i);
                    n = stringBuffer.length();
                }
            }
            stringBuffer.append(string.charAt(i));
        }
        jLabel.setText(stringBuffer.toString());
        if (bl) {
            jLabel.setDisplayedMnemonic(c);
            jLabel.setDisplayedMnemonicIndex(n);
        }
    }

    private /* synthetic */ void $$$loadButtonText$$$(AbstractButton abstractButton, String string) {
        StringBuffer stringBuffer = new StringBuffer();
        boolean bl = false;
        char c = '\u0000';
        int n = -1;
        for (int i = 0; i < string.length(); ++i) {
            if (string.charAt(i) == '&') {
                if (++i == string.length()) break;
                if (!bl && string.charAt(i) != '&') {
                    bl = true;
                    c = string.charAt(i);
                    n = stringBuffer.length();
                }
            }
            stringBuffer.append(string.charAt(i));
        }
        abstractButton.setText(stringBuffer.toString());
        if (bl) {
            abstractButton.setMnemonic(c);
            abstractButton.setDisplayedMnemonicIndex(n);
        }
    }
}

