/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.j2meplugin.emulator.doja;

import com.intellij.execution.Executor;
import com.intellij.execution.configurations.ConfigurationPerRunnerSettings;
import com.intellij.execution.configurations.RunnerSettings;
import com.intellij.j2meplugin.emulator.EmulatorType;
import com.intellij.j2meplugin.run.J2MERunConfiguration;
import com.intellij.j2meplugin.run.J2MERunnableState;
import com.intellij.j2meplugin.run.states.doja.DOJARunnableState;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.projectRoots.Sdk;
import com.intellij.util.ArrayUtil;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Properties;
import org.jetbrains.annotations.NonNls;

public class DOJAEmulatorType
extends EmulatorType {
    @NonNls
    private static final String ABOUT_1_PROPERTY = "ABOUT_1";
    @NonNls
    private static final String MAIN_WINDOW_TITLE = "MAIN_WINDOW_TITLE";
    @NonNls
    private static final String LIB = "lib";

    @Override
    public String getName() {
        return "DoJa";
    }

    @Override
    public String getApplicationType() {
        return "DoJa";
    }

    @Override
    public String getDescriptorOption() {
        return "-i";
    }

    @Override
    public String getDeviceOption() {
        return "-s";
    }

    @Override
    public String getRelativePathToEmulator() {
        return "bin/doja_g";
    }

    @Override
    public String suggestName(String homePath) {
        return DOJAEmulatorType.getProperties(homePath).getProperty(ABOUT_1_PROPERTY);
    }

    private static Properties getProperties(String homePath) {
        File i18properties = new File(homePath + File.separator + LIB + File.separator + "i18n" + File.separator + "I18N.properties");
        Properties prop = new Properties();
        try {
            prop.load(new BufferedInputStream(new FileInputStream(i18properties)));
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return prop;
    }

    @Override
    public boolean isValidHomeDirectory(String homePath) {
        String property = DOJAEmulatorType.getProperties(homePath).getProperty(MAIN_WINDOW_TITLE);
        if (property == null) {
            return false;
        }
        return property.equals("iappliTool");
    }

    @Override
    public String[] getAvailableSkins(String homePath) {
        String skin = "skin";
        File skins = new File(new File(homePath, LIB), "skin");
        if (!skins.exists() || !skins.isDirectory()) {
            return new String[]{"device1", "device2", "device3"};
        }
        String[] strings = skins.list();
        ArrayList<String> devices = new ArrayList<String>();
        for (String device : strings) {
            if (!new File(skins, device).isDirectory()) continue;
            devices.add(device);
        }
        return ArrayUtil.toStringArray(devices);
    }

    @Override
    public J2MERunnableState getJ2MERunnableState(Executor executor, RunnerSettings runnerSettings, ConfigurationPerRunnerSettings configurationSetting, J2MERunConfiguration configuration, Project project, Sdk projectJdk) {
        return new DOJARunnableState(runnerSettings, configurationSetting, configuration, project, projectJdk);
    }
}

