/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.j2meplugin.emulator;

import com.intellij.openapi.vfs.JarFileSystem;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import java.io.File;
import java.io.FileFilter;
import java.util.ArrayList;
import java.util.Collections;
import org.jetbrains.annotations.NonNls;

public class MobileSdkUtil {
    @NonNls
    private static final String JAR_FILE_TYPE = ".jar";
    @NonNls
    private static final String ZIP_FILE_TYPE = ".zip";
    @NonNls
    private static final String EXT_DIR = "ext";

    public static VirtualFile[] findApiClasses(String[] api) {
        JarFileSystem jarFileSystem = JarFileSystem.getInstance();
        ArrayList<VirtualFile> result = new ArrayList<VirtualFile>();
        for (int i = 0; api != null && i < api.length; ++i) {
            File child = new File(api[i]);
            String path = child.getAbsolutePath().replace(File.separatorChar, '/') + "!/";
            jarFileSystem.setNoCopyJarForPath(path);
            VirtualFile vFile = jarFileSystem.findFileByPath(path);
            if (vFile == null) continue;
            result.add(vFile);
        }
        return VfsUtilCore.toVirtualFileArray(result);
    }

    public static VirtualFile[] findApiClasses(File file) {
        FileFilter jarFileFilter = f -> {
            if (f.isDirectory()) {
                return false;
            }
            return f.getName().endsWith(JAR_FILE_TYPE) || f.getName().endsWith(ZIP_FILE_TYPE);
        };
        String libDirName = "lib";
        File lib = new File(file, "lib");
        File[] jarDirs = new File[]{lib, new File(lib, EXT_DIR)};
        ArrayList childrenList = new ArrayList();
        for (File jarDir : jarDirs) {
            File[] files;
            if (jarDir == null || !jarDir.isDirectory() || (files = jarDir.listFiles(jarFileFilter)) == null) continue;
            Collections.addAll(childrenList, files);
        }
        JarFileSystem jarFileSystem = JarFileSystem.getInstance();
        ArrayList<VirtualFile> result = new ArrayList<VirtualFile>();
        for (File child : childrenList) {
            String path = child.getAbsolutePath().replace(File.separatorChar, '/') + "!/";
            jarFileSystem.setNoCopyJarForPath(path);
            VirtualFile vFile = jarFileSystem.findFileByPath(path);
            if (vFile == null) continue;
            result.add(vFile);
        }
        return VfsUtilCore.toVirtualFileArray(result);
    }

    public static void findDocs(File root, ArrayList<? super VirtualFile> docs) {
        if (!root.exists() || !root.isDirectory()) {
            return;
        }
        File[] docFiles = root.listFiles(MobileSdkUtil::isDocRoot);
        if (docFiles != null && docFiles.length > 0) {
            String path = root.getAbsolutePath().replace(File.separatorChar, '/');
            docs.add((VirtualFile)LocalFileSystem.getInstance().findFileByPath(path));
        }
        File[] children = root.listFiles(pathname -> !MobileSdkUtil.isDocRoot(pathname));
        for (int i = 0; children != null && i < children.length; ++i) {
            MobileSdkUtil.findDocs(children[i], docs);
        }
    }

    private static boolean isDocRoot(File pathname) {
        String path = pathname.getPath();
        return path.endsWith("index.htm") || path.endsWith("index.html");
    }
}

