/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.j2meplugin.compiler.ant;

import com.intellij.compiler.ant.BuildProperties;
import com.intellij.compiler.ant.Generator;
import com.intellij.compiler.ant.ModuleChunk;
import com.intellij.compiler.ant.Tag;
import com.intellij.compiler.ant.taskdefs.Target;
import com.intellij.j2meplugin.J2MEBundle;
import com.intellij.j2meplugin.compiler.ant.J2MEBuildProperties;
import com.intellij.j2meplugin.emulator.Emulator;
import com.intellij.j2meplugin.emulator.EmulatorType;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.projectRoots.Sdk;
import com.intellij.openapi.projectRoots.SdkAdditionalData;
import com.intellij.openapi.roots.OrderEnumerator;
import com.intellij.openapi.util.Pair;
import com.intellij.util.PathsList;
import org.jetbrains.annotations.NonNls;

public class PreverifyTarget
extends Target {
    public PreverifyTarget(ModuleChunk chunk) {
        super(J2MEBuildProperties.getPreverifyTargetName(chunk.getName()), null, J2MEBundle.message("ant.preverify.description", chunk.getName()), null);
        String emulatorPreverifyPath;
        Emulator emulator;
        EmulatorType emulatorType;
        SdkAdditionalData additionalData;
        Sdk projectJdk = chunk.getJdk();
        if (projectJdk != null && (additionalData = projectJdk.getSdkAdditionalData()) instanceof Emulator && (emulatorType = (emulator = (Emulator)additionalData).getEmulatorType()) != null && (emulatorPreverifyPath = emulatorType.getPreverifyPath()) != null) {
            Module[] modules;
            String preverifyPath = BuildProperties.propertyRef((String)BuildProperties.getJdkHomeProperty((String)projectJdk.getName())) + "/" + emulatorPreverifyPath;
            Tag preverifyTag = new Tag("exec", new Pair[]{PreverifyTarget.pair((String)"executable", (String)preverifyPath)});
            preverifyTag.add((Generator)new Arg("-d " + BuildProperties.propertyRef((String)BuildProperties.getTempDirForModuleProperty((String)chunk.getName()))));
            PathsList classpath = new PathsList();
            classpath.add(BuildProperties.propertyRef((String)BuildProperties.getModuleChunkJdkClasspathProperty((String)chunk.getName())));
            for (Module module : modules = chunk.getModules()) {
                OrderEnumerator.orderEntries((Module)module).librariesOnly().classes().collectPaths(classpath);
            }
            preverifyTag.add((Generator)new Arg("-classpath " + classpath.toString()));
            for (Module module : modules) {
                preverifyTag.add((Generator)new Arg(BuildProperties.propertyRef((String)BuildProperties.getOutputPathProperty((String)module.getName()))));
            }
            this.add((Generator)preverifyTag);
        }
    }

    private static class Arg
    extends Tag {
        Arg(@NonNls String value) {
            super("arg", new Pair[]{Arg.pair((String)"line", (String)value)});
        }
    }
}

