/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.aspectj.psi.stub;

import com.intellij.lang.ASTNode;
import com.intellij.lang.LighterAST;
import com.intellij.lang.LighterASTNode;
import com.intellij.lang.aspectj.index.stub.AjInterTypeClassIndex;
import com.intellij.lang.aspectj.index.stub.AjShortClassNameIndex;
import com.intellij.lang.aspectj.parsing.AspectJElementType;
import com.intellij.lang.aspectj.psi.PsiInterTypeClass;
import com.intellij.lang.aspectj.psi.impl.PsiInterTypeClassImpl;
import com.intellij.lang.aspectj.psi.stub.AjStubElementType;
import com.intellij.lang.aspectj.psi.stub.PsiInterTypeClassStub;
import com.intellij.lang.aspectj.psi.stub.impl.PsiInterTypeClassStubImpl;
import com.intellij.lang.aspectj.psi.stub.impl.StubBaseWithFlags;
import com.intellij.lang.aspectj.psi.tree.InterTypeClassElement;
import com.intellij.psi.JavaTokenType;
import com.intellij.psi.impl.cache.RecordUtil;
import com.intellij.psi.impl.java.stubs.index.JavaStubIndexKeys;
import com.intellij.psi.impl.source.tree.JavaDocElementType;
import com.intellij.psi.impl.source.tree.JavaElementType;
import com.intellij.psi.stubs.IndexSink;
import com.intellij.psi.stubs.StubElement;
import com.intellij.psi.stubs.StubInputStream;
import com.intellij.psi.stubs.StubOutputStream;
import com.intellij.psi.tree.IElementType;
import com.intellij.util.CharTable;
import java.io.IOException;
import org.jetbrains.annotations.NotNull;

public class AjClassElementType
extends AjStubElementType<PsiInterTypeClassStub, PsiInterTypeClass> {
    public AjClassElementType() {
        super("INTER_TYPE_CLASS");
    }

    @NotNull
    public ASTNode createCompositeNode() {
        InterTypeClassElement interTypeClassElement = new InterTypeClassElement();
        if (interTypeClassElement == null) {
            AjClassElementType.$$$reportNull$$$0(0);
        }
        return interTypeClassElement;
    }

    public PsiInterTypeClass createPsi(@NotNull PsiInterTypeClassStub stub) {
        if (stub == null) {
            AjClassElementType.$$$reportNull$$$0(1);
        }
        return new PsiInterTypeClassImpl(stub);
    }

    @Override
    public PsiInterTypeClass createPsi(ASTNode node) {
        return new PsiInterTypeClassImpl(node);
    }

    @NotNull
    public PsiInterTypeClassStub createStub(@NotNull LighterAST tree, @NotNull LighterASTNode node, @NotNull StubElement parentStub) {
        if (tree == null) {
            AjClassElementType.$$$reportNull$$$0(2);
        }
        if (node == null) {
            AjClassElementType.$$$reportNull$$$0(3);
        }
        if (parentStub == null) {
            AjClassElementType.$$$reportNull$$$0(4);
        }
        boolean isDeprecatedByComment = false;
        boolean hasDeprecatedAnnotation = false;
        boolean hasDocComment = false;
        String className = null;
        String name = null;
        for (LighterASTNode child : tree.getChildren(node)) {
            IElementType type = child.getTokenType();
            if (type == JavaDocElementType.DOC_COMMENT) {
                hasDocComment = true;
                isDeprecatedByComment = RecordUtil.isDeprecatedByDocComment((LighterAST)tree, (LighterASTNode)child);
                continue;
            }
            if (type == JavaElementType.MODIFIER_LIST) {
                hasDeprecatedAnnotation = RecordUtil.isDeprecatedByAnnotation((LighterAST)tree, (LighterASTNode)child);
                continue;
            }
            if (type == AspectJElementType.INTER_TYPE_REFERENCE) {
                className = AjClassElementType.getReferencedClassName(tree, child);
                continue;
            }
            if (type != JavaTokenType.IDENTIFIER) continue;
            name = RecordUtil.intern((CharTable)tree.getCharTable(), (LighterASTNode)child);
        }
        byte flags = StubBaseWithFlags.pack(isDeprecatedByComment, hasDeprecatedAnnotation, hasDocComment);
        PsiInterTypeClassStubImpl psiInterTypeClassStubImpl = new PsiInterTypeClassStubImpl(parentStub, className, name, flags);
        if (psiInterTypeClassStubImpl == null) {
            AjClassElementType.$$$reportNull$$$0(5);
        }
        return psiInterTypeClassStubImpl;
    }

    public void serialize(@NotNull PsiInterTypeClassStub stub, @NotNull StubOutputStream dataStream) throws IOException {
        if (stub == null) {
            AjClassElementType.$$$reportNull$$$0(6);
        }
        if (dataStream == null) {
            AjClassElementType.$$$reportNull$$$0(7);
        }
        dataStream.writeName(stub.getClassName());
        dataStream.writeName(stub.getName());
        dataStream.writeByte((int)((PsiInterTypeClassStubImpl)stub).getFlags());
    }

    @NotNull
    public PsiInterTypeClassStub deserialize(@NotNull StubInputStream dataStream, StubElement parentStub) throws IOException {
        if (dataStream == null) {
            AjClassElementType.$$$reportNull$$$0(8);
        }
        String className = dataStream.readNameString();
        String name = dataStream.readNameString();
        byte flags = dataStream.readByte();
        PsiInterTypeClassStubImpl psiInterTypeClassStubImpl = new PsiInterTypeClassStubImpl(parentStub, className, name, flags);
        if (psiInterTypeClassStubImpl == null) {
            AjClassElementType.$$$reportNull$$$0(9);
        }
        return psiInterTypeClassStubImpl;
    }

    public void indexStub(@NotNull PsiInterTypeClassStub stub, @NotNull IndexSink sink) {
        String className;
        String name;
        if (stub == null) {
            AjClassElementType.$$$reportNull$$$0(10);
        }
        if (sink == null) {
            AjClassElementType.$$$reportNull$$$0(11);
        }
        if ((name = stub.getName()) != null) {
            sink.occurrence(JavaStubIndexKeys.CLASS_SHORT_NAMES, (Object)name);
            sink.occurrence(AjShortClassNameIndex.KEY, (Object)name);
        }
        if ((className = stub.getClassName()) != null) {
            sink.occurrence(AjInterTypeClassIndex.KEY, (Object)className);
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 6: 
            case 7: 
            case 8: 
            case 10: 
            case 11: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 6: 
            case 7: 
            case 8: 
            case 10: 
            case 11: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/lang/aspectj/psi/stub/AjClassElementType";
                break;
            }
            case 1: 
            case 6: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "stub";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "tree";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "node";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parentStub";
                break;
            }
            case 7: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dataStream";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "sink";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "createCompositeNode";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 6: 
            case 7: 
            case 8: 
            case 10: 
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/lang/aspectj/psi/stub/AjClassElementType";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "createStub";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "deserialize";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "createPsi";
                break;
            }
            case 2: 
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "createStub";
                break;
            }
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "serialize";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "deserialize";
                break;
            }
            case 10: 
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "indexStub";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 6: 
            case 7: 
            case 8: 
            case 10: 
            case 11: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

