/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.aspectj.highlight.analysis.aspect;

import com.intellij.codeInsight.daemon.JavaErrorMessages;
import com.intellij.lang.annotation.AnnotationHolder;
import com.intellij.lang.aspectj.highlight.analysis.ElementAnnotator;
import com.intellij.lang.aspectj.psi.PsiAspect;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiJavaCodeReferenceElement;
import com.intellij.psi.PsiReferenceList;
import com.intellij.psi.PsiReferenceParameterList;

public class AspectFullyParameterizedAnnotator
extends ElementAnnotator<PsiAspect> {
    @Override
    public boolean annotate(AnnotationHolder holder, PsiAspect aspect) {
        PsiReferenceList extendsList = aspect.getExtendsList();
        if (extendsList == null) {
            return false;
        }
        PsiJavaCodeReferenceElement[] extendsRefs = extendsList.getReferenceElements();
        if (extendsRefs.length < 1) {
            return false;
        }
        PsiReferenceParameterList refParamList = extendsRefs[0].getParameterList();
        if (refParamList == null) {
            return false;
        }
        int actual = refParamList.getTypeParameterElements().length;
        PsiElement refTarget = extendsRefs[0].resolve();
        if (!(refTarget instanceof PsiAspect)) {
            return false;
        }
        PsiAspect superAspect = (PsiAspect)refTarget;
        int required = superAspect.getTypeParameters().length;
        if (required == actual) {
            return false;
        }
        holder.createErrorAnnotation((PsiElement)refParamList, JavaErrorMessages.message((String)"generics.wrong.number.of.type.arguments", (Object[])new Object[]{actual, required}));
        return false;
    }
}

