/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.chunkio;

import com.android.tools.chunkio.ChunkUtils;
import java.io.DataInput;
import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import java.io.UTFDataFormatException;
import java.util.Deque;
import java.util.LinkedList;

public final class RangedInputStream
extends InputStream
implements DataInput {
    private final byte[] scratch = new byte[8];
    private final CountingInputStream source;
    private StreamState currentState;
    private final Deque<StreamState> stack = new LinkedList<StreamState>();

    public RangedInputStream(InputStream in) {
        this.source = new CountingInputStream(in);
        this.currentState = new StreamState(-1L);
        this.stack.offerFirst(this.currentState);
    }

    public void pushRange(long byteCount) {
        this.currentState = new StreamState(byteCount);
        this.stack.offerFirst(this.currentState);
    }

    public void popRange() throws IOException {
        StreamState previous = this.stack.pollFirst();
        this.consume();
        this.currentState = this.stack.peekFirst();
        this.currentState.readCount += previous.byteCount;
    }

    public void consume() throws IOException {
        int count;
        if (this.currentState.byteCount > 0L && (count = this.available()) > 0) {
            ChunkUtils.skip(this, count);
        }
    }

    @Override
    public int read() throws IOException {
        return this.source.read();
    }

    @Override
    public int available() throws IOException {
        return this.source.available();
    }

    @Override
    public int read(byte[] bytes) throws IOException {
        return this.source.read(bytes);
    }

    @Override
    public int read(byte[] bytes, int offset, int length) throws IOException {
        return this.source.read(bytes, offset, length);
    }

    @Override
    public long skip(long l) throws IOException {
        return this.source.skip(l);
    }

    @Override
    public void close() throws IOException {
        this.source.close();
    }

    @Override
    public synchronized void mark(int i) {
        this.source.mark(i);
    }

    @Override
    public synchronized void reset() throws IOException {
        this.source.reset();
    }

    @Override
    public boolean markSupported() {
        return this.source.markSupported();
    }

    @Override
    public final void readFully(byte[] dst) throws IOException {
        this.readFully(dst, 0, dst.length);
    }

    @Override
    public final void readFully(byte[] dst, int offset, int byteCount) throws IOException {
        if (byteCount == 0) {
            return;
        }
        if (dst == null) {
            throw new NullPointerException("dst == null");
        }
        RangedInputStream.checkOffsetAndCount(dst.length, offset, byteCount);
        while (byteCount > 0) {
            int bytesRead = this.source.read(dst, offset, byteCount);
            if (bytesRead < 0) {
                throw new EOFException();
            }
            offset += bytesRead;
            byteCount -= bytesRead;
        }
    }

    private static void checkOffsetAndCount(int arrayLength, int offset, int count) {
        if ((offset | count) < 0 || offset > arrayLength || arrayLength - offset < count) {
            throw new ArrayIndexOutOfBoundsException(offset);
        }
    }

    @Override
    public int skipBytes(int count) throws IOException {
        long skip;
        int skipped = 0;
        while (skipped < count && (skip = this.source.skip(count - skipped)) != 0L) {
            skipped = (int)((long)skipped + skip);
        }
        return skipped;
    }

    @Override
    public final boolean readBoolean() throws IOException {
        int temp = this.source.read();
        if (temp < 0) {
            throw new EOFException();
        }
        return temp != 0;
    }

    @Override
    public final byte readByte() throws IOException {
        int temp = this.source.read();
        if (temp < 0) {
            throw new EOFException();
        }
        return (byte)temp;
    }

    @Override
    public int readUnsignedByte() throws IOException {
        int temp = this.source.read();
        if (temp < 0) {
            throw new EOFException();
        }
        return temp;
    }

    @Override
    public final char readChar() throws IOException {
        return (char)this.readShort();
    }

    @Override
    public final double readDouble() throws IOException {
        return Double.longBitsToDouble(this.readLong());
    }

    @Override
    public final float readFloat() throws IOException {
        return Float.intBitsToFloat(this.readInt());
    }

    @Override
    public int readUnsignedShort() throws IOException {
        return this.readShort() & 0xFFFF;
    }

    @Override
    public final short readShort() throws IOException {
        return (short)(this.source.read() << 8 | this.source.read() & 0xFF);
    }

    @Override
    public int readInt() throws IOException {
        return (this.source.read() & 0xFF) << 24 | (this.source.read() & 0xFF) << 16 | (this.source.read() & 0xFF) << 8 | this.source.read() & 0xFF;
    }

    @Override
    public long readLong() throws IOException {
        this.readFully(this.scratch, 0, 8);
        int h = (this.scratch[0] & 0xFF) << 24 | (this.scratch[1] & 0xFF) << 16 | (this.scratch[2] & 0xFF) << 8 | this.scratch[3] & 0xFF;
        int l = (this.scratch[4] & 0xFF) << 24 | (this.scratch[5] & 0xFF) << 16 | (this.scratch[6] & 0xFF) << 8 | this.scratch[7] & 0xFF;
        return (long)h << 32 | (long)l & 0xFFFFFFFFL;
    }

    @Override
    public String readLine() throws IOException {
        throw new IOException("readLine() is deprecated");
    }

    @Override
    public String readUTF() throws IOException {
        int utfSize = this.readUnsignedShort();
        byte[] buf = new byte[utfSize];
        this.readFully(buf, 0, utfSize);
        return RangedInputStream.decode(buf, new char[utfSize], 0, utfSize);
    }

    private static String decode(byte[] in, char[] out, int offset, int utfSize) throws UTFDataFormatException {
        int count = 0;
        int s = 0;
        while (count < utfSize) {
            byte b;
            if ((out[s] = (char)in[offset + count++]) < '\u0080') {
                ++s;
                continue;
            }
            char a = out[s];
            if ((a & 0xE0) == 192) {
                if (count >= utfSize) {
                    throw new UTFDataFormatException("bad second byte at " + count);
                }
                if (((b = in[offset + count++]) & 0xC0) != 128) {
                    throw new UTFDataFormatException("bad second byte at " + (count - 1));
                }
                out[s++] = (char)((a & 0x1F) << 6 | b & 0x3F);
                continue;
            }
            if ((a & 0xF0) == 224) {
                if (count + 1 >= utfSize) {
                    throw new UTFDataFormatException("bad third byte at " + (count + 1));
                }
                b = in[offset + count++];
                byte c = in[offset + count++];
                if ((b & 0xC0) != 128 || (c & 0xC0) != 128) {
                    throw new UTFDataFormatException("bad second or third byte at " + (count - 2));
                }
                out[s++] = (char)((a & 0xF) << 12 | (b & 0x3F) << 6 | c & 0x3F);
                continue;
            }
            throw new UTFDataFormatException("bad byte at " + (count - 1));
        }
        return new String(out, 0, s);
    }

    private class CountingInputStream
    extends InputStream {
        private final InputStream source;

        private CountingInputStream(InputStream in) {
            this.source = in;
        }

        @Override
        public int available() throws IOException {
            if (((RangedInputStream)RangedInputStream.this).currentState.byteCount < 0L) {
                return super.available();
            }
            return (int)(((RangedInputStream)RangedInputStream.this).currentState.byteCount - ((RangedInputStream)RangedInputStream.this).currentState.readCount);
        }

        @Override
        public int read() throws IOException {
            if (((RangedInputStream)RangedInputStream.this).currentState.byteCount >= 0L && ((RangedInputStream)RangedInputStream.this).currentState.readCount >= ((RangedInputStream)RangedInputStream.this).currentState.byteCount) {
                return -1;
            }
            int read = this.source.read();
            if (read >= 0) {
                ++((RangedInputStream)RangedInputStream.this).currentState.readCount;
            }
            return read;
        }
    }

    private static class StreamState {
        final long byteCount;
        long readCount;

        StreamState(long byteCount) {
            this.byteCount = byteCount;
        }
    }
}

