/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.svn.config;

import com.intellij.openapi.options.ConfigurationException;
import com.intellij.openapi.ui.NamedConfigurable;
import com.intellij.openapi.util.Ref;
import java.util.List;
import javax.swing.JComponent;
import org.jetbrains.idea.svn.SvnBundle;
import org.jetbrains.idea.svn.config.ConfigureProxiesOptionsPanel;
import org.jetbrains.idea.svn.config.ProxyGroup;

public class GroupConfigurable
extends NamedConfigurable<ProxyGroup> {
    private final ProxyGroup myProxyGroup;
    private final ConfigureProxiesOptionsPanel myPanel;
    private boolean myIsInitialized;

    public GroupConfigurable(ProxyGroup proxyGroup, Runnable treeUpdater, ConfigureProxiesOptionsPanel panel) {
        super(!proxyGroup.isDefault(), treeUpdater);
        this.myProxyGroup = proxyGroup;
        this.myPanel = panel;
    }

    public List<String> getRepositories() {
        return this.myPanel.getRepositories();
    }

    public void setDisplayName(String name) {
        this.myProxyGroup.setName(name);
    }

    public ProxyGroup getEditableObject() {
        return this.myProxyGroup;
    }

    public String getBannerSlogan() {
        return this.myProxyGroup.getName();
    }

    public JComponent createOptionsPanel() {
        return this.myPanel.getMainPanel();
    }

    public String getDisplayName() {
        return this.myProxyGroup.getName();
    }

    public String getHelpTopic() {
        return null;
    }

    public boolean isModified() {
        return false;
    }

    public void applyImpl() {
        if (this.myIsInitialized) {
            this.myProxyGroup.setPatterns(this.myPanel.getPatterns());
            this.myPanel.copyStringProperties(this.myProxyGroup.getProperties());
        }
    }

    public void apply() throws ConfigurationException {
        Ref errorMessageRef;
        if (this.myIsInitialized) {
            this.applyImpl();
        }
        if (!this.validate((Ref<String>)(errorMessageRef = new Ref()))) {
            throw new ConfigurationException((String)errorMessageRef.get());
        }
    }

    public boolean validate(Ref<String> errorMessageRef) {
        if (!this.checkNumericFieldValue(this.myProxyGroup.getPort())) {
            errorMessageRef.set((Object)SvnBundle.message("dialog.edit.http.proxies.settings.port.must.be.number.error", this.myProxyGroup.getName()));
            return false;
        }
        if (!this.checkNumericFieldValue(this.myProxyGroup.getTimeout())) {
            errorMessageRef.set((Object)SvnBundle.message("dialog.edit.http.proxies.settings.timeout.must.be.number.error", this.myProxyGroup.getName()));
            return false;
        }
        return true;
    }

    public void setIsValid(boolean valid) {
        this.myPanel.setIsValid(valid);
    }

    private boolean checkNumericFieldValue(String value) {
        if (value == null) {
            return true;
        }
        try {
            String portString = value.trim();
            if (portString.length() > 0) {
                Integer.valueOf(portString);
            }
        }
        catch (NumberFormatException e) {
            return false;
        }
        return true;
    }

    public void reset() {
        try {
            this.myPanel.setStringProperties(this.myProxyGroup.getProperties());
            this.myPanel.setPatterns(this.myProxyGroup.getPatterns());
            this.myPanel.setIsDefaultGroup(this.myProxyGroup.isDefault());
            this.myIsInitialized = true;
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
    }
}

