/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.aop.jam;

import com.intellij.aop.ArgNamesManipulator;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiParameter;
import com.intellij.psi.SmartPointerManager;
import com.intellij.psi.SmartPsiElementPointer;
import com.intellij.psi.impl.CheckUtil;
import com.intellij.util.IncorrectOperationException;
import org.jetbrains.annotations.NotNull;

public class SetArgNamesQuickFix
implements LocalQuickFix {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.aop.jam.SetArgNamesQuickFix");
    private final String myName;
    private final boolean mySet;
    private final ArgNamesManipulator myManipulator;
    private final SmartPsiElementPointer<PsiMethod> myMethod;

    public SetArgNamesQuickFix(String name, boolean set, ArgNamesManipulator manipulator, PsiMethod method) {
        this.myName = name;
        this.mySet = set;
        this.myManipulator = manipulator;
        this.myMethod = SmartPointerManager.getInstance((Project)method.getProject()).createSmartPsiElementPointer((PsiElement)method);
    }

    public void applyFix(@NotNull Project project, @NotNull ProblemDescriptor descriptor) {
        if (project == null) {
            SetArgNamesQuickFix.$$$reportNull$$$0(0);
        }
        if (descriptor == null) {
            SetArgNamesQuickFix.$$$reportNull$$$0(1);
        }
        try {
            CheckUtil.checkWritable((PsiElement)descriptor.getPsiElement());
            PsiMethod method = (PsiMethod)this.myMethod.getElement();
            if (method == null) {
                return;
            }
            if (this.mySet) {
                StringBuilder result = new StringBuilder();
                for (PsiParameter parameter : method.getParameterList().getParameters()) {
                    String name = parameter.getName();
                    if (result.length() > 0) {
                        result.append(",");
                    }
                    result.append(name);
                }
                this.myManipulator.setArgNames(result.toString());
            } else {
                this.myManipulator.setArgNames(null);
            }
        }
        catch (IncorrectOperationException e) {
            LOG.error((Throwable)e);
        }
    }

    @NotNull
    public String getFamilyName() {
        String string = this.myName;
        if (string == null) {
            SetArgNamesQuickFix.$$$reportNull$$$0(2);
        }
        return string;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "descriptor";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/aop/jam/SetArgNamesQuickFix";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/aop/jam/SetArgNamesQuickFix";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getFamilyName";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "applyFix";
                break;
            }
            case 2: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

