/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.aop.jam;

import com.intellij.aop.AopBundle;
import com.intellij.aop.AopIntroduction;
import com.intellij.aop.IntroductionManipulator;
import com.intellij.aop.psi.AopPointcutExpressionFile;
import com.intellij.aop.psi.AopPointcutExpressionHolder;
import com.intellij.codeHighlighting.HighlightDisplayLevel;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.codeInspection.ProblemHighlightType;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.codeInspection.XmlSuppressableInspectionTool;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiLiteralExpression;
import com.intellij.psi.impl.source.tree.injected.InjectedLanguageUtil;
import com.intellij.psi.xml.XmlAttributeValue;
import com.intellij.psi.xml.XmlElement;
import com.intellij.util.IncorrectOperationException;
import com.intellij.util.containers.ContainerUtil;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;

public class DeclareParentsInspection
extends XmlSuppressableInspectionTool {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.aop.jam.DeclareParentsInspection");

    public boolean isEnabledByDefault() {
        return true;
    }

    @NotNull
    public HighlightDisplayLevel getDefaultLevel() {
        HighlightDisplayLevel highlightDisplayLevel = HighlightDisplayLevel.ERROR;
        if (highlightDisplayLevel == null) {
            DeclareParentsInspection.$$$reportNull$$$0(0);
        }
        return highlightDisplayLevel;
    }

    @Nls
    @NotNull
    public String getDisplayName() {
        String string = AopBundle.message("inspection.display.name.declareParents", new Object[0]);
        if (string == null) {
            DeclareParentsInspection.$$$reportNull$$$0(1);
        }
        return string;
    }

    @NonNls
    @NotNull
    public String getShortName() {
        if ("DeclareParentsInspection" == null) {
            DeclareParentsInspection.$$$reportNull$$$0(2);
        }
        return "DeclareParentsInspection";
    }

    @NotNull
    public PsiElementVisitor buildVisitor(final @NotNull ProblemsHolder holder, boolean isOnTheFly) {
        if (holder == null) {
            DeclareParentsInspection.$$$reportNull$$$0(3);
        }
        PsiElementVisitor psiElementVisitor = new PsiElementVisitor(){

            public void visitElement(PsiElement element) {
                if (element instanceof PsiLiteralExpression || element instanceof XmlAttributeValue) {
                    PsiFile file = InjectedLanguageUtil.findInjectedPsiNoCommit((PsiFile)element.getContainingFile(), (int)(element.getTextRange().getStartOffset() + 1));
                    if (file instanceof AopPointcutExpressionFile) {
                        this.process((AopPointcutExpressionHolder)file, element instanceof XmlElement);
                    }
                } else if (element instanceof AopPointcutExpressionHolder && !(element instanceof AopPointcutExpressionFile)) {
                    this.process((AopPointcutExpressionHolder)element, false);
                }
            }

            private void process(AopPointcutExpressionHolder file, boolean isXml) {
                final IntroductionManipulator manipulator = file.getAopModel().getIntroductionManipulator();
                if (manipulator == null) {
                    return;
                }
                AopIntroduction introduction = manipulator.getIntroduction();
                if (introduction == null) {
                    return;
                }
                PsiClass intf = (PsiClass)introduction.getImplementInterface().getValue();
                if (intf == null && introduction.getImplementInterface().getStringValue() != null || intf != null && !intf.isInterface()) {
                    DeclareParentsInspection.registerProblem(manipulator.getInterfaceElement(), AopBundle.message("error.interface.expected", new Object[0]), holder);
                    return;
                }
                if (intf == null) {
                    return;
                }
                PsiClass defaultImpl = (PsiClass)introduction.getDefaultImpl().getValue();
                if (defaultImpl == null) {
                    if (!isXml && !ContainerUtil.findAll((Object[])intf.getAllMethods(), method -> method.hasModifierProperty("abstract")).isEmpty()) {
                        holder.registerProblem(manipulator.getCommonProblemElement(), AopBundle.message("error.default.implementation.class.should.be.specified", new Object[0]), new LocalQuickFix[]{new LocalQuickFix(){

                            @NotNull
                            public String getFamilyName() {
                                String string = AopBundle.message("quickfix.name.define.attribute", manipulator.getDefaultImplAttributeName());
                                if (string == null) {
                                    1.$$$reportNull$$$0(0);
                                }
                                return string;
                            }

                            public void applyFix(@NotNull Project project, @NotNull ProblemDescriptor descriptor) {
                                if (project == null) {
                                    1.$$$reportNull$$$0(1);
                                }
                                if (descriptor == null) {
                                    1.$$$reportNull$$$0(2);
                                }
                                try {
                                    manipulator.defineDefaultImpl(project, descriptor);
                                }
                                catch (IncorrectOperationException e) {
                                    LOG.error((Throwable)e);
                                }
                            }

                            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                                RuntimeException runtimeException;
                                Object[] objectArray;
                                Object[] objectArray2;
                                int n2;
                                String string;
                                switch (n) {
                                    default: {
                                        string = "@NotNull method %s.%s must not return null";
                                        break;
                                    }
                                    case 1: 
                                    case 2: {
                                        string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                                        break;
                                    }
                                }
                                switch (n) {
                                    default: {
                                        n2 = 2;
                                        break;
                                    }
                                    case 1: 
                                    case 2: {
                                        n2 = 3;
                                        break;
                                    }
                                }
                                Object[] objectArray3 = new Object[n2];
                                switch (n) {
                                    default: {
                                        objectArray2 = objectArray3;
                                        objectArray3[0] = "com/intellij/aop/jam/DeclareParentsInspection$1$1";
                                        break;
                                    }
                                    case 1: {
                                        objectArray2 = objectArray3;
                                        objectArray3[0] = "project";
                                        break;
                                    }
                                    case 2: {
                                        objectArray2 = objectArray3;
                                        objectArray3[0] = "descriptor";
                                        break;
                                    }
                                }
                                switch (n) {
                                    default: {
                                        objectArray = objectArray2;
                                        objectArray2[1] = "getFamilyName";
                                        break;
                                    }
                                    case 1: 
                                    case 2: {
                                        objectArray = objectArray2;
                                        objectArray2[1] = "com/intellij/aop/jam/DeclareParentsInspection$1$1";
                                        break;
                                    }
                                }
                                switch (n) {
                                    default: {
                                        break;
                                    }
                                    case 1: 
                                    case 2: {
                                        objectArray = objectArray;
                                        objectArray[2] = "applyFix";
                                        break;
                                    }
                                }
                                String string2 = String.format(string, objectArray);
                                switch (n) {
                                    default: {
                                        runtimeException = new IllegalStateException(string2);
                                        break;
                                    }
                                    case 1: 
                                    case 2: {
                                        runtimeException = new IllegalArgumentException(string2);
                                        break;
                                    }
                                }
                                throw runtimeException;
                            }
                        }});
                    }
                    return;
                }
                if (defaultImpl.hasModifierProperty("abstract") || !defaultImpl.isInheritor(intf, true)) {
                    PsiElement defaultImplElement = manipulator.getDefaultImplElement();
                    assert (defaultImplElement != null);
                    DeclareParentsInspection.registerProblem(defaultImplElement, AopBundle.message("error.non.abstract.class.implemention.0.expected", intf.getQualifiedName()), holder);
                }
            }
        };
        if (psiElementVisitor == null) {
            DeclareParentsInspection.$$$reportNull$$$0(4);
        }
        return psiElementVisitor;
    }

    private static void registerProblem(PsiElement element, String descriptionTemplate, ProblemsHolder holder) {
        int quotes = element.getText().startsWith("\"") ? 1 : 0;
        TextRange range = TextRange.from((int)quotes, (int)Math.max(element.getTextLength() - 2 * quotes, 1));
        holder.registerProblem(holder.getManager().createProblemDescriptor(element, range, descriptionTemplate, ProblemHighlightType.GENERIC_ERROR_OR_WARNING, holder.isOnTheFly(), new LocalQuickFix[0]));
    }

    @Nls
    @NotNull
    public String getGroupDisplayName() {
        String string = AopBundle.message("inspection.group.display.name.aop", new Object[0]);
        if (string == null) {
            DeclareParentsInspection.$$$reportNull$$$0(5);
        }
        return string;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 3: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 3: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/aop/jam/DeclareParentsInspection";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "holder";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getDefaultLevel";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getDisplayName";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getShortName";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/aop/jam/DeclareParentsInspection";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "buildVisitor";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getGroupDisplayName";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "buildVisitor";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 3: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

