/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.cucumber.groovy.steps;

import com.intellij.codeInsight.CodeInsightUtilCore;
import com.intellij.codeInsight.template.Template;
import com.intellij.codeInsight.template.TemplateBuilderFactory;
import com.intellij.codeInsight.template.TemplateBuilderImpl;
import com.intellij.codeInsight.template.TemplateEditingAdapter;
import com.intellij.codeInsight.template.TemplateEditingListener;
import com.intellij.codeInsight.template.TemplateManager;
import com.intellij.codeInsight.template.impl.TemplateManagerImpl;
import com.intellij.codeInsight.template.impl.TemplateState;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.fileEditor.FileEditorManager;
import com.intellij.openapi.fileEditor.OpenFileDescriptor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.codeStyle.JavaCodeStyleManager;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.ObjectUtils;
import cucumber.runtime.groovy.GroovySnippet;
import cucumber.runtime.snippets.Snippet;
import cucumber.runtime.snippets.SnippetGenerator;
import gherkin.formatter.model.Step;
import java.util.Collections;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.plugins.cucumber.StepDefinitionCreator;
import org.jetbrains.plugins.cucumber.groovy.GrCucumberUtil;
import org.jetbrains.plugins.cucumber.psi.GherkinStep;
import org.jetbrains.plugins.groovy.actions.GroovyTemplatesFactory;
import org.jetbrains.plugins.groovy.intentions.base.IntentionUtils;
import org.jetbrains.plugins.groovy.lang.psi.GroovyFile;
import org.jetbrains.plugins.groovy.lang.psi.GroovyPsiElementFactory;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.GrStatement;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.blocks.GrClosableBlock;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrMethodCall;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.literals.GrLiteral;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.params.GrParameter;
import org.jetbrains.plugins.groovy.lang.psi.util.PsiUtil;

public class GrStepDefinitionCreator
implements StepDefinitionCreator {
    public static final String GROOVY_STEP_DEFINITION_FILE_TMPL_1_0 = "GroovyStepDefinitionFile.groovy";
    public static final String GROOVY_STEP_DEFINITION_FILE_TMPL_1_1 = "GroovyStepDefinitionFile1_1.groovy";

    @NotNull
    public PsiFile createStepDefinitionContainer(@NotNull PsiDirectory dir, @NotNull String name) {
        if (dir == null) {
            GrStepDefinitionCreator.$$$reportNull$$$0(0);
        }
        if (name == null) {
            GrStepDefinitionCreator.$$$reportNull$$$0(1);
        }
        String fileName = name + '.' + "groovy";
        if (GrCucumberUtil.isCucumber_1_1_orAbove((PsiElement)dir)) {
            PsiFile psiFile = GroovyTemplatesFactory.createFromTemplate((PsiDirectory)dir, (String)name, (String)fileName, (String)GROOVY_STEP_DEFINITION_FILE_TMPL_1_1, (boolean)true, (String[])new String[0]);
            if (psiFile == null) {
                GrStepDefinitionCreator.$$$reportNull$$$0(2);
            }
            return psiFile;
        }
        PsiFile psiFile = GroovyTemplatesFactory.createFromTemplate((PsiDirectory)dir, (String)name, (String)fileName, (String)GROOVY_STEP_DEFINITION_FILE_TMPL_1_0, (boolean)true, (String[])new String[0]);
        if (psiFile == null) {
            GrStepDefinitionCreator.$$$reportNull$$$0(3);
        }
        return psiFile;
    }

    public boolean createStepDefinition(@NotNull GherkinStep step, final @NotNull PsiFile file) {
        GrParameter[] blockVars;
        if (step == null) {
            GrStepDefinitionCreator.$$$reportNull$$$0(4);
        }
        if (file == null) {
            GrStepDefinitionCreator.$$$reportNull$$$0(5);
        }
        if (!(file instanceof GroovyFile)) {
            return false;
        }
        final Project project = file.getProject();
        VirtualFile vFile = (VirtualFile)ObjectUtils.assertNotNull((Object)file.getVirtualFile());
        OpenFileDescriptor descriptor = new OpenFileDescriptor(project, vFile);
        FileEditorManager.getInstance((Project)project).getAllEditors(vFile);
        FileEditorManager.getInstance((Project)project).openTextEditor(descriptor, true);
        final Editor editor = FileEditorManager.getInstance((Project)project).getSelectedTextEditor();
        if (editor != null) {
            TemplateManager templateManager = TemplateManager.getInstance((Project)file.getProject());
            TemplateState templateState = TemplateManagerImpl.getTemplateState((Editor)editor);
            Template template = templateManager.getActiveTemplate(editor);
            if (templateState != null && template != null) {
                templateState.gotoEnd();
            }
        }
        GrMethodCall element = GrStepDefinitionCreator.buildStepDefinitionByStep(step);
        GrMethodCall methodCall = (GrMethodCall)((GroovyFile)file).addStatementBefore((GrStatement)element, null);
        JavaCodeStyleManager.getInstance((Project)project).shortenClassReferences((PsiElement)methodCall);
        methodCall = (GrMethodCall)CodeInsightUtilCore.forcePsiPostprocessAndRestoreElement((PsiElement)methodCall);
        PsiDocumentManager.getInstance((Project)project).commitAllDocuments();
        if (ApplicationManager.getApplication().isUnitTestMode()) {
            return true;
        }
        TemplateBuilderImpl builder = (TemplateBuilderImpl)TemplateBuilderFactory.getInstance().createTemplateBuilder((PsiElement)methodCall);
        GrLiteral pattern = GrCucumberUtil.getStepDefinitionPattern(methodCall);
        assert (pattern != null);
        String patternText = pattern.getText();
        builder.replaceElement((PsiElement)pattern, new TextRange(1, patternText.length() - 1), patternText.substring(1, patternText.length() - 1));
        GrClosableBlock closure = methodCall.getClosureArguments()[0];
        for (GrParameter var : blockVars = closure.getAllParameters()) {
            PsiElement identifier = var.getNameIdentifierGroovy();
            builder.replaceElement(identifier, identifier.getText());
        }
        TemplateManager manager = TemplateManager.getInstance((Project)project);
        final Editor editorToRunTemplate = editor == null ? IntentionUtils.positionCursor((Project)project, (PsiFile)file, (PsiElement)methodCall) : editor;
        Template template = builder.buildTemplate();
        TextRange range = methodCall.getTextRange();
        editorToRunTemplate.getDocument().deleteString(range.getStartOffset(), range.getEndOffset());
        editorToRunTemplate.getCaretModel().moveToOffset(range.getStartOffset());
        manager.startTemplate(editorToRunTemplate, template, (TemplateEditingListener)new TemplateEditingAdapter(){

            public void templateFinished(@NotNull Template template, boolean brokenOff) {
                if (template == null) {
                    1.$$$reportNull$$$0(0);
                }
                if (brokenOff) {
                    return;
                }
                ApplicationManager.getApplication().runWriteAction(() -> {
                    GrClosableBlock[] closures;
                    if (file == null) {
                        1.$$$reportNull$$$0(1);
                    }
                    PsiDocumentManager.getInstance((Project)project).commitDocument(editorToRunTemplate.getDocument());
                    int offset = editorToRunTemplate.getCaretModel().getOffset();
                    GrMethodCall methodCall1 = (GrMethodCall)PsiTreeUtil.findElementOfClassAtOffset((PsiFile)file, (int)(offset - 1), GrMethodCall.class, (boolean)false);
                    if (methodCall1 != null && (closures = methodCall1.getClosureArguments()).length == 1) {
                        GrClosableBlock closure1 = closures[0];
                        GrStepDefinitionCreator.selectBody(closure1, editor);
                    }
                });
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2;
                Object[] objectArray3 = new Object[3];
                switch (n) {
                    default: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "template";
                        break;
                    }
                    case 1: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "file";
                        break;
                    }
                }
                objectArray2[1] = "org/jetbrains/plugins/cucumber/groovy/steps/GrStepDefinitionCreator$1";
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[2] = "templateFinished";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[2] = "lambda$templateFinished$0";
                        break;
                    }
                }
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        });
        return true;
    }

    private static void selectBody(GrClosableBlock closure, Editor editor) {
        PsiElement rightBound;
        PsiElement arrow = closure.getArrow();
        PsiElement leftBound = PsiUtil.skipWhitespaces((PsiElement)(arrow != null ? arrow : closure.getParameterList()).getNextSibling(), (boolean)true);
        PsiElement rbrace = closure.getRBrace();
        PsiElement psiElement = rightBound = rbrace != null ? PsiUtil.skipWhitespaces((PsiElement)rbrace.getPrevSibling(), (boolean)false) : null;
        if (leftBound != null && rightBound != null) {
            editor.getSelectionModel().setSelection(leftBound.getTextRange().getStartOffset(), rightBound.getTextRange().getEndOffset());
            editor.getCaretModel().moveToOffset(leftBound.getTextRange().getStartOffset());
        }
    }

    private static GrMethodCall buildStepDefinitionByStep(@NotNull GherkinStep step) {
        if (step == null) {
            GrStepDefinitionCreator.$$$reportNull$$$0(6);
        }
        GroovyPsiElementFactory factory = GroovyPsiElementFactory.getInstance((Project)step.getProject());
        Step cucumberStep = new Step(Collections.emptyList(), step.getKeyword().getText(), step.getStepName(), Integer.valueOf(0), null, null);
        SnippetGenerator generator = new SnippetGenerator((Snippet)new GroovySnippet());
        String fqnPendingException = GrCucumberUtil.isCucumber_1_1_orAbove((PsiElement)step) ? "cucumber.api.PendingException" : "cucumber.runtime.PendingException";
        String snippet = generator.getSnippet(cucumberStep, null).replace("PendingException", fqnPendingException);
        return (GrMethodCall)factory.createStatementFromText((CharSequence)snippet, (PsiElement)step);
    }

    public boolean validateNewStepDefinitionFileName(@NotNull Project project, @NotNull String fileName) {
        if (project == null) {
            GrStepDefinitionCreator.$$$reportNull$$$0(7);
        }
        if (fileName == null) {
            GrStepDefinitionCreator.$$$reportNull$$$0(8);
        }
        return true;
    }

    @NotNull
    public PsiDirectory getDefaultStepDefinitionFolder(@NotNull GherkinStep step) {
        if (step == null) {
            GrStepDefinitionCreator.$$$reportNull$$$0(9);
        }
        PsiFile featureFile = step.getContainingFile();
        PsiDirectory psiDirectory = (PsiDirectory)ObjectUtils.assertNotNull((Object)featureFile.getParent());
        if (psiDirectory == null) {
            GrStepDefinitionCreator.$$$reportNull$$$0(10);
        }
        return psiDirectory;
    }

    @NotNull
    public String getStepDefinitionFilePath(@NotNull PsiFile file) {
        if (file == null) {
            GrStepDefinitionCreator.$$$reportNull$$$0(11);
        }
        VirtualFile vFile = file.getVirtualFile();
        if (file instanceof GroovyFile && vFile != null) {
            String packageName = ((GroovyFile)file).getPackageName();
            if (StringUtil.isEmptyOrSpaces((String)packageName)) {
                String string = vFile.getNameWithoutExtension();
                if (string == null) {
                    GrStepDefinitionCreator.$$$reportNull$$$0(12);
                }
                return string;
            }
            String string = packageName + "." + vFile.getNameWithoutExtension();
            if (string == null) {
                GrStepDefinitionCreator.$$$reportNull$$$0(13);
            }
            return string;
        }
        String string = file.getName();
        if (string == null) {
            GrStepDefinitionCreator.$$$reportNull$$$0(14);
        }
        return string;
    }

    @NotNull
    public String getDefaultStepFileName(@NotNull GherkinStep step) {
        if (step == null) {
            GrStepDefinitionCreator.$$$reportNull$$$0(15);
        }
        if ("StepDef" == null) {
            GrStepDefinitionCreator.$$$reportNull$$$0(16);
        }
        return "StepDef";
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: 
            case 3: 
            case 10: 
            case 12: 
            case 13: 
            case 14: 
            case 16: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: 
            case 3: 
            case 10: 
            case 12: 
            case 13: 
            case 14: 
            case 16: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dir";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
            case 2: 
            case 3: 
            case 10: 
            case 12: 
            case 13: 
            case 14: 
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/plugins/cucumber/groovy/steps/GrStepDefinitionCreator";
                break;
            }
            case 4: 
            case 6: 
            case 9: 
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "step";
                break;
            }
            case 5: 
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fileName";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/plugins/cucumber/groovy/steps/GrStepDefinitionCreator";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "createStepDefinitionContainer";
                break;
            }
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "getDefaultStepDefinitionFolder";
                break;
            }
            case 12: 
            case 13: 
            case 14: {
                objectArray = objectArray2;
                objectArray2[1] = "getStepDefinitionFilePath";
                break;
            }
            case 16: {
                objectArray = objectArray2;
                objectArray2[1] = "getDefaultStepFileName";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "createStepDefinitionContainer";
                break;
            }
            case 2: 
            case 3: 
            case 10: 
            case 12: 
            case 13: 
            case 14: 
            case 16: {
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "createStepDefinition";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "buildStepDefinitionByStep";
                break;
            }
            case 7: 
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "validateNewStepDefinitionFileName";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "getDefaultStepDefinitionFolder";
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "getStepDefinitionFilePath";
                break;
            }
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "getDefaultStepFileName";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: 
            case 3: 
            case 10: 
            case 12: 
            case 13: 
            case 14: 
            case 16: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

