/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.jboss.jbpm.diagram.beans;

import com.intellij.diagram.DiagramEdgeBase;
import com.intellij.diagram.DiagramNode;
import com.intellij.diagram.DiagramRelationshipInfo;
import com.intellij.diagram.DiagramRelationshipInfoAdapter;
import com.intellij.diagram.presentation.DiagramLineType;
import com.intellij.jboss.jbpm.diagram.beans.BpmnEdgeType;
import com.intellij.jboss.jbpm.diagram.beans.wrappers.BpmnElementWrapper;
import com.intellij.util.xml.DomElement;
import java.awt.Color;
import java.awt.Shape;
import org.jetbrains.annotations.Nullable;

public class BpmnDiagramEdge
extends DiagramEdgeBase<BpmnElementWrapper> {
    private final DomElement myDefiningElement;
    private final BpmnEdgeType myEdgeType;

    public BpmnDiagramEdge(DiagramNode<BpmnElementWrapper> source, DiagramNode<BpmnElementWrapper> target, @Nullable DomElement definingElement, BpmnEdgeType edgeType) {
        super(source, target, BpmnDiagramEdge.getInfo(edgeType));
        this.myDefiningElement = definingElement;
        this.myEdgeType = edgeType;
    }

    @Nullable
    public DomElement getDefiningElement() {
        return this.myDefiningElement;
    }

    public BpmnEdgeType getEdgeType() {
        return this.myEdgeType;
    }

    private static DiagramRelationshipInfo getInfo(final BpmnEdgeType type) {
        return new DiagramRelationshipInfoAdapter(null, BpmnDiagramEdge.getLineType(type)){

            public Shape getStartArrow() {
                if (type == BpmnEdgeType.EVENT) {
                    return NONE;
                }
                return STANDARD;
            }

            public Shape getEndArrow() {
                if (type == BpmnEdgeType.EVENT) {
                    return DIAMOND;
                }
                return super.getEndArrow();
            }

            public Color getLabelColor() {
                return super.getLabelColor();
            }
        };
    }

    private static DiagramLineType getLineType(BpmnEdgeType type) {
        return type == BpmnEdgeType.SUBFLOW ? DiagramLineType.DOTTED : DiagramLineType.SOLID;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof BpmnDiagramEdge)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        BpmnDiagramEdge that = (BpmnDiagramEdge)((Object)o);
        return this.myEdgeType == that.myEdgeType;
    }

    public int hashCode() {
        int result = super.hashCode();
        result = 31 * result + this.myEdgeType.hashCode();
        return result;
    }
}

