/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.jboss.jbpm;

import com.intellij.jboss.jbpm.model.xml.bpmn20.Bpmn20DomElement;
import com.intellij.jboss.jbpm.model.xml.bpmn20.EventDefinitionExplicitOwner;
import com.intellij.jboss.jbpm.model.xml.bpmn20.FlowElementExplicitOwner;
import com.intellij.jboss.jbpm.model.xml.bpmn20.TBaseElement;
import com.intellij.jboss.jbpm.model.xml.bpmn20.TEventDefinition;
import com.intellij.jboss.jbpm.model.xml.bpmn20.TFlowElement;
import com.intellij.jboss.jbpm.model.xml.bpmn20.TFlowNode;
import com.intellij.jboss.jbpm.model.xml.bpmndi.BPMNShape;
import com.intellij.util.Processor;
import com.intellij.util.ui.JBDimension;
import com.intellij.util.xml.DomElement;
import com.intellij.util.xml.DomUtil;
import com.intellij.util.xml.GenericAttributeValue;
import java.awt.Dimension;
import java.util.ArrayDeque;
import java.util.Collection;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public class BpmnUtils {
    public static void processAllElements(@NotNull Collection<? extends Bpmn20DomElement> initial, Processor<? super TBaseElement> processor) {
        if (initial == null) {
            BpmnUtils.$$$reportNull$$$0(0);
        }
        BpmnUtils.processAllElements(initial, processor, TBaseElement.class);
    }

    public static <T extends TBaseElement> void processAllElements(@NotNull Collection<? extends Bpmn20DomElement> initial, Processor<? super T> processor, Class<T> clazz) {
        if (initial == null) {
            BpmnUtils.$$$reportNull$$$0(1);
        }
        ArrayDeque<? extends Bpmn20DomElement> queue = new ArrayDeque<Bpmn20DomElement>(initial);
        while (!queue.isEmpty()) {
            Bpmn20DomElement element = queue.removeFirst();
            if (clazz.isAssignableFrom(element.getClass()) && !processor.process((Object)((TBaseElement)element))) {
                return;
            }
            List children = DomUtil.getDefinedChildrenOfType((DomElement)element, TBaseElement.class, (boolean)true, (boolean)false);
            queue.addAll(children);
        }
    }

    public static List<TFlowElement> getFlowElements(FlowElementExplicitOwner owner) {
        return DomUtil.getChildrenOfType((DomElement)owner, TFlowElement.class);
    }

    public static List<TEventDefinition> getEventDefinitions(EventDefinitionExplicitOwner owner) {
        return DomUtil.getChildrenOfType((DomElement)owner, TEventDefinition.class);
    }

    public static List<TFlowNode> getFlowNodes(FlowElementExplicitOwner owner) {
        return DomUtil.getChildrenOfType((DomElement)owner, TFlowNode.class);
    }

    public static Dimension getShapeSize(BPMNShape shape) {
        return new JBDimension((int)BpmnUtils.getAttributeValue(shape.getBounds().getWidth()), (int)BpmnUtils.getAttributeValue(shape.getBounds().getHeight()));
    }

    public static double getAttributeValue(GenericAttributeValue<Double> attributeValue) {
        if (attributeValue.getStringValue() == null) {
            return 0.0;
        }
        Double result = (Double)attributeValue.getValue();
        return result == null ? 0.0 : result;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "initial", "com/intellij/jboss/jbpm/BpmnUtils", "processAllElements"));
    }
}

