/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.cucumber.java.steps;

import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleUtilCore;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiMethod;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.cucumber.CucumberUtil;
import org.jetbrains.plugins.cucumber.MapParameterTypeManager;
import org.jetbrains.plugins.cucumber.ParameterTypeManager;
import org.jetbrains.plugins.cucumber.java.CucumberJavaUtil;
import org.jetbrains.plugins.cucumber.java.steps.AbstractJavaStepDefinition;

public class JavaStepDefinition
extends AbstractJavaStepDefinition {
    private final String myAnnotationClassName;

    public JavaStepDefinition(@NotNull PsiElement stepDef, @NotNull String annotationClassName) {
        if (stepDef == null) {
            JavaStepDefinition.$$$reportNull$$$0(0);
        }
        if (annotationClassName == null) {
            JavaStepDefinition.$$$reportNull$$$0(1);
        }
        super(stepDef);
        this.myAnnotationClassName = annotationClassName;
    }

    @Nullable
    protected String getCucumberRegexFromElement(PsiElement element) {
        String definitionText = this.getStepDefinitionText();
        if (definitionText == null) {
            return null;
        }
        Module module = ModuleUtilCore.findModuleForPsiElement((PsiElement)element);
        if (module != null) {
            MapParameterTypeManager parameterTypes = CucumberJavaUtil.getAllParameterTypes(module);
            if (!CucumberUtil.isCucumberExpression((String)definitionText)) {
                return definitionText;
            }
            return CucumberUtil.buildRegexpFromCucumberExpression((String)definitionText, (ParameterTypeManager)parameterTypes);
        }
        return definitionText;
    }

    @Nullable
    public String getStepDefinitionText() {
        PsiElement element = this.getElement();
        if (element == null) {
            return null;
        }
        if (!(element instanceof PsiMethod)) {
            return null;
        }
        String patternText = CucumberJavaUtil.getStepAnnotationValue((PsiMethod)element, this.myAnnotationClassName);
        if (patternText != null && patternText.length() > 1) {
            return patternText.replace("\\\\", "\\").replace("\\\"", "\"");
        }
        return null;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[3];
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[0] = "stepDef";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[0] = "annotationClassName";
                break;
            }
        }
        objectArray[1] = "org/jetbrains/plugins/cucumber/java/steps/JavaStepDefinition";
        objectArray[2] = "<init>";
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

