/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.cucumber.java;

import com.intellij.codeInsight.AnnotationUtil;
import com.intellij.execution.Location;
import com.intellij.execution.PsiLocation;
import com.intellij.execution.junit2.info.LocationUtil;
import com.intellij.find.findUsages.FindUsagesOptions;
import com.intellij.find.findUsages.JavaFindUsagesHelper;
import com.intellij.find.findUsages.JavaMethodFindUsagesOptions;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ProjectUtil;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiAnnotation;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassOwner;
import com.intellij.psi.PsiConstantEvaluationHelper;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiExpressionList;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiMethodCallExpression;
import com.intellij.psi.PsiNewExpression;
import com.intellij.psi.PsiReference;
import com.intellij.psi.SmartPointerManager;
import com.intellij.psi.SmartPsiElementPointer;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.search.SearchScope;
import com.intellij.psi.util.CachedValueProvider;
import com.intellij.psi.util.CachedValuesManager;
import com.intellij.psi.util.ClassUtil;
import com.intellij.psi.util.PsiModificationTracker;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.usageView.UsageInfo;
import com.intellij.util.CommonProcessors;
import com.intellij.util.Processor;
import com.intellij.util.containers.ContainerUtil;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.cucumber.CucumberUtil;
import org.jetbrains.plugins.cucumber.MapParameterTypeManager;
import org.jetbrains.plugins.cucumber.java.config.CucumberConfigUtil;
import org.jetbrains.plugins.cucumber.java.steps.reference.CucumberJavaAnnotationProvider;
import org.jetbrains.plugins.cucumber.psi.GherkinFeature;
import org.jetbrains.plugins.cucumber.psi.GherkinFile;
import org.jetbrains.plugins.cucumber.psi.GherkinScenario;
import org.jetbrains.plugins.cucumber.psi.GherkinScenarioOutline;
import org.jetbrains.plugins.cucumber.psi.GherkinStep;

public class CucumberJavaUtil {
    public static final String CUCUMBER_STEP_ANNOTATION_PREFIX_1_0 = "cucumber.annotation.";
    public static final String CUCUMBER_STEP_ANNOTATION_PREFIX_1_1 = "cucumber.api.java.";
    public static final String PARAMETER_TYPE_CLASS = "io.cucumber.cucumberexpressions.ParameterType";
    private static final Map<String, String> JAVA_PARAMETER_TYPES;
    public static final String CUCUMBER_EXPRESSIONS_CLASS_MARKER = "io.cucumber.cucumberexpressions.CucumberExpressionGenerator";

    private static String getCucumberAnnotationSuffix(@NotNull String name) {
        if (name == null) {
            CucumberJavaUtil.$$$reportNull$$$0(0);
        }
        if (name.startsWith(CUCUMBER_STEP_ANNOTATION_PREFIX_1_0)) {
            return name.substring(CUCUMBER_STEP_ANNOTATION_PREFIX_1_0.length());
        }
        if (name.startsWith(CUCUMBER_STEP_ANNOTATION_PREFIX_1_1)) {
            return name.substring(CUCUMBER_STEP_ANNOTATION_PREFIX_1_1.length());
        }
        return "";
    }

    public static String getCucumberPendingExceptionFqn(@NotNull PsiElement context) {
        String version;
        if (context == null) {
            CucumberJavaUtil.$$$reportNull$$$0(1);
        }
        if ((version = CucumberConfigUtil.getCucumberCoreVersion(context)) == null || version.compareTo("1.1") >= 0) {
            return "cucumber.api.PendingException";
        }
        return "cucumber.runtime.PendingException";
    }

    @Nullable
    private static String getAnnotationName(@NotNull PsiAnnotation annotation) {
        if (annotation == null) {
            CucumberJavaUtil.$$$reportNull$$$0(2);
        }
        Ref qualifiedAnnotationName = new Ref();
        ApplicationManager.getApplication().runReadAction(() -> {
            if (annotation == null) {
                CucumberJavaUtil.$$$reportNull$$$0(21);
            }
            String qualifiedName = annotation.getQualifiedName();
            qualifiedAnnotationName.set((Object)qualifiedName);
        });
        return (String)qualifiedAnnotationName.get();
    }

    public static boolean isCucumberStepAnnotation(@NotNull PsiAnnotation annotation) {
        String annotationName;
        if (annotation == null) {
            CucumberJavaUtil.$$$reportNull$$$0(3);
        }
        if ((annotationName = CucumberJavaUtil.getAnnotationName(annotation)) == null) {
            return false;
        }
        String annotationSuffix = CucumberJavaUtil.getCucumberAnnotationSuffix(annotationName);
        if (annotationSuffix.contains(".")) {
            return true;
        }
        return CucumberJavaAnnotationProvider.STEP_MARKERS.contains(annotationName);
    }

    public static boolean isCucumberHookAnnotation(@NotNull PsiAnnotation annotation) {
        String annotationName;
        if (annotation == null) {
            CucumberJavaUtil.$$$reportNull$$$0(4);
        }
        if ((annotationName = CucumberJavaUtil.getAnnotationName(annotation)) == null) {
            return false;
        }
        String annotationSuffix = CucumberJavaUtil.getCucumberAnnotationSuffix(annotationName);
        return CucumberJavaAnnotationProvider.HOOK_MARKERS.contains(annotationSuffix);
    }

    public static boolean isStepDefinition(@NotNull PsiMethod method) {
        PsiAnnotation stepAnnotation;
        if (method == null) {
            CucumberJavaUtil.$$$reportNull$$$0(5);
        }
        return (stepAnnotation = CucumberJavaUtil.getCucumberStepAnnotation(method)) != null && CucumberJavaUtil.getAnnotationValue(stepAnnotation) != null;
    }

    public static boolean isHook(@NotNull PsiMethod method) {
        if (method == null) {
            CucumberJavaUtil.$$$reportNull$$$0(6);
        }
        return CucumberJavaUtil.getCucumberHookAnnotation(method) != null;
    }

    public static boolean isStepDefinitionClass(@NotNull PsiClass clazz) {
        PsiMethod[] methods;
        if (clazz == null) {
            CucumberJavaUtil.$$$reportNull$$$0(7);
        }
        for (PsiMethod method : methods = clazz.getAllMethods()) {
            if (CucumberJavaUtil.getCucumberStepAnnotation(method) == null && CucumberJavaUtil.getCucumberHookAnnotation(method) == null) continue;
            return true;
        }
        return false;
    }

    public static PsiAnnotation getCucumberStepAnnotation(@NotNull PsiMethod method) {
        if (method == null) {
            CucumberJavaUtil.$$$reportNull$$$0(8);
        }
        return CucumberJavaUtil.getCucumberStepAnnotation(method, null);
    }

    @Nullable
    public static PsiAnnotation getCucumberStepAnnotation(@NotNull PsiMethod method, @Nullable String annotationClassName) {
        PsiAnnotation[] annotations;
        if (method == null) {
            CucumberJavaUtil.$$$reportNull$$$0(9);
        }
        if (!method.hasModifierProperty("public")) {
            return null;
        }
        for (PsiAnnotation annotation : annotations = method.getModifierList().getAnnotations()) {
            if (annotation == null || annotationClassName != null && !annotationClassName.equals(annotation.getQualifiedName()) || !CucumberJavaUtil.isCucumberStepAnnotation(annotation)) continue;
            return annotation;
        }
        return null;
    }

    @Nullable
    public static String getStepAnnotationValue(@NotNull PsiMethod method, @Nullable String annotationClassName) {
        PsiAnnotation stepAnnotation;
        if (method == null) {
            CucumberJavaUtil.$$$reportNull$$$0(10);
        }
        if ((stepAnnotation = CucumberJavaUtil.getCucumberStepAnnotation(method, annotationClassName)) == null) {
            return null;
        }
        return CucumberJavaUtil.getAnnotationValue(stepAnnotation);
    }

    @Nullable
    public static String getAnnotationValue(@NotNull PsiAnnotation stepAnnotation) {
        if (stepAnnotation == null) {
            CucumberJavaUtil.$$$reportNull$$$0(11);
        }
        return AnnotationUtil.getDeclaredStringAttributeValue((PsiAnnotation)stepAnnotation, (String)"value");
    }

    @Nullable
    public static PsiAnnotation getCucumberHookAnnotation(PsiMethod method) {
        PsiAnnotation[] annotations;
        if (!method.hasModifierProperty("public")) {
            return null;
        }
        for (PsiAnnotation annotation : annotations = method.getModifierList().getAnnotations()) {
            if (annotation == null || !CucumberJavaUtil.isCucumberHookAnnotation(annotation)) continue;
            return annotation;
        }
        return null;
    }

    @Nullable
    public static String getPatternFromStepDefinition(@NotNull PsiAnnotation stepAnnotation) {
        if (stepAnnotation == null) {
            CucumberJavaUtil.$$$reportNull$$$0(12);
        }
        return AnnotationUtil.getStringAttributeValue((PsiAnnotation)stepAnnotation, null);
    }

    @Nullable
    private static String getPackageOfStepDef(GherkinStep[] steps) {
        for (GherkinStep step : steps) {
            String pack = CucumberJavaUtil.getPackageOfStep(step);
            if (pack == null) continue;
            return pack;
        }
        return null;
    }

    @NotNull
    public static String getPackageOfStepDef(PsiElement element) {
        GherkinFeature feature;
        PsiFile file = element.getContainingFile();
        if (file instanceof GherkinFile && (feature = (GherkinFeature)PsiTreeUtil.getChildOfType((PsiElement)file, GherkinFeature.class)) != null) {
            List scenarioList = PsiTreeUtil.getChildrenOfTypeAsList((PsiElement)feature, GherkinScenario.class);
            for (GherkinScenario scenario : scenarioList) {
                String result = CucumberJavaUtil.getPackageOfStepDef(scenario.getSteps());
                if (result == null) continue;
                String string = result;
                if (string == null) {
                    CucumberJavaUtil.$$$reportNull$$$0(13);
                }
                return string;
            }
            List scenarioOutlineList = PsiTreeUtil.getChildrenOfTypeAsList((PsiElement)feature, GherkinScenarioOutline.class);
            for (GherkinScenarioOutline scenario : scenarioOutlineList) {
                String result = CucumberJavaUtil.getPackageOfStepDef(scenario.getSteps());
                if (result == null) continue;
                String string = result;
                if (string == null) {
                    CucumberJavaUtil.$$$reportNull$$$0(14);
                }
                return string;
            }
        }
        if ("" == null) {
            CucumberJavaUtil.$$$reportNull$$$0(15);
        }
        return "";
    }

    public static String getPackageOfStep(GherkinStep step) {
        for (PsiReference ref : step.getReferences()) {
            PsiClassOwner file;
            String packageName;
            PsiElement refElement = ref.resolve();
            if (!(refElement instanceof PsiMethod) && !(refElement instanceof PsiMethodCallExpression) || !StringUtil.isNotEmpty((String)(packageName = (file = (PsiClassOwner)refElement.getContainingFile()).getPackageName()))) continue;
            return packageName;
        }
        return null;
    }

    public static void addGlue(String glue, Set<String> glues) {
        boolean covered = false;
        HashSet toRemove = ContainerUtil.newHashSet();
        for (String existedGlue : glues) {
            if (glue.startsWith(existedGlue + ".")) {
                covered = true;
                break;
            }
            if (!existedGlue.startsWith(glue + ".")) continue;
            toRemove.add(existedGlue);
        }
        for (String removing : toRemove) {
            glues.remove(removing);
        }
        if (!covered) {
            glues.add(glue);
        }
    }

    public static MapParameterTypeManager getAllParameterTypes(@NotNull Module module) {
        PsiDirectory psiDirectory;
        if (module == null) {
            CucumberJavaUtil.$$$reportNull$$$0(16);
        }
        Project project = module.getProject();
        PsiManager manager = PsiManager.getInstance((Project)project);
        VirtualFile projectDir = ProjectUtil.guessProjectDir((Project)project);
        PsiDirectory psiDirectory2 = psiDirectory = projectDir != null ? manager.findDirectory(projectDir) : null;
        if (psiDirectory != null) {
            return (MapParameterTypeManager)CachedValuesManager.getCachedValue((PsiElement)psiDirectory, () -> {
                if (module == null) {
                    CucumberJavaUtil.$$$reportNull$$$0(20);
                }
                return CachedValueProvider.Result.create((Object)CucumberJavaUtil.doGetAllParameterTypes(module), (Object[])new Object[]{PsiModificationTracker.MODIFICATION_COUNT});
            });
        }
        return MapParameterTypeManager.DEFAULT;
    }

    @NotNull
    private static MapParameterTypeManager doGetAllParameterTypes(@NotNull Module module) {
        if (module == null) {
            CucumberJavaUtil.$$$reportNull$$$0(17);
        }
        GlobalSearchScope dependenciesScope = module.getModuleWithDependenciesAndLibrariesScope(true);
        CommonProcessors.CollectProcessor processor = new CommonProcessors.CollectProcessor();
        JavaMethodFindUsagesOptions options = new JavaMethodFindUsagesOptions((SearchScope)dependenciesScope);
        PsiClass parameterTypeClass = ClassUtil.findPsiClass((PsiManager)PsiManager.getInstance((Project)module.getProject()), (String)PARAMETER_TYPE_CLASS);
        if (parameterTypeClass != null) {
            for (PsiMethod constructor : parameterTypeClass.getConstructors()) {
                JavaFindUsagesHelper.processElementUsages((PsiElement)constructor, (FindUsagesOptions)options, (Processor)processor);
            }
        }
        SmartPointerManager smartPointerManager = SmartPointerManager.getInstance((Project)module.getProject());
        HashMap<String, String> values = new HashMap<String, String>();
        HashMap<String, SmartPsiElementPointer> declarations = new HashMap<String, SmartPsiElementPointer>();
        for (UsageInfo ui : processor.getResults()) {
            PsiConstantEvaluationHelper evaluationHelper;
            Object constantValue;
            PsiExpression[] expressions;
            PsiNewExpression newExpression;
            PsiExpressionList arguments;
            PsiElement element = ui.getElement();
            if (element == null || !(element.getParent() instanceof PsiNewExpression) || (arguments = (newExpression = (PsiNewExpression)element.getParent()).getArgumentList()) == null || (expressions = arguments.getExpressions()).length <= 1 || (constantValue = (evaluationHelper = JavaPsiFacade.getInstance((Project)module.getProject()).getConstantEvaluationHelper()).computeConstantExpression((PsiElement)expressions[0], false)) == null) continue;
            String name = constantValue.toString();
            constantValue = evaluationHelper.computeConstantExpression((PsiElement)expressions[1], false);
            if (constantValue == null) continue;
            String value = constantValue.toString();
            values.put(name, value);
            SmartPsiElementPointer smartPointer = smartPointerManager.createSmartPsiElementPointer((PsiElement)expressions[0]);
            declarations.put(name, smartPointer);
        }
        values.putAll(CucumberUtil.STANDARD_PARAMETER_TYPES);
        values.putAll(JAVA_PARAMETER_TYPES);
        MapParameterTypeManager mapParameterTypeManager = new MapParameterTypeManager(values, declarations);
        if (mapParameterTypeManager == null) {
            CucumberJavaUtil.$$$reportNull$$$0(18);
        }
        return mapParameterTypeManager;
    }

    public static boolean isCucumberExpressionsAvailable(@NotNull PsiElement context) {
        if (context == null) {
            CucumberJavaUtil.$$$reportNull$$$0(19);
        }
        PsiLocation location = new PsiLocation(context);
        return LocationUtil.isJarAttached((Location)location, (PsiDirectory[])PsiDirectory.EMPTY_ARRAY, (String[])new String[]{CUCUMBER_EXPRESSIONS_CLASS_MARKER});
    }

    static {
        HashMap javaParameterTypes = new HashMap();
        javaParameterTypes.put("short", CucumberUtil.STANDARD_PARAMETER_TYPES.get("int"));
        javaParameterTypes.put("biginteger", CucumberUtil.STANDARD_PARAMETER_TYPES.get("int"));
        javaParameterTypes.put("bigdecimal", "-?\\d*[.,]\\d+");
        javaParameterTypes.put("byte", CucumberUtil.STANDARD_PARAMETER_TYPES.get("int"));
        javaParameterTypes.put("double", CucumberUtil.STANDARD_PARAMETER_TYPES.get("float"));
        javaParameterTypes.put("long", CucumberUtil.STANDARD_PARAMETER_TYPES.get("int"));
        JAVA_PARAMETER_TYPES = Collections.unmodifiableMap(javaParameterTypes);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 13: 
            case 14: 
            case 15: 
            case 18: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 13: 
            case 14: 
            case 15: 
            case 18: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
            case 1: 
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 21: {
                objectArray2 = objectArray3;
                objectArray3[0] = "annotation";
                break;
            }
            case 5: 
            case 6: 
            case 8: 
            case 9: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "method";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "clazz";
                break;
            }
            case 11: 
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "stepAnnotation";
                break;
            }
            case 13: 
            case 14: 
            case 15: 
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/plugins/cucumber/java/CucumberJavaUtil";
                break;
            }
            case 16: 
            case 17: 
            case 20: {
                objectArray2 = objectArray3;
                objectArray3[0] = "module";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/plugins/cucumber/java/CucumberJavaUtil";
                break;
            }
            case 13: 
            case 14: 
            case 15: {
                objectArray = objectArray2;
                objectArray2[1] = "getPackageOfStepDef";
                break;
            }
            case 18: {
                objectArray = objectArray2;
                objectArray2[1] = "doGetAllParameterTypes";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getCucumberAnnotationSuffix";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "getCucumberPendingExceptionFqn";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "getAnnotationName";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "isCucumberStepAnnotation";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "isCucumberHookAnnotation";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "isStepDefinition";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "isHook";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "isStepDefinitionClass";
                break;
            }
            case 8: 
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "getCucumberStepAnnotation";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "getStepAnnotationValue";
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "getAnnotationValue";
                break;
            }
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "getPatternFromStepDefinition";
                break;
            }
            case 13: 
            case 14: 
            case 15: 
            case 18: {
                break;
            }
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "getAllParameterTypes";
                break;
            }
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "doGetAllParameterTypes";
                break;
            }
            case 19: {
                objectArray = objectArray;
                objectArray[2] = "isCucumberExpressionsAvailable";
                break;
            }
            case 20: {
                objectArray = objectArray;
                objectArray[2] = "lambda$getAllParameterTypes$1";
                break;
            }
            case 21: {
                objectArray = objectArray;
                objectArray[2] = "lambda$getAnnotationName$0";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 13: 
            case 14: 
            case 15: 
            case 18: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

