/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.cucumber.java;

import com.intellij.ide.highlighter.JavaFileType;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.search.SearchScope;
import com.intellij.psi.search.searches.AnnotatedElementsSearch;
import com.intellij.util.Query;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.cucumber.BDDFrameworkType;
import org.jetbrains.plugins.cucumber.StepDefinitionCreator;
import org.jetbrains.plugins.cucumber.java.AbstractCucumberJavaExtension;
import org.jetbrains.plugins.cucumber.java.steps.JavaStepDefinition;
import org.jetbrains.plugins.cucumber.java.steps.JavaStepDefinitionCreator;
import org.jetbrains.plugins.cucumber.steps.AbstractStepDefinition;

public class CucumberJavaExtension
extends AbstractCucumberJavaExtension {
    public static final String CUCUMBER_RUNTIME_JAVA_STEP_DEF_ANNOTATION = "cucumber.runtime.java.StepDefAnnotation";
    public static final String ZUCHINI_RUNTIME_JAVA_STEP_DEF_ANNOTATION = "org.zuchini.annotations.StepAnnotation";

    @NotNull
    public BDDFrameworkType getStepFileType() {
        BDDFrameworkType bDDFrameworkType = new BDDFrameworkType((FileType)JavaFileType.INSTANCE);
        if (bDDFrameworkType == null) {
            CucumberJavaExtension.$$$reportNull$$$0(0);
        }
        return bDDFrameworkType;
    }

    @NotNull
    public StepDefinitionCreator getStepDefinitionCreator() {
        JavaStepDefinitionCreator javaStepDefinitionCreator = new JavaStepDefinitionCreator();
        if (javaStepDefinitionCreator == null) {
            CucumberJavaExtension.$$$reportNull$$$0(1);
        }
        return javaStepDefinitionCreator;
    }

    public List<AbstractStepDefinition> loadStepsFor(@Nullable PsiFile featureFile, @NotNull Module module) {
        if (module == null) {
            CucumberJavaExtension.$$$reportNull$$$0(2);
        }
        GlobalSearchScope dependenciesScope = module.getModuleWithDependenciesAndLibrariesScope(true);
        PsiClass stepDefAnnotationClass = JavaPsiFacade.getInstance((Project)module.getProject()).findClass(CUCUMBER_RUNTIME_JAVA_STEP_DEF_ANNOTATION, dependenciesScope);
        if (stepDefAnnotationClass == null) {
            stepDefAnnotationClass = JavaPsiFacade.getInstance((Project)module.getProject()).findClass(ZUCHINI_RUNTIME_JAVA_STEP_DEF_ANNOTATION, dependenciesScope);
        }
        if (stepDefAnnotationClass == null) {
            return Collections.emptyList();
        }
        ArrayList<AbstractStepDefinition> result = new ArrayList<AbstractStepDefinition>();
        Query stepDefAnnotations = AnnotatedElementsSearch.searchPsiClasses((PsiClass)stepDefAnnotationClass, (SearchScope)dependenciesScope);
        for (PsiClass annotationClass : stepDefAnnotations) {
            String annotationClassName = annotationClass.getQualifiedName();
            if (!annotationClass.isAnnotationType() || annotationClassName == null) continue;
            Query javaStepDefinitions = AnnotatedElementsSearch.searchPsiMethods((PsiClass)annotationClass, (SearchScope)dependenciesScope);
            for (PsiMethod stepDefMethod : javaStepDefinitions) {
                result.add(new JavaStepDefinition((PsiElement)stepDefMethod, annotationClassName));
            }
        }
        return result;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 2: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 2: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/plugins/cucumber/java/CucumberJavaExtension";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "module";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getStepFileType";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getStepDefinitionCreator";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/plugins/cucumber/java/CucumberJavaExtension";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "loadStepsFor";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 2: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

