/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.spring.security.references;

import com.intellij.openapi.module.Module;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiReferenceBase;
import com.intellij.spring.security.model.xml.converters.roles.SpringSecurityRolesFactory;
import com.intellij.util.ArrayUtil;
import com.intellij.util.containers.ContainerUtil;
import java.util.HashSet;
import org.jetbrains.annotations.NotNull;

public class SpringSecurityRolePsiReference
extends PsiReferenceBase<PsiElement> {
    private final String myRoleName;
    private final Module myModule;
    private final boolean myIncludePredefinedRoles;

    public SpringSecurityRolePsiReference(@NotNull PsiElement element, @NotNull String roleName, @NotNull Module module, boolean includePredefinedRoles) {
        if (element == null) {
            SpringSecurityRolePsiReference.$$$reportNull$$$0(0);
        }
        if (roleName == null) {
            SpringSecurityRolePsiReference.$$$reportNull$$$0(1);
        }
        if (module == null) {
            SpringSecurityRolePsiReference.$$$reportNull$$$0(2);
        }
        super(element, SpringSecurityRolePsiReference.getTextRange(element, roleName));
        this.myRoleName = roleName;
        this.myModule = module;
        this.myIncludePredefinedRoles = includePredefinedRoles;
    }

    private static TextRange getTextRange(PsiElement element, String roleName) {
        if (roleName.isEmpty()) {
            return TextRange.EMPTY_RANGE;
        }
        int offset = element.getText().indexOf(roleName);
        if (offset == -1) {
            return TextRange.EMPTY_RANGE;
        }
        return TextRange.from((int)offset, (int)roleName.length());
    }

    public PsiElement resolve() {
        if (StringUtil.isEmptyOrSpaces((String)this.myRoleName)) {
            return null;
        }
        return SpringSecurityRolesFactory.getInstance(this.myModule).getOrCreateRole(this.myRoleName, this.getElement().getContainingFile());
    }

    public boolean isSoft() {
        return true;
    }

    @NotNull
    public Object[] getVariants() {
        HashSet variants = new HashSet();
        SpringSecurityRolesFactory securityRolesFactory = SpringSecurityRolesFactory.getInstance(this.myModule);
        ContainerUtil.addAll(variants, (Object[])securityRolesFactory.getRolesVariants());
        if (this.myIncludePredefinedRoles) {
            ContainerUtil.addAll(variants, (Object[])securityRolesFactory.getPredefinedRolesVariants());
        }
        Object[] objectArray = ArrayUtil.toObjectArray(variants);
        if (objectArray == null) {
            SpringSecurityRolePsiReference.$$$reportNull$$$0(3);
        }
        return objectArray;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 3: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 3: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "roleName";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "module";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/spring/security/references/SpringSecurityRolePsiReference";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/spring/security/references/SpringSecurityRolePsiReference";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getVariants";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 3: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 3: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

