/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.actions;

import com.intellij.database.extensions.SchemaScripts;
import com.intellij.ide.util.PsiNavigationSupport;
import com.intellij.openapi.actionSystem.ActionGroup;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.Separator;
import com.intellij.openapi.project.DumbAware;
import com.intellij.openapi.project.DumbAwareAction;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.containers.ContainerUtil;
import java.io.File;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class RunExtensionScriptActionGroup
extends ActionGroup
implements DumbAware {
    public void update(@NotNull AnActionEvent e) {
        if (e == null) {
            RunExtensionScriptActionGroup.$$$reportNull$$$0(0);
        }
        e.getPresentation().setEnabledAndVisible(SchemaScripts.areAvailableIn(e.getDataContext()));
    }

    @NotNull
    public AnAction[] getChildren(@Nullable AnActionEvent e) {
        List runActions = ContainerUtil.map(SchemaScripts.getScriptFiles(), x$0 -> new RunScriptAction((File)x$0));
        List allActions = ContainerUtil.append((List)runActions, (Object[])new AnAction[]{new Separator(), new EditScriptsAction()});
        AnAction[] anActionArray = allActions.toArray(AnAction.EMPTY_ARRAY);
        if (anActionArray == null) {
            RunExtensionScriptActionGroup.$$$reportNull$$$0(1);
        }
        return anActionArray;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "e";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/database/actions/RunExtensionScriptActionGroup";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/database/actions/RunExtensionScriptActionGroup";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getChildren";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "update";
                break;
            }
            case 1: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static class RunScriptAction
    extends DumbAwareAction {
        private final File myScript;

        private RunScriptAction(@NotNull File script) {
            if (script == null) {
                RunScriptAction.$$$reportNull$$$0(0);
            }
            super(StringUtil.escapeMnemonics((String)script.getName()), "Execute database extension script", null);
            this.myScript = script;
        }

        public void actionPerformed(@NotNull AnActionEvent e) {
            if (e == null) {
                RunScriptAction.$$$reportNull$$$0(1);
            }
            SchemaScripts.runScript(e.getDataContext(), this.myScript);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "script";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "e";
                    break;
                }
            }
            objectArray2[1] = "com/intellij/database/actions/RunExtensionScriptActionGroup$RunScriptAction";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "<init>";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "actionPerformed";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    private static class EditScriptsAction
    extends DumbAwareAction {
        EditScriptsAction() {
            super("Go to Scripts Directory", "", null);
        }

        public void actionPerformed(@NotNull AnActionEvent e) {
            if (e == null) {
                EditScriptsAction.$$$reportNull$$$0(0);
            }
            Project project = e.getProject();
            File scriptsDir = SchemaScripts.getScriptsDirectory();
            if (project == null || scriptsDir == null) {
                return;
            }
            VirtualFile virtualFile = LocalFileSystem.getInstance().refreshAndFindFileByIoFile(scriptsDir);
            if (virtualFile == null) {
                return;
            }
            PsiNavigationSupport.getInstance().createNavigatable(project, virtualFile, -1).navigate(true);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/database/actions/RunExtensionScriptActionGroup$EditScriptsAction", "actionPerformed"));
        }
    }
}

