/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.beanValidation.toolWindow.tree.nodes;

import com.intellij.beanValidation.model.xml.Constraint;
import com.intellij.beanValidation.model.xml.Element;
import com.intellij.beanValidation.toolWindow.tree.nodes.AbstractBvXmlNode;
import com.intellij.ide.projectView.PresentationData;
import com.intellij.psi.PsiArrayType;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiType;
import com.intellij.psi.util.TypeConversionUtil;
import com.intellij.psi.xml.XmlElement;
import com.intellij.ui.JBColor;
import com.intellij.ui.SimpleTextAttributes;
import com.intellij.ui.treeStructure.SimpleNode;
import com.intellij.util.ui.PlatformColors;
import com.intellij.util.ui.UIUtil;
import com.intellij.util.xml.GenericDomValue;
import java.awt.Color;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public class ConstraintNode
extends AbstractBvXmlNode {
    private final PsiClass myClass;
    private final Constraint myConstraint;
    private static final SimpleTextAttributes ANNO = new SimpleTextAttributes(0, new Color(128, 128, 0));
    private static final SimpleTextAttributes PLAIN = new SimpleTextAttributes(0, UIUtil.getLabelForeground());
    private static final SimpleTextAttributes BOLD = new SimpleTextAttributes(1, UIUtil.getLabelForeground());
    private static final SimpleTextAttributes BOOL = new SimpleTextAttributes(1, new Color(0, 0, 128));
    private static final SimpleTextAttributes NUM = new SimpleTextAttributes(0, PlatformColors.BLUE);
    private static final SimpleTextAttributes STRING = new SimpleTextAttributes(1, new Color(0, 128, 0));
    private static final SimpleTextAttributes ENUM = new SimpleTextAttributes(1, new Color(102, 14, 122));

    public ConstraintNode(SimpleNode parent, Constraint constraint) {
        super(parent, (PsiElement)constraint.getAnnotation().getValue(), (XmlElement)constraint.getAnnotation().getXmlAttributeValue());
        this.myConstraint = constraint;
        this.myClass = (PsiClass)this.getPsiElement();
    }

    protected void update(@NotNull PresentationData presentation) {
        if (presentation == null) {
            ConstraintNode.$$$reportNull$$$0(0);
        }
        super.update(presentation);
        if (this.myClass == null) {
            presentation.addText("@unknown", new SimpleTextAttributes(16, (Color)JBColor.RED));
            return;
        }
        presentation.addText("@" + this.myClass.getName(), ANNO);
        List<Element> elements = this.myConstraint.getElements();
        if (!elements.isEmpty()) {
            presentation.addText("(", PLAIN);
            for (int i = 0; i < elements.size(); ++i) {
                List<GenericDomValue<String>> values;
                PsiType type;
                Element element = elements.get(i);
                PsiMethod method = (PsiMethod)element.getName().getValue();
                if (method == null || (type = method.getReturnType()) == null) continue;
                presentation.addText(String.valueOf(element.getName()), BOLD);
                presentation.addText(" = ", PLAIN);
                if (type instanceof PsiArrayType) {
                    type = ((PsiArrayType)type).getComponentType();
                }
                if ((values = element.getValues()).isEmpty()) {
                    String val = element.getValue();
                    ConstraintNode.addValue(val, type, presentation);
                } else {
                    presentation.addText("{", PLAIN);
                    for (int j = 0; j < values.size(); ++j) {
                        GenericDomValue<String> value = values.get(j);
                        String val = (String)value.getValue();
                        ConstraintNode.addValue(val, type, presentation);
                        if (j >= values.size() - 1) continue;
                        presentation.addText(", ", PLAIN);
                    }
                    presentation.addText("}", PLAIN);
                }
                if (i >= elements.size() - 1) continue;
                presentation.addText(", ", PLAIN);
            }
            presentation.addText(")", PLAIN);
        }
    }

    private static void addValue(String val, PsiType type, PresentationData presentation) {
        boolean isEnum;
        boolean isBool = TypeConversionUtil.isBooleanType((PsiType)type) || "java.lang.Boolean".equals(type.getCanonicalText());
        boolean isNum = TypeConversionUtil.isNumericType((PsiType)type);
        boolean isString = "java.lang.String".equals(type.getCanonicalText());
        PsiClass typeClass = type instanceof PsiClassType ? ((PsiClassType)type).resolve() : null;
        boolean isClass = typeClass != null && "java.lang.Class".equals(typeClass.getQualifiedName());
        boolean bl = isEnum = typeClass != null && typeClass.isEnum();
        if (TypeConversionUtil.isPrimitive((String)type.getCanonicalText()) || TypeConversionUtil.isPrimitiveWrapper((String)type.getCanonicalText())) {
            presentation.addText(isBool || isNum ? val : "'" + val + "'", isBool ? BOOL : NUM);
        } else if (isString) {
            presentation.addText("\"" + val + "\"", STRING);
        } else if (isClass) {
            int ind = val.lastIndexOf("");
            if (ind != -1) {
                val = val.substring(ind + 1);
            }
            presentation.addText(val, PLAIN);
            presentation.addText(".class", BOOL);
        } else if (isEnum) {
            presentation.addText(typeClass.getName() + "", PLAIN);
            presentation.addText(val, ENUM);
        } else {
            presentation.addText(val, PLAIN);
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "presentation", "com/intellij/beanValidation/toolWindow/tree/nodes/ConstraintNode", "update"));
    }
}

