/*
 * Decompiled with CFR 0.152.
 */
package com.springsource.util.osgi.manifest.parse.standard;

import com.springsource.util.osgi.manifest.parse.standard.HeaderToken;
import com.springsource.util.osgi.manifest.parse.standard.HeaderTokenKind;

public final class BasicHeaderToken
implements HeaderToken {
    private HeaderTokenKind kind;
    private char[] headerText;
    private int startoffset;
    private int endoffset;
    private int extendedEndOffset;
    private byte bits;
    private static final byte STARTED_WITH_LETTER = 1;
    private static final byte ATTRIBUTE_NAME = 2;
    private static final byte DIRECTIVE_NAME = 4;
    private static final byte SPACED = 16;
    private static final byte IS_EXTENDED = 32;
    private static final byte FOLLOWED_BY_SPACE = 64;

    private BasicHeaderToken(char[] headerText, HeaderTokenKind kind, int start, int end) {
        this.headerText = headerText;
        this.kind = kind;
        this.startoffset = start;
        this.endoffset = end;
    }

    public static BasicHeaderToken makeToken(char[] data, HeaderTokenKind kind, int start, int end) {
        return new BasicHeaderToken(data, kind, start, end);
    }

    public char[] value() {
        return this.subarray(this.startoffset, this.endoffset);
    }

    public String toString() {
        StringBuilder s = new StringBuilder();
        s.append("'").append(this.stringValue()).append("'");
        s.append("@").append(this.startoffset).append(":").append(this.endoffset);
        return s.toString();
    }

    public HeaderTokenKind getKind() {
        return this.kind;
    }

    public int getEndOffset() {
        return this.endoffset;
    }

    public int getStartOffset() {
        return this.startoffset;
    }

    public String stringValue() {
        return new String(this.value());
    }

    public char[] extendedValue() {
        return this.subarray(this.startoffset, this.extendedEndOffset);
    }

    private final char[] subarray(int start, int end) {
        char[] result = new char[end - start];
        System.arraycopy(this.headerText, start, result, 0, end - start);
        return result;
    }

    public boolean isExtended() {
        return (this.bits & 0x20) != 0;
    }

    public void setExtendedOffset(int endOffset) {
        this.bits = (byte)(this.bits | 0x20);
        this.extendedEndOffset = endOffset;
    }

    public int getExtendedEndOffset() {
        return this.extendedEndOffset;
    }

    public boolean isSpaced() {
        return (this.bits & 0x10) != 0;
    }

    public boolean firstCharIsLetter() {
        return (this.bits & 1) != 0;
    }

    public boolean isAttributeOrDirectiveName() {
        return (this.bits & 6) != 0;
    }

    public boolean hasFollowingSpace() {
        return (this.bits & 0x40) != 0;
    }

    public char firstChar() {
        return this.headerText[this.startoffset];
    }

    public boolean isAttributeName() {
        return (this.bits & 2) != 0;
    }

    public boolean isDirectiveName() {
        return (this.bits & 4) != 0;
    }

    public void tagAsDirectiveName() {
        this.bits = (byte)(this.bits | 4);
    }

    public void tagAsAttributeName() {
        this.bits = (byte)(this.bits | 2);
    }

    public void tagAsStartedWithLetter() {
        this.bits = (byte)(this.bits | 1);
    }

    public void tagAsSpaced() {
        this.bits = (byte)(this.bits | 0x10);
    }

    public void tagAsFollowedBySpace() {
        this.bits = (byte)(this.bits | 0x40);
    }
}

