/*
 * Decompiled with CFR 0.152.
 */
package com.springsource.util.math;

import com.springsource.util.math.ConcurrentSet;
import java.util.Collection;
import java.util.Iterator;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class ConcurrentHashSet<Elem>
implements ConcurrentSet<Elem> {
    private final ConcurrentMap<Elem, Boolean> elems = new ConcurrentHashMap<Elem, Boolean>();

    @Override
    public boolean add(Elem e) {
        return this.elems.putIfAbsent(e, Boolean.TRUE) == null;
    }

    @Override
    public boolean addAll(Collection<? extends Elem> c) {
        boolean updated = false;
        for (Elem e : c) {
            updated |= this.add(e);
        }
        return updated;
    }

    @Override
    public void clear() {
        this.elems.clear();
    }

    @Override
    public boolean contains(Object o) {
        return this.elems.containsKey(o);
    }

    @Override
    public boolean containsAll(Collection<?> c) {
        for (Object o : c) {
            if (this.contains(o)) continue;
            return false;
        }
        return true;
    }

    @Override
    public boolean isEmpty() {
        return this.elems.isEmpty();
    }

    @Override
    public Iterator<Elem> iterator() {
        return this.elems.keySet().iterator();
    }

    @Override
    public boolean remove(Object o) {
        return this.elems.remove(o) != null;
    }

    @Override
    public boolean removeAll(Collection<?> c) {
        boolean updated = false;
        for (Object o : c) {
            updated |= this.remove(o);
        }
        return updated;
    }

    @Override
    public boolean retainAll(Collection<?> c) {
        boolean updated = false;
        for (Object e : this.elems.keySet()) {
            if (c.contains(e)) continue;
            updated = true;
            this.elems.remove(e);
        }
        return updated;
    }

    @Override
    public int size() {
        return this.elems.size();
    }

    @Override
    public Object[] toArray() {
        return this.elems.keySet().toArray();
    }

    @Override
    public <T> T[] toArray(T[] a) {
        return this.elems.keySet().toArray(a);
    }
}

