/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.dmserver.run.remote;

import com.intellij.dmserver.run.DMServerModelBase;
import com.intellij.dmserver.run.remote.DMRemoteRunConfigurationEditor;
import com.intellij.execution.configurations.RuntimeConfigurationError;
import com.intellij.execution.configurations.RuntimeConfigurationException;
import com.intellij.javaee.run.configuration.CommonModel;
import com.intellij.javaee.transport.TransportHost;
import com.intellij.javaee.transport.TransportManager;
import com.intellij.javaee.transport.TransportTarget;
import com.intellij.openapi.options.SettingsEditor;
import com.intellij.openapi.util.InvalidDataException;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.WriteExternalException;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.xmlb.SerializationFilter;
import com.intellij.util.xmlb.SkipDefaultValuesSerializationFilters;
import com.intellij.util.xmlb.XmlSerializer;
import com.intellij.util.xmlb.annotations.Tag;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Collections;
import java.util.List;
import org.jdom.Element;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class DMServerRemoteModel
extends DMServerModelBase {
    private String myJmxMappingUrl;
    private String myTransportHostId;
    private TransportTarget myTransportTargetRepository;
    private TransportTarget myTransportTargetJmx;
    private String myRepositoryName;

    public List<Pair<String, Integer>> getAddressesToCheck() {
        return Collections.emptyList();
    }

    protected void read(@NotNull Element element, boolean isPersistent) throws InvalidDataException {
        if (element == null) {
            DMServerRemoteModel.$$$reportNull$$$0(0);
        }
        DMServerRemoteModelSettings settings = new DMServerRemoteModelSettings();
        XmlSerializer.deserializeInto((Object)settings, (Element)element);
        this.readFromSettingsBase(settings, isPersistent);
        this.myJmxMappingUrl = settings.getJmxMappingUrl();
        this.myRepositoryName = settings.getRepositoryName();
        this.myTransportHostId = settings.getTransportHostId();
        this.myTransportTargetRepository = settings.getTransportTargetRepository();
        this.myTransportTargetJmx = settings.getTransportTargetJmx();
    }

    protected void write(@NotNull Element element, boolean isPersistent) throws WriteExternalException {
        if (element == null) {
            DMServerRemoteModel.$$$reportNull$$$0(1);
        }
        DMServerRemoteModelSettings settings = new DMServerRemoteModelSettings();
        this.writeToSettingsBase(settings, isPersistent);
        settings.setJmxMappingUrl(this.myJmxMappingUrl);
        settings.setRepositoryName(this.myRepositoryName);
        settings.setTransportHostId(this.myTransportHostId);
        settings.setTransportTargetRepository(this.myTransportTargetRepository);
        settings.setTransportTargetJmx(this.myTransportTargetJmx);
        XmlSerializer.serializeInto((Object)settings, (Element)element, (SerializationFilter)new SkipDefaultValuesSerializationFilters());
    }

    @Override
    public URL computeServerAccessibleStagingURL(String deploymentSourcePath) throws MalformedURLException {
        if (this.myJmxMappingUrl == null) {
            throw new MalformedURLException("Wow, staging folder is not mapped, configuration should not pass validation");
        }
        return this.createJmxMappingUrl();
    }

    @Nullable
    private TransportHost getHost() {
        return TransportManager.getInstance().findHost(this.myTransportHostId, this.getProject());
    }

    @Override
    public boolean addToRepository(List<VirtualFile> filesToDeploy) {
        TransportHost host = this.getHost();
        return host != null && host.findOrCreateHostTarget(this.myTransportTargetRepository).transfer(this.getProject(), filesToDeploy);
    }

    @Override
    public boolean removeFromRepository(List<VirtualFile> filesToUndeploy) {
        TransportHost host = this.getHost();
        return host != null && host.findOrCreateHostTarget(this.myTransportTargetRepository).delete(this.getProject(), filesToUndeploy);
    }

    @Override
    public String getRepositoryName() {
        return this.myRepositoryName;
    }

    public void setRepositoryName(String repositoryName) {
        this.myRepositoryName = repositoryName;
    }

    @Override
    public boolean prepareDeploy(VirtualFile fileToDeploy) {
        TransportHost host = this.getHost();
        return host != null && host.findOrCreateHostTarget(this.myTransportTargetJmx).transfer(this.getProject(), Collections.singletonList(fileToDeploy));
    }

    public void checkConfiguration() throws RuntimeConfigurationException {
        this.validateMappingURL();
    }

    public SettingsEditor<CommonModel> getEditor() {
        return new DMRemoteRunConfigurationEditor(this.getProject());
    }

    private void validateMappingURL() throws RuntimeConfigurationException {
        if (StringUtil.isEmptyOrSpaces((String)this.myJmxMappingUrl)) {
            throw new RuntimeConfigurationError("Mapping URL is not configured");
        }
        try {
            this.createJmxMappingUrl();
        }
        catch (MalformedURLException ignored) {
            throw new RuntimeConfigurationError("Mapping URL is not valid: " + this.myJmxMappingUrl);
        }
    }

    private URL createJmxMappingUrl() throws MalformedURLException {
        String fixCommonProblems = this.myJmxMappingUrl.replaceAll(" ", "%20");
        if (!fixCommonProblems.endsWith("/")) {
            fixCommonProblems = fixCommonProblems + "/";
        }
        return new URL(fixCommonProblems);
    }

    public String getJmxMappingUrl() {
        return this.myJmxMappingUrl;
    }

    public void setJmxMappingUrl(String jmxMappingUrl) {
        this.myJmxMappingUrl = jmxMappingUrl;
    }

    public String getTransportHostId() {
        return this.myTransportHostId;
    }

    public void setTransportHostId(String transportHostId) {
        this.myTransportHostId = transportHostId;
    }

    public TransportTarget getTransportTargetJmx() {
        return this.myTransportTargetJmx;
    }

    public void setTransportTargetJmx(TransportTarget transportTargetJmx) {
        this.myTransportTargetJmx = transportTargetJmx;
    }

    public TransportTarget getTransportTargetRepository() {
        return this.myTransportTargetRepository;
    }

    public void setTransportTargetRepository(TransportTarget transportTargetRepository) {
        this.myTransportTargetRepository = transportTargetRepository;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[3];
        objectArray2[0] = "element";
        objectArray2[1] = "com/intellij/dmserver/run/remote/DMServerRemoteModel";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "read";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "write";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    public static class DMServerRemoteModelSettings
    extends DMServerModelBase.DMServerModelSettingsBase {
        @Tag(value="staging-url")
        private String myJmxMappingUrl;
        @Tag(value="host-id")
        private String myTransportHostId;
        @Tag(value="transport-target-repository")
        private TransportTarget myTransportTargetRepository;
        @Tag(value="transport-target-staging")
        private TransportTarget myTransportTargetJmx;
        @Tag(value="repository-name")
        private String myRepositoryName;

        public String getJmxMappingUrl() {
            return this.myJmxMappingUrl;
        }

        public void setJmxMappingUrl(String stagingFolderURL) {
            this.myJmxMappingUrl = stagingFolderURL;
        }

        public String getTransportHostId() {
            return this.myTransportHostId;
        }

        public void setTransportHostId(String transportHostId) {
            this.myTransportHostId = transportHostId;
        }

        public TransportTarget getTransportTargetRepository() {
            return this.myTransportTargetRepository;
        }

        public void setTransportTargetRepository(TransportTarget transportTargetRepository) {
            this.myTransportTargetRepository = transportTargetRepository;
        }

        public TransportTarget getTransportTargetJmx() {
            return this.myTransportTargetJmx;
        }

        public void setTransportTargetJmx(TransportTarget transportTargetJmx) {
            this.myTransportTargetJmx = transportTargetJmx;
        }

        public String getRepositoryName() {
            return this.myRepositoryName;
        }

        public void setRepositoryName(String repositoryName) {
            this.myRepositoryName = repositoryName;
        }
    }
}

