/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.dmserver.run;

import com.intellij.dmserver.artifacts.DMBundleArtifactType;
import com.intellij.dmserver.artifacts.DMParArtifactType;
import com.intellij.dmserver.artifacts.DMPlanArtifactType;
import com.intellij.dmserver.artifacts.ManifestManager;
import com.intellij.dmserver.artifacts.WithModuleArtifactUtil;
import com.intellij.dmserver.deploy.DMServerDeploymentProvider;
import com.intellij.dmserver.facet.DMCompositeFacet;
import com.intellij.dmserver.facet.NestedUnitIdentity;
import com.intellij.dmserver.install.DMServerInstallation;
import com.intellij.dmserver.integration.DMServerIntegrationData;
import com.intellij.dmserver.run.DMServerInstance;
import com.intellij.dmserver.util.ManifestUtils;
import com.intellij.execution.ExecutionException;
import com.intellij.execution.process.ProcessHandler;
import com.intellij.javaee.appServerIntegrations.ApplicationServerUrlMapping;
import com.intellij.javaee.deployment.DeploymentProvider;
import com.intellij.javaee.run.configuration.CommonModel;
import com.intellij.javaee.run.configuration.ServerModelBase;
import com.intellij.javaee.run.execution.DefaultOutputProcessor;
import com.intellij.javaee.run.execution.OutputProcessor;
import com.intellij.javaee.serverInstances.J2EEServerInstance;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.packaging.artifacts.Artifact;
import com.intellij.packaging.artifacts.ArtifactType;
import com.intellij.psi.PsiFile;
import com.intellij.util.xmlb.annotations.Tag;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.List;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class DMServerModelBase
extends ServerModelBase {
    private CommonModel myCommonModel;
    private int myPort = 8080;
    private String myMBeanServerUserName = "admin";
    private int myMBeanServerPort = 9875;
    private String myMBeanServerPassword = "springsource";
    private String myCredentialAlias;
    private boolean myIsTemplate;

    public final void setCommonModel(CommonModel commonModel) {
        this.myCommonModel = commonModel;
    }

    public abstract boolean prepareDeploy(VirtualFile var1);

    public abstract URL computeServerAccessibleStagingURL(String var1) throws MalformedURLException;

    public abstract boolean addToRepository(List<VirtualFile> var1);

    public abstract boolean removeFromRepository(List<VirtualFile> var1);

    @Nullable
    public abstract String getRepositoryName();

    public final CommonModel getCommonModel() {
        return this.myCommonModel;
    }

    public final Project getProject() {
        return this.getCommonModel().getProject();
    }

    public final J2EEServerInstance createServerInstance() throws ExecutionException {
        DMServerIntegrationData integrationData = (DMServerIntegrationData)this.getCommonModel().getApplicationServer().getPersistentData();
        DMServerInstallation installation = integrationData.getInstallation();
        if (installation == null) {
            throw new ExecutionException("Can not locate dmServer home");
        }
        if (!installation.isValid()) {
            throw new ExecutionException("Can not locate dmServer startup/shutdown script");
        }
        return new DMServerInstance(this.myCommonModel, installation.getServerVersion());
    }

    public final DeploymentProvider getDeploymentProvider() {
        return new DMServerDeploymentProvider();
    }

    public int getDefaultPort() {
        return 8080;
    }

    @NotNull
    @NonNls
    public String getDefaultUrlForBrowser() {
        ApplicationServerUrlMapping urlMapping = (ApplicationServerUrlMapping)this.myCommonModel.getIntegration().getDeployedFileUrlProvider();
        String webContext = this.searchWebContext(this.myCommonModel.getDeployedArtifacts());
        String string = urlMapping.getDefaultUrlForServerConfig(this.myCommonModel) + StringUtil.notNullize((String)webContext);
        if (string == null) {
            DMServerModelBase.$$$reportNull$$$0(0);
        }
        return string;
    }

    public String searchWebContext(List<Artifact> artifacts) {
        String context = null;
        for (Artifact artifact : artifacts) {
            Module module = WithModuleArtifactUtil.findModuleFor(this.myCommonModel.getProject(), artifact);
            ArtifactType artifactType = artifact.getArtifactType();
            if (artifactType == DMBundleArtifactType.getInstance()) {
                if (module == null) {
                    return null;
                }
                ManifestManager.FileWrapper manifestFile = ManifestManager.getBundleInstance().findManifest(module);
                if (manifestFile == null) {
                    return null;
                }
                context = ManifestUtils.getInstance().getHeaderValue((PsiFile)manifestFile.getFile(), "Web-ContextPath");
            }
            if (artifactType != DMPlanArtifactType.getInstance() && artifactType != DMParArtifactType.getInstance()) continue;
            DMCompositeFacet facet = DMCompositeFacet.getInstance(module);
            if (facet == null) {
                return null;
            }
            List nestedUnitIdentities = (List)facet.getConfigurationImpl().getNestedBundles();
            for (NestedUnitIdentity nest : nestedUnitIdentities) {
                List<Artifact> nestArtifacts = WithModuleArtifactUtil.findWithModuleArtifactsFor(nest.getModule());
                context = this.searchWebContext(nestArtifacts);
            }
            if (context != null) continue;
            return null;
        }
        return context;
    }

    public OutputProcessor createOutputProcessor(ProcessHandler processHandler, J2EEServerInstance serverInstance) {
        return new DefaultOutputProcessor(processHandler);
    }

    public int getLocalPort() {
        return this.myPort;
    }

    public void setPort(int port) {
        this.myPort = port;
    }

    public boolean isTemplate() {
        return this.myIsTemplate;
    }

    protected void setTemplate(boolean isTemplate) {
        this.myIsTemplate = isTemplate;
    }

    @Nullable
    public String getPassword() {
        return this.getMBeanServerPassword();
    }

    public void setPassword(@NotNull String password) {
        if (password == null) {
            DMServerModelBase.$$$reportNull$$$0(1);
        }
        this.setMBeanServerPassword(password);
    }

    protected boolean isDefaultPasswords() {
        return "springsource".equals(this.getPassword());
    }

    @Nullable
    protected String getCredentialAlias() {
        return this.myCredentialAlias;
    }

    protected void setCredentialAlias(@Nullable String credentialAlias) {
        this.myCredentialAlias = credentialAlias;
    }

    public String getMBeanServerUserName() {
        return this.myMBeanServerUserName;
    }

    public void setMBeanServerUserName(String beanServerUserName) {
        this.myMBeanServerUserName = beanServerUserName;
    }

    public int getMBeanServerPort() {
        return this.myMBeanServerPort;
    }

    public void setMBeanServerPort(int beanServerPort) {
        this.myMBeanServerPort = beanServerPort;
    }

    public String getMBeanServerPassword() {
        return this.myMBeanServerPassword;
    }

    public void setMBeanServerPassword(String beanServerPassword) {
        this.myMBeanServerPassword = beanServerPassword;
    }

    protected void readFromSettingsBase(@NotNull DMServerModelSettingsBase settings, boolean isPersistent) {
        if (settings == null) {
            DMServerModelBase.$$$reportNull$$$0(2);
        }
        this.myPort = settings.getPort();
        this.myMBeanServerUserName = settings.getMBeanUserName();
        this.myMBeanServerPort = settings.getMBeanPort();
        if (!isPersistent) {
            this.myIsTemplate = settings.isTemplate();
        }
        if (!this.myIsTemplate) {
            this.myMBeanServerPassword = settings.getMBeanPassword();
            this.myCredentialAlias = settings.getCredentialAlias();
        }
    }

    protected void writeToSettingsBase(@NotNull DMServerModelSettingsBase settings, boolean isPersistent) {
        if (settings == null) {
            DMServerModelBase.$$$reportNull$$$0(3);
        }
        settings.setPort(this.myPort);
        settings.setMBeanUserName(this.myMBeanServerUserName);
        settings.setMBeanPort(this.myMBeanServerPort);
        if (!this.myIsTemplate) {
            if (!isPersistent) {
                settings.setMBeanPassword(this.myMBeanServerPassword);
            }
            settings.setCredentialAlias(this.myCredentialAlias);
        }
        if (!isPersistent) {
            settings.setTemplate(this.myIsTemplate);
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/dmserver/run/DMServerModelBase";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "password";
                break;
            }
            case 2: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "settings";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getDefaultUrlForBrowser";
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/dmserver/run/DMServerModelBase";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "setPassword";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "readFromSettingsBase";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "writeToSettingsBase";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    public static abstract class DMServerModelSettingsBase {
        @Tag(value="port")
        private int myPort = 8080;
        @Tag(value="mbean-port")
        private int myMBeanPort;
        @Tag(value="mbean-user")
        private String myMBeanUserName;
        @Tag(value="mbean-password")
        private String myMBeanPassword;
        @Tag(value="credentialAlias")
        private String myCredentialAlias;
        @Tag(value="template")
        private boolean myIsTemplate;

        public int getPort() {
            return this.myPort;
        }

        public void setPort(int port) {
            this.myPort = port;
        }

        public int getMBeanPort() {
            return this.myMBeanPort;
        }

        public void setMBeanPort(int mBeanPort) {
            this.myMBeanPort = mBeanPort;
        }

        public String getMBeanUserName() {
            return this.myMBeanUserName;
        }

        public void setMBeanUserName(String mBeanUserName) {
            this.myMBeanUserName = mBeanUserName;
        }

        public String getMBeanPassword() {
            return this.myMBeanPassword;
        }

        public void setMBeanPassword(String mBeanPassword) {
            this.myMBeanPassword = mBeanPassword;
        }

        public String getCredentialAlias() {
            return this.myCredentialAlias;
        }

        public void setCredentialAlias(String credentialAlias) {
            this.myCredentialAlias = credentialAlias;
        }

        public boolean isTemplate() {
            return this.myIsTemplate;
        }

        public void setTemplate(boolean isTemplate) {
            this.myIsTemplate = isTemplate;
        }
    }
}

