/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.dmserver.run;

import com.intellij.dmserver.install.DMServerInstallation;
import com.intellij.dmserver.install.impl.DMServerConfigSupport2Base;
import com.intellij.dmserver.integration.DMServerIntegration;
import com.intellij.dmserver.integration.DMServerRepositoryItem;
import com.intellij.dmserver.integration.DMServerRepositoryWatchedItem;
import com.intellij.dmserver.integration.RepositoryPattern;
import com.intellij.dmserver.run.DMLocalRunConfigurationEditor;
import com.intellij.dmserver.run.DMServerModelBase;
import com.intellij.execution.configurations.RuntimeConfigurationError;
import com.intellij.execution.configurations.RuntimeConfigurationException;
import com.intellij.javaee.run.configuration.CommonModel;
import com.intellij.openapi.application.WriteAction;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.options.SettingsEditor;
import com.intellij.openapi.util.InvalidDataException;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.WriteExternalException;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.xmlb.SerializationFilter;
import com.intellij.util.xmlb.SkipDefaultValuesSerializationFilters;
import com.intellij.util.xmlb.XmlSerializer;
import com.intellij.util.xmlb.annotations.Tag;
import java.io.File;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Collections;
import java.util.List;
import org.jdom.Element;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class DMServerModel
extends DMServerModelBase {
    private static final Logger LOG = Logger.getInstance(DMServerModel.class);
    private String myTargetRepositoryFolder;

    @Override
    public boolean addToRepository(List<VirtualFile> filesToDeploy) {
        VirtualFile repositoryFolder = this.getRepositoryFolder();
        if (repositoryFolder == null) {
            return false;
        }
        try {
            WriteAction.run(() -> this.doAddToRepository(filesToDeploy, repositoryFolder));
            return true;
        }
        catch (IOException e) {
            LOG.error((Throwable)e);
            return false;
        }
    }

    @Nullable
    private VirtualFile getRepositoryFolder() {
        Pair<DMServerRepositoryWatchedItem, RepositoryPattern> repositoryTarget = this.getRepositoryTarget();
        return repositoryTarget == null ? null : ((RepositoryPattern)repositoryTarget.getSecond()).findBaseDir();
    }

    @Nullable
    private Pair<DMServerRepositoryWatchedItem, RepositoryPattern> getRepositoryTarget() {
        if (this.myTargetRepositoryFolder == null) {
            return null;
        }
        DMServerInstallation serverInstallation = this.getServerInstallation();
        if (serverInstallation == null) {
            return null;
        }
        for (RepositoryPattern repositoryPattern : serverInstallation.collectRepositoryPatterns()) {
            DMServerRepositoryItem repositoryItem = repositoryPattern.getSource();
            if (!(repositoryItem instanceof DMServerRepositoryWatchedItem) || !this.myTargetRepositoryFolder.equals(repositoryItem.getPath())) continue;
            return Pair.create((Object)((DMServerRepositoryWatchedItem)repositoryItem), (Object)repositoryPattern);
        }
        return null;
    }

    private void doAddToRepository(List<VirtualFile> filesToDeploy, VirtualFile repositoryFolder) throws IOException {
        for (VirtualFile fileToDeploy : filesToDeploy) {
            fileToDeploy.copy((Object)this, repositoryFolder, fileToDeploy.getName());
        }
    }

    @Override
    public boolean removeFromRepository(List<VirtualFile> filesToUndeploy) {
        VirtualFile repositoryFolder = this.getRepositoryFolder();
        if (repositoryFolder == null) {
            return false;
        }
        try {
            WriteAction.run(() -> this.doRemoveFromRepository(filesToUndeploy, repositoryFolder));
            return true;
        }
        catch (IOException e) {
            LOG.error((Throwable)e);
            return false;
        }
    }

    private void doRemoveFromRepository(List<VirtualFile> filesToUndeploy, VirtualFile repositoryFolder) throws IOException {
        repositoryFolder.refresh(false, false);
        for (VirtualFile fileToUndeploy : filesToUndeploy) {
            VirtualFile repositoryFileToUndeploy = repositoryFolder.findChild(fileToUndeploy.getName());
            if (repositoryFileToUndeploy == null) continue;
            repositoryFileToUndeploy.delete((Object)this);
        }
    }

    @Override
    @Nullable
    public String getRepositoryName() {
        Pair<DMServerRepositoryWatchedItem, RepositoryPattern> repositoryTarget = this.getRepositoryTarget();
        return repositoryTarget == null ? null : ((DMServerRepositoryWatchedItem)repositoryTarget.getFirst()).getName();
    }

    public SettingsEditor<CommonModel> getEditor() {
        return new DMLocalRunConfigurationEditor(this.getCommonModel().getProject(), this);
    }

    public List<Pair<String, Integer>> getAddressesToCheck() {
        return Collections.singletonList(Pair.create((Object)this.getCommonModel().getHost(), (Object)this.getLocalPort()));
    }

    protected void read(@NotNull Element element, boolean isPersistent) throws InvalidDataException {
        if (element == null) {
            DMServerModel.$$$reportNull$$$0(0);
        }
        DMServerModelSettings settings = new DMServerModelSettings();
        XmlSerializer.deserializeInto((Object)settings, (Element)element);
        this.readFromSettingsBase(settings, isPersistent);
        this.myTargetRepositoryFolder = settings.getTargetRepositoryFolder();
    }

    protected void write(@NotNull Element element, boolean isPersistent) throws WriteExternalException {
        if (element == null) {
            DMServerModel.$$$reportNull$$$0(1);
        }
        DMServerModelSettings settings = new DMServerModelSettings();
        this.writeToSettingsBase(settings, isPersistent);
        settings.setTargetRepositoryFolder(this.myTargetRepositoryFolder);
        XmlSerializer.serializeInto((Object)settings, (Element)element, (SerializationFilter)new SkipDefaultValuesSerializationFilters());
    }

    @Nullable
    private DMServerInstallation getServerInstallation() {
        return DMServerIntegration.getInstance().getServerInstallation(this.getCommonModel());
    }

    public void checkConfiguration() throws RuntimeConfigurationException {
        DMServerInstallation serverInstallation = this.getServerInstallation();
        if (serverInstallation != null && serverInstallation.getConfigSupport() instanceof DMServerConfigSupport2Base && this.myTargetRepositoryFolder == null) {
            throw new RuntimeConfigurationError("Target repository folder is not configured");
        }
    }

    @Override
    public URL computeServerAccessibleStagingURL(String deploymentSourcePath) throws MalformedURLException {
        return new URL("file://" + new File(deploymentSourcePath).toURI().getRawPath());
    }

    @Override
    public boolean prepareDeploy(VirtualFile fileToDeploy) {
        return true;
    }

    public String getTargetRepositoryFolder() {
        return this.myTargetRepositoryFolder;
    }

    public void setTargetRepositoryFolder(String targetRepositoryFolder) {
        this.myTargetRepositoryFolder = targetRepositoryFolder;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[3];
        objectArray2[0] = "element";
        objectArray2[1] = "com/intellij/dmserver/run/DMServerModel";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "read";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "write";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    public static class DMServerModelSettings
    extends DMServerModelBase.DMServerModelSettingsBase {
        @Tag(value="target-repository")
        private String myTargetRepositoryFolder;

        public String getTargetRepositoryFolder() {
            return this.myTargetRepositoryFolder;
        }

        public void setTargetRepositoryFolder(String targetRepositoryFolder) {
            this.myTargetRepositoryFolder = targetRepositoryFolder;
        }
    }
}

