/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.dmserver.libraries.tree;

import com.intellij.dmserver.editor.AvailableBundlesProvider;
import com.intellij.dmserver.libraries.BundleDefinition;
import com.intellij.dmserver.libraries.BundleWrapper;
import com.intellij.dmserver.libraries.LibraryDefinition;
import com.intellij.dmserver.libraries.ServerLibrariesContext;
import com.intellij.dmserver.libraries.tree.ArtifactFolderElementBase;
import com.intellij.dmserver.libraries.tree.BundleItemElementBase;
import com.intellij.dmserver.libraries.tree.LibraryBundleElement;
import com.intellij.dmserver.libraries.tree.UnparsableLibraryBundleElement;
import com.intellij.ide.projectView.PresentationData;
import com.intellij.ide.util.treeView.AbstractTreeNode;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.osmorc.manifest.lang.psi.Clause;

public class LibraryElement
extends ArtifactFolderElementBase {
    private static final Comparator<BundleDefinition> BY_SYMBOLIC_NAME = (o1, o2) -> {
        String name1 = o1.getSymbolicName();
        String name2 = o2.getSymbolicName();
        return name1.compareTo(name2);
    };
    private final LibraryDefinition myLibraryDefinition;

    public LibraryElement(ServerLibrariesContext context, LibraryDefinition libraryDefinition) {
        super(context, LibraryElement.createKey(libraryDefinition));
        this.myLibraryDefinition = libraryDefinition;
    }

    public LibraryDefinition getLibraryDefinition() {
        return this.myLibraryDefinition;
    }

    @NonNls
    private static String createKey(LibraryDefinition libraryDefinition) {
        return "library::" + libraryDefinition.getLibDefFile().getPath();
    }

    protected void update(@NotNull PresentationData presentation) {
        if (presentation == null) {
            LibraryElement.$$$reportNull$$$0(0);
        }
        presentation.setPresentableText(this.myLibraryDefinition.getSymbolicName() + " (" + this.myLibraryDefinition.getVersion() + ")");
        LibraryElement.updateIcons(presentation);
    }

    @NotNull
    public Collection<? extends AbstractTreeNode> getChildren() {
        ArrayList<BundleItemElementBase> result = new ArrayList<BundleItemElementBase>();
        HashMap<String, BundleWrapper> bundles = new HashMap<String, BundleWrapper>();
        for (BundleWrapper bundle : AvailableBundlesProvider.getInstance(this.getProject()).getAllRepositoryBundles()) {
            bundles.put(LibraryElement.createBundleKey(bundle.getSymbolicName(), bundle.getVersion()), bundle);
        }
        ArrayList<BundleDefinition> bundleDefs = new ArrayList<BundleDefinition>(this.myLibraryDefinition.getBundleDefs());
        Collections.sort(bundleDefs, BY_SYMBOLIC_NAME);
        for (BundleDefinition bundleDef : bundleDefs) {
            BundleWrapper bundle = (BundleWrapper)bundles.get(LibraryElement.createBundleKey(bundleDef.getSymbolicName(), bundleDef.getVersion()));
            boolean missing = bundle == null;
            result.add(new LibraryBundleElement(this.getProject(), bundleDef, missing, missing ? null : bundle.getJarFile()));
        }
        for (Clause clause : this.myLibraryDefinition.getUnparsableClauses()) {
            result.add(new UnparsableLibraryBundleElement(this.getProject(), clause));
        }
        ArrayList<BundleItemElementBase> arrayList = result;
        if (arrayList == null) {
            LibraryElement.$$$reportNull$$$0(1);
        }
        return arrayList;
    }

    private static String createBundleKey(String symbolicName, String version) {
        return symbolicName + "::" + version;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "presentation";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/dmserver/libraries/tree/LibraryElement";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/dmserver/libraries/tree/LibraryElement";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getChildren";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "update";
                break;
            }
            case 1: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

