/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.dmserver.libraries.tree;

import com.intellij.dmserver.libraries.BundleDefinition;
import com.intellij.dmserver.libraries.tree.ExistingBundleElementBase;
import com.intellij.dmserver.util.DmServerBundle;
import com.intellij.ide.projectView.PresentationData;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;

public class LibraryBundleElement
extends ExistingBundleElementBase<String> {
    private final boolean myMissing;

    public LibraryBundleElement(Project project, @NotNull BundleDefinition definition, boolean missing, VirtualFile bundleJar) {
        if (definition == null) {
            LibraryBundleElement.$$$reportNull$$$0(0);
        }
        super(project, LibraryBundleElement.createKey(definition), definition, bundleJar);
        this.myMissing = missing;
    }

    @NonNls
    private static String createKey(@NotNull BundleDefinition definition) {
        if (definition == null) {
            LibraryBundleElement.$$$reportNull$$$0(1);
        }
        return "library-bundle::" + definition.getSymbolicName() + "::" + definition.getVersion();
    }

    protected void update(@NotNull PresentationData presentation) {
        if (presentation == null) {
            LibraryBundleElement.$$$reportNull$$$0(2);
        }
        StringBuilder nameBuilder = new StringBuilder();
        nameBuilder.append(this.getDefinition().getSymbolicName());
        nameBuilder.append(" (");
        nameBuilder.append(this.getDefinition().getVersion());
        nameBuilder.append(")");
        String name = nameBuilder.toString();
        if (this.myMissing) {
            name = DmServerBundle.message("LibraryBundleElement.name.missing", name);
        }
        LibraryBundleElement.updateStyledText(presentation, name, false);
        LibraryBundleElement.updateIcons(presentation);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "definition";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "presentation";
                break;
            }
        }
        objectArray2[1] = "com/intellij/dmserver/libraries/tree/LibraryBundleElement";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "<init>";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "createKey";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "update";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

