/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.dmserver.libraries;

import com.intellij.dmserver.libraries.ServerLibrariesContext;
import com.intellij.dmserver.libraries.ServerLibrariesTreeBuilder;
import com.intellij.dmserver.libraries.obr.DownloadBundlesEditor;
import com.intellij.dmserver.util.DmServerBundle;
import com.intellij.ide.CommonActionsManager;
import com.intellij.ide.TreeExpander;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.ActionGroup;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.ActionToolbar;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.DefaultActionGroup;
import com.intellij.openapi.util.Disposer;
import com.intellij.ui.ScrollPaneFactory;
import com.intellij.ui.components.JBTabbedPane;
import com.intellij.ui.treeStructure.Tree;
import com.intellij.util.ui.tree.TreeUtil;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.GridBagLayout;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JTabbedPane;
import javax.swing.JTree;
import javax.swing.ToolTipManager;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreeModel;
import org.jetbrains.annotations.NonNls;

public class ServerLibrariesUI
extends JPanel
implements Disposable {
    @NonNls
    public static final String PLACE_TOOLBAR = "ServerLibrariesUI#Toolbar";
    private Tree myTree;
    private ServerLibrariesTreeBuilder myBuilder;
    private final TreeExpander myTreeExpander = new TreeExpander(){

        public void expandAll() {
            ServerLibrariesUI.this.myBuilder.expandAll();
        }

        public boolean canExpand() {
            return true;
        }

        public void collapseAll() {
            ServerLibrariesUI.this.myBuilder.collapseAll();
        }

        public boolean canCollapse() {
            return this.canExpand();
        }
    };
    private final ServerLibrariesContext myContext;
    private JTabbedPane myTabbedPane;
    private JPanel myAddPanel;
    private DownloadBundlesEditor mySearchPanel;

    public ServerLibrariesUI(ServerLibrariesContext context) {
        this.myContext = context;
        this.createContent(this);
    }

    private void createContent(JPanel parent) {
        parent.setLayout(new BorderLayout());
        this.myTabbedPane = new JBTabbedPane();
        parent.add(this.myTabbedPane);
        JPanel availablePanel = new JPanel();
        this.createAvailablePanel(availablePanel);
        this.myTabbedPane.addTab(DmServerBundle.message("ServerLibrariesUI.tab.title.available", new Object[0]), availablePanel);
        this.myAddPanel = new JPanel();
        this.createAddPanel(this.myAddPanel);
        this.myTabbedPane.addTab(DmServerBundle.message("ServerLibrariesUI.tab.title.find.install", new Object[0]), this.myAddPanel);
    }

    private void createAddPanel(JPanel parent) {
        parent.setLayout(new BorderLayout());
        this.mySearchPanel = new DownloadBundlesEditor(this.myContext);
        parent.add(this.mySearchPanel.getMainPanel());
    }

    private void createAvailablePanel(JPanel parent) {
        parent.setLayout(new BorderLayout(0, 2));
        DefaultTreeModel model = new DefaultTreeModel(new DefaultMutableTreeNode());
        this.myTree = new Tree((TreeModel)model);
        this.myTree.setRootVisible(false);
        this.myTree.setShowsRootHandles(true);
        this.myBuilder = new ServerLibrariesTreeBuilder(this.myContext, (JTree)this.myTree, model);
        Disposer.register((Disposable)this, (Disposable)this.myBuilder);
        TreeUtil.installActions((JTree)this.myTree);
        this.myTree.expandRow(this.myTree.getRowCount() - 1);
        this.myTree.expandRow(this.myTree.getRowCount() - 1);
        this.myTree.expandRow(1);
        this.myTree.setLineStyleAngled();
        parent.add((Component)this.createToolbarPanel(), "West");
        parent.add((Component)ScrollPaneFactory.createScrollPane((Component)this.myTree), "Center");
        ToolTipManager.sharedInstance().registerComponent((JComponent)this.myTree);
        JPanel buttonsPanel = new JPanel();
        parent.add((Component)buttonsPanel, "East");
        buttonsPanel.setLayout(new GridBagLayout());
    }

    private JPanel createToolbarPanel() {
        DefaultActionGroup group = new DefaultActionGroup();
        AnAction action = CommonActionsManager.getInstance().createExpandAllAction(this.myTreeExpander, (JComponent)this);
        group.add(action);
        action = CommonActionsManager.getInstance().createCollapseAllAction(this.myTreeExpander, (JComponent)this);
        group.add(action);
        ActionToolbar actionToolBar = ActionManager.getInstance().createActionToolbar(PLACE_TOOLBAR, (ActionGroup)group, false);
        JPanel buttonsPanel = new JPanel(new BorderLayout());
        buttonsPanel.add((Component)actionToolBar.getComponent(), "West");
        return buttonsPanel;
    }

    public void initSearch(String packageName) {
        this.myTabbedPane.setSelectedComponent(this.myAddPanel);
        this.mySearchPanel.initSearch(packageName);
    }

    public void dispose() {
    }
}

