/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.dmserver.artifacts;

import com.intellij.ProjectTopics;
import com.intellij.dmserver.artifacts.WithModuleArtifactUtil;
import com.intellij.dmserver.facet.DMFacetBase;
import com.intellij.dmserver.facet.DMFacetFinder;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.WriteAction;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.ModuleListener;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ModuleRootEvent;
import com.intellij.openapi.roots.ModuleRootListener;
import com.intellij.packaging.artifacts.Artifact;
import com.intellij.packaging.artifacts.ArtifactManager;
import com.intellij.packaging.artifacts.ModifiableArtifactModel;
import com.intellij.util.messages.MessageBus;
import com.intellij.util.messages.MessageBusConnection;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public class ArtifactSynchronizer
implements ModuleRootListener,
ModuleListener {
    private ModifiableArtifactModel myArtifactRemovingModel = null;

    public ArtifactSynchronizer(Project project, MessageBus messageBus) {
        MessageBusConnection connection = messageBus.connect((Disposable)project);
        connection.subscribe(ProjectTopics.MODULES, (Object)this);
        connection.subscribe(ProjectTopics.PROJECT_ROOTS, (Object)this);
    }

    public void beforeModuleRemoved(@NotNull Project project, @NotNull Module module) {
        List<Artifact> artifactsForModule;
        DMFacetBase facet;
        if (project == null) {
            ArtifactSynchronizer.$$$reportNull$$$0(0);
        }
        if (module == null) {
            ArtifactSynchronizer.$$$reportNull$$$0(1);
        }
        if ((facet = (DMFacetBase)((Object)DMFacetFinder.getInstance().processModule(module))) != null && !(artifactsForModule = WithModuleArtifactUtil.findWithModuleArtifactsFor(module)).isEmpty()) {
            ArtifactManager artifactManager = ArtifactManager.getInstance((Project)project);
            if (this.myArtifactRemovingModel == null) {
                this.myArtifactRemovingModel = artifactManager.createModifiableModel();
            }
            for (Artifact nextToRemove : artifactsForModule) {
                this.myArtifactRemovingModel.removeArtifact(nextToRemove);
            }
        }
    }

    public void rootsChanged(@NotNull ModuleRootEvent event) {
        if (event == null) {
            ArtifactSynchronizer.$$$reportNull$$$0(2);
        }
        if (this.myArtifactRemovingModel != null) {
            WriteAction.run(() -> {
                this.myArtifactRemovingModel.commit();
                this.myArtifactRemovingModel.dispose();
            });
            this.myArtifactRemovingModel = null;
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "module";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "event";
                break;
            }
        }
        objectArray2[1] = "com/intellij/dmserver/artifacts/ArtifactSynchronizer";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "beforeModuleRemoved";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "rootsChanged";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

