/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.coldFusion.model.parsers;

import com.intellij.coldFusion.CfmlBundle;
import com.intellij.coldFusion.model.CfmlUtil;
import com.intellij.coldFusion.model.lexer.CfmlTokenTypes;
import com.intellij.coldFusion.model.lexer.CfscriptTokenTypes;
import com.intellij.coldFusion.model.parsers.CfmlElementTypes;
import com.intellij.coldFusion.model.parsers.CfmlExpressionParser;
import com.intellij.coldFusion.model.parsers.CfmlKeywordsKt;
import com.intellij.coldFusion.model.parsers.CfmlParser;
import com.intellij.coldFusion.model.psi.stubs.CfmlStubElementTypes;
import com.intellij.lang.PsiBuilder;
import com.intellij.psi.tree.IElementType;
import java.util.Objects;

public class CfscriptParser {
    private static void parseExpression(PsiBuilder myBuilder) {
        new CfmlExpressionParser(myBuilder).parseExpression();
    }

    private static void parseRValue(PsiBuilder myBuilder) {
        new CfmlExpressionParser(myBuilder).parseRValue();
    }

    private static boolean parseOptionalIDAndTags_PropertyUtil(PsiBuilder myBuilder) {
        PsiBuilder.Marker propertyBodyMarker = myBuilder.mark();
        if (myBuilder.getTokenType() == CfscriptTokenTypes.IDENTIFIER) {
            myBuilder.advanceLexer();
            if (myBuilder.getTokenType() == CfmlTokenTypes.ASSIGN) {
                propertyBodyMarker.rollbackTo();
                CfmlParser.parseAttributes(myBuilder, "cfproperty", CfscriptTokenTypes.IDENTIFIER, true);
                return true;
            }
            if (myBuilder.getTokenType() == CfscriptTokenTypes.IDENTIFIER) {
                PsiBuilder.Marker attributesMarker = myBuilder.mark();
                myBuilder.advanceLexer();
                if (myBuilder.getTokenType() == CfmlTokenTypes.ASSIGN) {
                    attributesMarker.rollbackTo();
                    propertyBodyMarker.drop();
                    CfmlParser.parseAttributes(myBuilder, "cfproperty", CfscriptTokenTypes.IDENTIFIER, true);
                    return true;
                }
                attributesMarker.drop();
                propertyBodyMarker.rollbackTo();
                return false;
            }
            if (myBuilder.getTokenType() == CfscriptTokenTypes.POINT) {
                if (!CfscriptParser.parseType(myBuilder) || myBuilder.getTokenType() != CfscriptTokenTypes.IDENTIFIER) {
                    propertyBodyMarker.rollbackTo();
                    return false;
                }
            } else if (myBuilder.getTokenType() == CfscriptTokenTypes.SEMICOLON) {
                propertyBodyMarker.drop();
                return true;
            }
        }
        propertyBodyMarker.drop();
        return false;
    }

    private boolean parseProperty(PsiBuilder myBuilder) {
        assert (myBuilder.getTokenType() == CfscriptTokenTypes.IDENTIFIER);
        PsiBuilder.Marker propertyMarker = myBuilder.mark();
        myBuilder.advanceLexer();
        if (!CfscriptParser.parseOptionalIDAndTags_PropertyUtil(myBuilder)) {
            if (!CfscriptParser.parseType(myBuilder)) {
                propertyMarker.drop();
                return false;
            }
            if (!CfscriptParser.parseOptionalIDAndTags_PropertyUtil(myBuilder)) {
                propertyMarker.drop();
                return false;
            }
            propertyMarker.done(CfmlElementTypes.PROPERTY);
            return true;
        }
        propertyMarker.done(CfmlElementTypes.PROPERTY);
        return true;
    }

    private void parseAction(PsiBuilder myBuilder) {
        assert (myBuilder.getTokenType() == CfscriptTokenTypes.IDENTIFIER);
        String actionName = myBuilder.getTokenText();
        PsiBuilder.Marker actionMarker = myBuilder.mark();
        myBuilder.remapCurrentToken(CfscriptTokenTypes.ACTION_NAME);
        myBuilder.advanceLexer();
        if (myBuilder.getTokenType() == CfmlTokenTypes.ASSIGN) {
            actionMarker.rollbackTo();
            myBuilder.remapCurrentToken(CfscriptTokenTypes.IDENTIFIER);
            new CfmlExpressionParser(myBuilder).parseStatement();
            CfscriptParser.eatSemicolon(myBuilder);
        } else {
            CfmlParser.parseAttributes(myBuilder, "cfproperty", CfscriptTokenTypes.IDENTIFIER, true);
            if ("param".equalsIgnoreCase(actionName)) {
                CfscriptParser.eatSemicolon(myBuilder);
            } else if (actionName == null || !CfmlKeywordsKt.isKeyword(actionName) || !Objects.requireNonNull(CfmlKeywordsKt.parseKeyword(actionName)).getOmitCodeBlock() || myBuilder.getTokenType() != CfscriptTokenTypes.SEMICOLON) {
                this.parseFunctionBody(myBuilder);
            }
            actionMarker.done(CfmlElementTypes.ACTION);
        }
    }

    private void parseStatement(PsiBuilder myBuilder) {
        if (myBuilder.getTokenType() != CfscriptTokenTypes.IDENTIFIER || !"property".equalsIgnoreCase(myBuilder.getTokenText()) || !this.parseProperty(myBuilder)) {
            new CfmlExpressionParser(myBuilder).parseStatement();
        }
        if (myBuilder.getTokenType() == CfscriptTokenTypes.L_CURLYBRACKET) {
            this.parseScript(myBuilder, false);
        } else {
            CfscriptParser.eatSemicolon(myBuilder);
        }
    }

    private static void parseCondition(PsiBuilder myBuilder) {
        new CfmlExpressionParser(myBuilder).parseExpression();
    }

    private static void parseInclude(PsiBuilder myBuilder) {
        if (myBuilder.getTokenType() != CfscriptTokenTypes.INCLUDE_KEYWORD) {
            return;
        }
        PsiBuilder.Marker marker = myBuilder.mark();
        myBuilder.advanceLexer();
        IElementType tokenType = myBuilder.getTokenType();
        if (tokenType != CfmlTokenTypes.SINGLE_QUOTE && tokenType != CfmlTokenTypes.DOUBLE_QUOTE) {
            marker.drop();
            return;
        }
        new CfmlExpressionParser(myBuilder).parseString();
        marker.done(CfmlElementTypes.INCLUDEEXPRESSION);
    }

    private static void parseImport(PsiBuilder myBuilder) {
        if (myBuilder.getTokenType() != CfscriptTokenTypes.IMPORT_KEYWORD) {
            return;
        }
        PsiBuilder.Marker marker = myBuilder.mark();
        myBuilder.advanceLexer();
        IElementType tokenType = myBuilder.getTokenType();
        if (tokenType == CfmlTokenTypes.SINGLE_QUOTE || tokenType == CfmlTokenTypes.DOUBLE_QUOTE) {
            new CfmlExpressionParser(myBuilder).parseString();
        } else if (tokenType == CfscriptTokenTypes.IDENTIFIER) {
            new CfmlExpressionParser(myBuilder).parseComponentReference();
        }
        marker.done(CfmlElementTypes.IMPORTEXPRESSION);
    }

    private static boolean parseConstant(PsiBuilder myBuilder) {
        IElementType tokenType = myBuilder.getTokenType();
        if (tokenType == CfscriptTokenTypes.INTEGER || tokenType == CfscriptTokenTypes.DOUBLE || tokenType == CfscriptTokenTypes.BOOLEAN) {
            myBuilder.advanceLexer();
            return true;
        }
        if (tokenType == CfmlTokenTypes.SINGLE_QUOTE || tokenType == CfmlTokenTypes.DOUBLE_QUOTE) {
            myBuilder.advanceLexer();
            tokenType = myBuilder.getTokenType();
            if (tokenType != CfmlTokenTypes.SINGLE_QUOTE_CLOSER && tokenType != CfmlTokenTypes.DOUBLE_QUOTE_CLOSER && !myBuilder.eof()) {
                myBuilder.advanceLexer();
            }
            if ((tokenType = myBuilder.getTokenType()) != CfmlTokenTypes.SINGLE_QUOTE_CLOSER && tokenType != CfmlTokenTypes.DOUBLE_QUOTE_CLOSER) {
                myBuilder.error(CfmlBundle.message("cfml.parsing.quote.expected", new Object[0]));
                return true;
            }
            myBuilder.advanceLexer();
            return true;
        }
        return false;
    }

    private boolean parseConditionInBrackets(PsiBuilder myBuilder) {
        if (myBuilder.getTokenType() != CfscriptTokenTypes.L_BRACKET) {
            myBuilder.error(CfmlBundle.message("cfml.parsing.close.bracket.expected", new Object[0]));
            return false;
        }
        myBuilder.advanceLexer();
        CfscriptParser.parseCondition(myBuilder);
        if (myBuilder.getTokenType() != CfscriptTokenTypes.R_BRACKET) {
            myBuilder.error(CfmlBundle.message("cfml.parsing.close.bracket.expected", new Object[0]));
            return true;
        }
        myBuilder.advanceLexer();
        return true;
    }

    private void parseComponentOrInterface(PsiBuilder myBuilder) {
        if (myBuilder.getTokenType() != CfscriptTokenTypes.COMPONENT_KEYWORD && myBuilder.getTokenType() != CfscriptTokenTypes.INTERFACE_KEYWORD) {
            return;
        }
        PsiBuilder.Marker componentMarker = myBuilder.mark();
        boolean isComponent = myBuilder.getTokenType() == CfscriptTokenTypes.COMPONENT_KEYWORD;
        myBuilder.advanceLexer();
        if (myBuilder.getTokenType() == CfscriptTokenTypes.FUNCTION_KEYWORD) {
            componentMarker.rollbackTo();
            this.parseFunctionExpression(myBuilder, false);
            return;
        }
        CfmlParser.parseAttributes(myBuilder, isComponent ? "cfcomponent" : "cfinterface", CfscriptTokenTypes.IDENTIFIER, true);
        if (myBuilder.getTokenType() != CfscriptTokenTypes.L_CURLYBRACKET) {
            myBuilder.error(CfmlBundle.message("cfml.parsing.open.curly.bracket.expected", new Object[0]));
            componentMarker.drop();
            return;
        }
        myBuilder.advanceLexer();
        if (myBuilder.getTokenType() == CfscriptTokenTypes.PAGEENCODING_KEYWORD) {
            myBuilder.advanceLexer();
            IElementType tokenType = myBuilder.getTokenType();
            if (tokenType == CfmlTokenTypes.SINGLE_QUOTE || tokenType == CfmlTokenTypes.DOUBLE_QUOTE) {
                new CfmlExpressionParser(myBuilder).parseString();
                CfscriptParser.eatSemicolon(myBuilder);
            } else {
                myBuilder.error(CfmlBundle.message("cfml.parsing.string.expected", new Object[0]));
            }
        }
        this.parseScript(myBuilder, false, false, true);
        componentMarker.done(CfmlStubElementTypes.COMPONENT_DEFINITION);
    }

    private void parseIfExpression(PsiBuilder myBuilder) {
        if (myBuilder.getTokenType() != CfscriptTokenTypes.IF_KEYWORD) {
            return;
        }
        PsiBuilder.Marker ifExprMarker = myBuilder.mark();
        myBuilder.advanceLexer();
        if (!this.parseConditionInBrackets(myBuilder)) {
            ifExprMarker.drop();
            return;
        }
        this.parseScript(myBuilder, false);
        if (myBuilder.getTokenType() == CfscriptTokenTypes.ELSE_KEYWORD) {
            myBuilder.advanceLexer();
            if (myBuilder.getTokenType() == CfscriptTokenTypes.IF_KEYWORD) {
                this.parseIfExpression(myBuilder);
            } else {
                this.parseScript(myBuilder, false);
            }
        }
        ifExprMarker.done(CfmlElementTypes.IFEXPRESSION);
    }

    private void parseWhileExpression(PsiBuilder myBuilder) {
        if (myBuilder.getTokenType() != CfscriptTokenTypes.WHILE_KEYWORD) {
            return;
        }
        PsiBuilder.Marker whileMarker = myBuilder.mark();
        myBuilder.advanceLexer();
        this.parseConditionInBrackets(myBuilder);
        this.parseScript(myBuilder, false);
        whileMarker.done(CfmlElementTypes.WHILEEXPRESSION);
    }

    private void parseDoWhileExpression(PsiBuilder myBuilder) {
        if (myBuilder.getTokenType() != CfscriptTokenTypes.DO_KEYWORD) {
            return;
        }
        PsiBuilder.Marker doWhileMarker = myBuilder.mark();
        myBuilder.advanceLexer();
        if (myBuilder.getTokenType() != CfscriptTokenTypes.L_CURLYBRACKET) {
            myBuilder.error(CfmlBundle.message("cfml.parsing.open.bracket.expected", new Object[0]));
            doWhileMarker.drop();
            return;
        }
        this.parseScript(myBuilder, false);
        if (myBuilder.getTokenType() != CfscriptTokenTypes.WHILE_KEYWORD) {
            myBuilder.error(CfmlBundle.message("cfml.parsing.keyword.expected", "while"));
            doWhileMarker.done(CfmlElementTypes.DOWHILEEXPRESSION);
            return;
        }
        myBuilder.advanceLexer();
        this.parseConditionInBrackets(myBuilder);
        if (myBuilder.getTokenType() != CfscriptTokenTypes.SEMICOLON) {
            myBuilder.error(CfmlBundle.message("cfml.parsing.semicolon.expected", new Object[0]));
        } else {
            myBuilder.advanceLexer();
        }
        doWhileMarker.done(CfmlElementTypes.DOWHILEEXPRESSION);
    }

    private static void eatSemicolon(PsiBuilder myBuilder) {
        if (myBuilder.getTokenType() != CfscriptTokenTypes.SEMICOLON) {
            myBuilder.error(CfmlBundle.message("cfml.parsing.semicolon.expected", new Object[0]));
        } else {
            myBuilder.advanceLexer();
        }
    }

    private void parseForExpression(PsiBuilder myBuilder) {
        if (myBuilder.getTokenType() != CfscriptTokenTypes.FOR_KEYWORD) {
            return;
        }
        PsiBuilder.Marker forExpressionMarker = myBuilder.mark();
        myBuilder.advanceLexer();
        if (myBuilder.getTokenType() != CfscriptTokenTypes.L_BRACKET) {
            myBuilder.error(CfmlBundle.message("cfml.parsing.close.bracket.expected", new Object[0]));
            forExpressionMarker.drop();
            return;
        }
        myBuilder.advanceLexer();
        if (!CfscriptParser.tryParseForIn(myBuilder)) {
            this.parseStatement(myBuilder);
            CfscriptParser.parseCondition(myBuilder);
            CfscriptParser.eatSemicolon(myBuilder);
            new CfmlExpressionParser(myBuilder).parseStatement();
        }
        if (myBuilder.getTokenType() != CfscriptTokenTypes.R_BRACKET) {
            myBuilder.error(CfmlBundle.message("cfml.parsing.close.bracket.expected", new Object[0]));
            forExpressionMarker.done(CfmlElementTypes.FOREXPRESSION);
            return;
        }
        myBuilder.advanceLexer();
        this.parseScript(myBuilder, false);
        forExpressionMarker.done(CfmlElementTypes.FOREXPRESSION);
    }

    private static boolean tryParseForIn(PsiBuilder myBuilder) {
        PsiBuilder.Marker startMarker = myBuilder.mark();
        if (myBuilder.getTokenType() == CfscriptTokenTypes.VAR_KEYWORD) {
            myBuilder.advanceLexer();
        }
        PsiBuilder.Marker definitionMarker = myBuilder.mark();
        if (!new CfmlExpressionParser(myBuilder).parseReference(false)) {
            startMarker.rollbackTo();
            return false;
        }
        definitionMarker.done(CfmlElementTypes.FORVARIABLE);
        if (myBuilder.getTokenType() != CfscriptTokenTypes.IN_L) {
            startMarker.rollbackTo();
            return false;
        }
        myBuilder.advanceLexer();
        if (!new CfmlExpressionParser(myBuilder).parseReference(false)) {
            new CfmlExpressionParser(myBuilder).parseArrayDefinition();
        }
        startMarker.drop();
        return true;
    }

    private void parseFunctionBody(PsiBuilder myBuilder) {
        PsiBuilder.Marker functionBodyMarker = myBuilder.mark();
        if (myBuilder.getTokenType() != CfscriptTokenTypes.L_CURLYBRACKET) {
            myBuilder.error(CfmlBundle.message("cfml.parsing.open.curly.bracket.or.semicolon.expected", new Object[0]));
            functionBodyMarker.drop();
            return;
        }
        this.parseScript(myBuilder, false);
        functionBodyMarker.done(CfmlElementTypes.FUNCTIONBODY);
    }

    private void parseParametersList(PsiBuilder myBuilder) {
        PsiBuilder.Marker argumentMarker = myBuilder.mark();
        if (myBuilder.getTokenType() == CfscriptTokenTypes.REQUIRED_KEYWORD) {
            myBuilder.advanceLexer();
        }
        PsiBuilder.Marker marker = myBuilder.mark();
        if (!CfscriptParser.parseType(myBuilder) || myBuilder.getTokenType() != CfscriptTokenTypes.IDENTIFIER) {
            marker.rollbackTo();
        } else {
            marker.drop();
        }
        if (myBuilder.getTokenType() == CfscriptTokenTypes.IDENTIFIER) {
            myBuilder.advanceLexer();
            if (myBuilder.getTokenType() == CfmlTokenTypes.ASSIGN) {
                myBuilder.advanceLexer();
                PsiBuilder.Marker defaultValueMarker = myBuilder.mark();
                if (!CfscriptParser.parseConstant(myBuilder)) {
                    CfscriptParser.parseRValue(myBuilder);
                }
                defaultValueMarker.done(CfmlElementTypes.VALUE);
            }
            if (myBuilder.getTokenType() == CfscriptTokenTypes.IDENTIFIER) {
                CfmlParser.parseAttributes(myBuilder, "cfparameter", CfscriptTokenTypes.IDENTIFIER, true);
            }
            argumentMarker.done(CfmlElementTypes.FUNCTION_ARGUMENT);
            if (myBuilder.getTokenType() == CfscriptTokenTypes.COMMA) {
                myBuilder.advanceLexer();
                this.parseParametersList(myBuilder);
            }
        } else {
            argumentMarker.drop();
        }
    }

    private void parseParametersListInBrackets(PsiBuilder myBuilder) {
        PsiBuilder.Marker argumentsList = myBuilder.mark();
        CfscriptParser.eatLeftBracket(myBuilder);
        this.parseParametersList(myBuilder);
        CfscriptParser.eatRightBracket(myBuilder);
        argumentsList.done((IElementType)CfmlElementTypes.PARAMETERS_LIST);
    }

    void parseFunctionExpression(PsiBuilder myBuilder, boolean anonymous) {
        PsiBuilder.Marker functionMarker = myBuilder.mark();
        if (!anonymous) {
            if (CfscriptTokenTypes.ACCESS_KEYWORDS.contains(myBuilder.getTokenType())) {
                myBuilder.advanceLexer();
            }
            if (myBuilder.getTokenType() != CfscriptTokenTypes.FUNCTION_KEYWORD) {
                CfscriptParser.parseType(myBuilder);
            }
        }
        if (myBuilder.getTokenType() != CfscriptTokenTypes.FUNCTION_KEYWORD) {
            myBuilder.error(CfmlBundle.message("cfml.parsing.function.expected", new Object[0]));
            functionMarker.drop();
            return;
        }
        myBuilder.advanceLexer();
        if (myBuilder.getTokenType() != CfscriptTokenTypes.IDENTIFIER && myBuilder.getTokenType() != CfscriptTokenTypes.DEFAULT_KEYWORD && !anonymous) {
            myBuilder.error(CfmlBundle.message("cfml.parsing.identifier.expected", new Object[0]));
        } else if (!anonymous) {
            myBuilder.advanceLexer();
        }
        this.parseParametersListInBrackets(myBuilder);
        CfmlParser.parseAttributes(myBuilder, "cffunction", CfscriptTokenTypes.IDENTIFIER, true);
        this.parseFunctionBody(myBuilder);
        functionMarker.done((IElementType)CfmlElementTypes.FUNCTION_DEFINITION);
    }

    private void parseDOTDOTAndScript(PsiBuilder myBuilder) {
        if (myBuilder.getTokenType() != CfscriptTokenTypes.DOTDOT) {
            myBuilder.error(CfmlBundle.message("cfml.parsing.dot.dot.expected", new Object[0]));
        } else {
            myBuilder.advanceLexer();
        }
        if (myBuilder.getTokenType() != CfscriptTokenTypes.L_CURLYBRACKET) {
            if (myBuilder.getTokenType() == CfscriptTokenTypes.CASE_KEYWORD) {
                return;
            }
            int offset = myBuilder.getCurrentOffset();
            while (!myBuilder.eof() && myBuilder.getTokenType() != CfscriptTokenTypes.BREAK_KEYWORD && myBuilder.getTokenType() != CfscriptTokenTypes.DEFAULT_KEYWORD && myBuilder.getTokenType() != CfscriptTokenTypes.CASE_KEYWORD && myBuilder.getTokenType() != CfscriptTokenTypes.R_CURLYBRACKET && !CfscriptParser.isEndOfScript(myBuilder) && this.parseScript(myBuilder, false) && offset != myBuilder.getCurrentOffset()) {
                offset = myBuilder.getCurrentOffset();
            }
            if (myBuilder.getTokenType() == CfscriptTokenTypes.BREAK_KEYWORD) {
                myBuilder.advanceLexer();
                CfscriptParser.eatSemicolon(myBuilder);
            }
        } else {
            this.parseScript(myBuilder, false);
        }
    }

    private void parseCaseExpression(PsiBuilder myBuilder) {
        if (myBuilder.getTokenType() != CfscriptTokenTypes.CASE_KEYWORD) {
            return;
        }
        PsiBuilder.Marker caseExpressionMarker = myBuilder.mark();
        myBuilder.advanceLexer();
        if (!CfscriptParser.parseConstant(myBuilder)) {
            if (myBuilder.getTokenType() == CfscriptTokenTypes.IDENTIFIER) {
                myBuilder.error(CfmlBundle.message("cfml.parsing.constant.expected", new Object[0]));
                myBuilder.advanceLexer();
            } else {
                myBuilder.error(CfmlBundle.message("cfml.parsing.constant.expected", new Object[0]));
            }
        }
        this.parseDOTDOTAndScript(myBuilder);
        caseExpressionMarker.done(CfmlElementTypes.CASEEXPRESSION);
    }

    private void parseSwitchExpression(PsiBuilder myBuilder) {
        PsiBuilder.Marker switchMarker = myBuilder.mark();
        if (myBuilder.getTokenType() != CfscriptTokenTypes.SWITCH_KEYWORD) {
            return;
        }
        myBuilder.advanceLexer();
        if (!CfscriptParser.eatLeftBracket(myBuilder)) {
            switchMarker.drop();
            return;
        }
        CfscriptParser.parseExpression(myBuilder);
        CfscriptParser.eatRightBracket(myBuilder);
        if (myBuilder.getTokenType() != CfscriptTokenTypes.L_CURLYBRACKET) {
            myBuilder.error(CfmlBundle.message("cfml.parsing.open.curly.bracket.expected", new Object[0]));
            switchMarker.drop();
            return;
        }
        myBuilder.advanceLexer();
        while (myBuilder.getTokenType() == CfscriptTokenTypes.CASE_KEYWORD) {
            this.parseCaseExpression(myBuilder);
        }
        if (myBuilder.getTokenType() == CfscriptTokenTypes.DEFAULT_KEYWORD) {
            PsiBuilder.Marker caseExpressionMarker = myBuilder.mark();
            myBuilder.advanceLexer();
            this.parseDOTDOTAndScript(myBuilder);
            caseExpressionMarker.done(CfmlElementTypes.CASEEXPRESSION);
        }
        while (myBuilder.getTokenType() == CfscriptTokenTypes.CASE_KEYWORD) {
            this.parseCaseExpression(myBuilder);
        }
        if (myBuilder.getTokenType() != CfscriptTokenTypes.R_CURLYBRACKET) {
            myBuilder.error(CfmlBundle.message("cfml.parsing.close.curly.bracket.expected", new Object[0]));
        } else {
            myBuilder.advanceLexer();
        }
        switchMarker.done(CfmlElementTypes.SWITCHEXPRESSION);
    }

    private static boolean eatLeftBracket(PsiBuilder myBuilder) {
        if (myBuilder.getTokenType() != CfscriptTokenTypes.L_BRACKET) {
            myBuilder.error(CfmlBundle.message("cfml.parsing.open.bracket.expected", new Object[0]));
            return false;
        }
        myBuilder.advanceLexer();
        return true;
    }

    private static void eatRightBracket(PsiBuilder myBuilder) {
        if (myBuilder.getTokenType() != CfscriptTokenTypes.R_BRACKET) {
            myBuilder.error(CfmlBundle.message("cfml.parsing.close.bracket.expected", new Object[0]));
            return;
        }
        myBuilder.advanceLexer();
    }

    private static boolean parseType(PsiBuilder myBuilder) {
        if (CfscriptTokenTypes.TYPE_KEYWORDS.contains(myBuilder.getTokenType())) {
            PsiBuilder.Marker typeMarker = myBuilder.mark();
            myBuilder.advanceLexer();
            typeMarker.done(CfmlElementTypes.TYPE);
        } else {
            if (myBuilder.getTokenType() != CfscriptTokenTypes.IDENTIFIER) {
                myBuilder.error(CfmlBundle.message("cfml.parsing.type.expected", new Object[0]));
                return false;
            }
            PsiBuilder.Marker typeMarker = myBuilder.mark();
            myBuilder.advanceLexer();
            while (myBuilder.getTokenType() == CfscriptTokenTypes.POINT) {
                myBuilder.advanceLexer();
                if (myBuilder.getTokenType() != CfscriptTokenTypes.IDENTIFIER) {
                    myBuilder.error(CfmlBundle.message("cfml.parsing.type.expected", new Object[0]));
                    typeMarker.done(CfmlElementTypes.TYPE);
                    return true;
                }
                myBuilder.advanceLexer();
            }
            typeMarker.done(CfmlElementTypes.TYPE);
        }
        return true;
    }

    private void parseCatchExpression(PsiBuilder myBuilder) {
        if (myBuilder.getTokenType() != CfscriptTokenTypes.CATCH_KEYWORD) {
            return;
        }
        PsiBuilder.Marker catchExpressionMarker = myBuilder.mark();
        myBuilder.advanceLexer();
        if (!CfscriptParser.eatLeftBracket(myBuilder)) {
            catchExpressionMarker.drop();
            return;
        }
        CfscriptParser.parseType(myBuilder);
        if (myBuilder.getTokenType() != CfscriptTokenTypes.IDENTIFIER) {
            myBuilder.error(CfmlBundle.message("cfml.parsing.identifier.expected", new Object[0]));
            catchExpressionMarker.drop();
            return;
        }
        myBuilder.advanceLexer();
        CfscriptParser.eatRightBracket(myBuilder);
        catchExpressionMarker.done(CfmlElementTypes.CATCHEXPRESSION);
        this.parseScript(myBuilder, false);
    }

    private void parseTryCatchExpression(PsiBuilder myBuilder) {
        if (myBuilder.getTokenType() != CfscriptTokenTypes.TRY_KEYWORD) {
            return;
        }
        PsiBuilder.Marker tryCatchMarker = myBuilder.mark();
        myBuilder.advanceLexer();
        this.parseScript(myBuilder, false);
        while (myBuilder.getTokenType() == CfscriptTokenTypes.CATCH_KEYWORD) {
            this.parseCatchExpression(myBuilder);
        }
        if (myBuilder.getTokenType() == CfscriptTokenTypes.FINALLY_KEYWORD) {
            myBuilder.advanceLexer();
            this.parseScript(myBuilder, false);
        }
        tryCatchMarker.done(CfmlElementTypes.TRYCATCHEXPRESSION);
    }

    public boolean parseScript(PsiBuilder myBuilder, boolean betweenScriptTags) {
        return this.parseScript(myBuilder, betweenScriptTags, true, false);
    }

    public boolean parseScript(PsiBuilder myBuilder, boolean betweenScriptTags, boolean createBlockOfStatments, boolean waitForRightBracket) {
        PsiBuilder.Marker blockOfStatements = null;
        if (myBuilder.getTokenType() == CfscriptTokenTypes.L_CURLYBRACKET) {
            waitForRightBracket = true;
            blockOfStatements = myBuilder.mark();
            myBuilder.advanceLexer();
        }
        while (!CfscriptParser.isEndOfScript(myBuilder)) {
            int lexerPosition = myBuilder.getCurrentOffset();
            if (myBuilder.getTokenType() == CfscriptTokenTypes.INCLUDE_KEYWORD) {
                CfscriptParser.parseInclude(myBuilder);
            } else if (myBuilder.getTokenType() == CfscriptTokenTypes.IMPORT_KEYWORD) {
                CfscriptParser.parseImport(myBuilder);
            } else if (myBuilder.getTokenType() == CfscriptTokenTypes.COMPONENT_KEYWORD || myBuilder.getTokenType() == CfscriptTokenTypes.INTERFACE_KEYWORD) {
                this.parseComponentOrInterface(myBuilder);
            } else if (CfscriptTokenTypes.ACCESS_KEYWORDS.contains(myBuilder.getTokenType()) || myBuilder.getTokenType() == CfscriptTokenTypes.FUNCTION_KEYWORD) {
                this.parseFunctionExpression(myBuilder, false);
            } else if (CfscriptTokenTypes.TYPE_KEYWORDS.contains(myBuilder.getTokenType())) {
                if (!this.tryParseStatement(myBuilder)) {
                    this.parseFunctionExpression(myBuilder, false);
                }
            } else if (myBuilder.getTokenType() == CfscriptTokenTypes.VAR_KEYWORD) {
                this.parseStatement(myBuilder);
            } else if (myBuilder.getTokenType() == CfscriptTokenTypes.IF_KEYWORD) {
                this.parseIfExpression(myBuilder);
            } else if (myBuilder.getTokenType() == CfscriptTokenTypes.WHILE_KEYWORD) {
                this.parseWhileExpression(myBuilder);
            } else if (myBuilder.getTokenType() == CfscriptTokenTypes.DO_KEYWORD) {
                this.parseDoWhileExpression(myBuilder);
            } else if (myBuilder.getTokenType() == CfscriptTokenTypes.FOR_KEYWORD) {
                this.parseForExpression(myBuilder);
            } else if (myBuilder.getTokenType() == CfscriptTokenTypes.SWITCH_KEYWORD) {
                this.parseSwitchExpression(myBuilder);
            } else if (myBuilder.getTokenType() == CfscriptTokenTypes.RETHROW_KEYWORD) {
                myBuilder.advanceLexer();
                CfscriptParser.eatSemicolon(myBuilder);
            } else if (myBuilder.getTokenType() == CfscriptTokenTypes.RETURN_KEYWORD) {
                CfscriptParser.parseReturnStatement(myBuilder);
            } else if (myBuilder.getTokenType() == CfscriptTokenTypes.BREAK_KEYWORD || myBuilder.getTokenType() == CfscriptTokenTypes.ABORT_KEYWORD) {
                myBuilder.advanceLexer();
                CfscriptParser.eatSemicolon(myBuilder);
            } else if (CfmlUtil.isActionName(myBuilder)) {
                this.parseAction(myBuilder);
            } else if (myBuilder.getTokenType() == CfscriptTokenTypes.L_CURLYBRACKET) {
                this.parseScript(myBuilder, false);
            } else {
                if (myBuilder.getTokenType() == CfscriptTokenTypes.R_CURLYBRACKET) {
                    if (waitForRightBracket) {
                        myBuilder.advanceLexer();
                        if (blockOfStatements != null) {
                            if (createBlockOfStatments) {
                                blockOfStatements.done(CfmlElementTypes.BLOCK_OF_STATEMENTS);
                            } else {
                                blockOfStatements.drop();
                            }
                        }
                        return true;
                    }
                    myBuilder.error(CfmlBundle.message("cfml.parsing.unexpected.token", new Object[0]));
                    myBuilder.advanceLexer();
                    return false;
                }
                if (myBuilder.getTokenType() == CfscriptTokenTypes.TRY_KEYWORD) {
                    this.parseTryCatchExpression(myBuilder);
                } else if (CfscriptTokenTypes.KEYWORDS.contains(myBuilder.getTokenType())) {
                    if (myBuilder.getTokenType() == CfscriptTokenTypes.VAR_KEYWORD || myBuilder.getTokenType() == CfscriptTokenTypes.SCOPE_KEYWORD) {
                        this.parseStatement(myBuilder);
                    } else if (myBuilder.getTokenType() != CfscriptTokenTypes.CONTINUE_KEYWORD && myBuilder.getTokenType() != CfscriptTokenTypes.RETURN_KEYWORD && myBuilder.getTokenType() != CfscriptTokenTypes.BREAK_KEYWORD) {
                        PsiBuilder.Marker errorMarker = myBuilder.mark();
                        myBuilder.advanceLexer();
                        errorMarker.error(CfmlBundle.message("cfml.parsing.unexpected.token", new Object[0]));
                    } else {
                        myBuilder.advanceLexer();
                        CfscriptParser.eatSemicolon(myBuilder);
                    }
                } else {
                    PsiBuilder.Marker marker = myBuilder.mark();
                    if (CfscriptParser.parseType(myBuilder) && myBuilder.getTokenType() == CfscriptTokenTypes.FUNCTION_KEYWORD) {
                        marker.rollbackTo();
                        this.parseFunctionExpression(myBuilder, false);
                    } else {
                        marker.rollbackTo();
                        if (myBuilder.getTokenType() == CfscriptTokenTypes.IDENTIFIER) {
                            PsiBuilder.Marker assignMarker = myBuilder.mark();
                            myBuilder.advanceLexer();
                            if (myBuilder.getTokenType() == CfmlTokenTypes.ASSIGN) {
                                assignMarker.rollbackTo();
                                new CfmlExpressionParser(myBuilder).parseExpression();
                                CfscriptParser.eatSemicolon(myBuilder);
                            } else {
                                assignMarker.rollbackTo();
                                this.parseStatement(myBuilder);
                            }
                        } else {
                            this.parseStatement(myBuilder);
                        }
                    }
                }
            }
            if (!betweenScriptTags && !waitForRightBracket) break;
            if (lexerPosition != myBuilder.getCurrentOffset()) continue;
            myBuilder.error(CfmlBundle.message("cfml.parsing.unexpected.token", new Object[0]));
            myBuilder.advanceLexer();
            if (blockOfStatements != null) {
                blockOfStatements.drop();
            }
            return false;
        }
        if (blockOfStatements != null) {
            blockOfStatements.drop();
        }
        return true;
    }

    private boolean tryParseStatement(PsiBuilder myBuilder) {
        PsiBuilder.Marker referenceMarker = myBuilder.mark();
        myBuilder.advanceLexer();
        if (myBuilder.getTokenType() == CfmlTokenTypes.ASSIGN) {
            referenceMarker.rollbackTo();
            this.parseStatement(myBuilder);
            return true;
        }
        referenceMarker.rollbackTo();
        return false;
    }

    private static void parseReturnStatement(PsiBuilder myBuilder) {
        myBuilder.advanceLexer();
        if (!new CfmlExpressionParser(myBuilder).parseStructureDefinition() && !new CfmlExpressionParser(myBuilder).parseArrayDefinition()) {
            new CfmlExpressionParser(myBuilder).parseExpression();
        }
        CfscriptParser.eatSemicolon(myBuilder);
    }

    private static boolean isEndOfScript(PsiBuilder myBuilder) {
        return myBuilder.getTokenType() == null || myBuilder.getTokenType() == CfmlTokenTypes.OPENER || myBuilder.getTokenType() == CfmlTokenTypes.LSLASH_ANGLEBRACKET;
    }
}

