/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.coldFusion.UI.editorActions.typedHandlers;

import com.intellij.codeInsight.editorActions.TypedHandlerDelegate;
import com.intellij.codeInsight.editorActions.XmlSlashTypedHandler;
import com.intellij.coldFusion.UI.editorActions.matchers.CfmlBraceMatcher;
import com.intellij.coldFusion.UI.editorActions.typedHandlers.DocumentUtils;
import com.intellij.coldFusion.UI.editorActions.utils.CfmlEditorUtil;
import com.intellij.coldFusion.model.CfmlLanguage;
import com.intellij.coldFusion.model.CfmlUtil;
import com.intellij.coldFusion.model.files.CfmlFile;
import com.intellij.coldFusion.model.files.CfmlFileViewProvider;
import com.intellij.coldFusion.model.lexer.CfmlTokenTypes;
import com.intellij.coldFusion.model.psi.CfmlTag;
import com.intellij.coldFusion.model.psi.CfmlTagUtil;
import com.intellij.lang.ASTNode;
import com.intellij.lang.Language;
import com.intellij.lang.xml.XMLLanguage;
import com.intellij.openapi.editor.CaretModel;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.EditorModificationUtil;
import com.intellij.openapi.editor.ex.DocumentEx;
import com.intellij.openapi.editor.ex.EditorEx;
import com.intellij.openapi.editor.highlighter.EditorHighlighter;
import com.intellij.openapi.editor.highlighter.HighlighterIterator;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Comparing;
import com.intellij.psi.FileViewProvider;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiErrorElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.xml.XmlTokenType;
import com.intellij.util.SystemProperties;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000H\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\f\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u0000 \u00192\u00020\u0001:\u0001\u0019B\u0005\u00a2\u0006\u0002\u0010\u0002J0\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000eH\u0016J(\u0010\u000f\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u0010\u001a\u00020\fH\u0016J(\u0010\u0011\u001a\u00020\u00042\u0006\u0010\u000f\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fH\u0016J\u0012\u0010\u0012\u001a\u0004\u0018\u00010\u00132\u0006\u0010\u0014\u001a\u00020\u0015H\u0002J\u0018\u0010\u0016\u001a\u00020\u00042\u0006\u0010\u0017\u001a\u00020\u00182\u0006\u0010\t\u001a\u00020\nH\u0002\u00a8\u0006\u001a"}, d2={"Lcom/intellij/coldFusion/UI/editorActions/typedHandlers/CfmlTypedHandler;", "Lcom/intellij/codeInsight/editorActions/TypedHandlerDelegate;", "()V", "beforeCharTyped", "Lcom/intellij/codeInsight/editorActions/TypedHandlerDelegate$Result;", "c", "", "project", "Lcom/intellij/openapi/project/Project;", "editor", "Lcom/intellij/openapi/editor/Editor;", "file", "Lcom/intellij/psi/PsiFile;", "fileType", "Lcom/intellij/openapi/fileTypes/FileType;", "charTyped", "psiFile", "checkAutoPopup", "findOpeningCfmlTag", "Lcom/intellij/coldFusion/model/psi/CfmlTag;", "cfmlElement", "Lcom/intellij/psi/PsiElement;", "processCloseTag", "provider", "Lcom/intellij/coldFusion/model/files/CfmlFileViewProvider;", "Companion", "intellij.cfml"})
public final class CfmlTypedHandler
extends TypedHandlerDelegate {
    private static final boolean ourEnableDoublePoundInsertion;
    public static final Companion Companion;

    @NotNull
    public TypedHandlerDelegate.Result checkAutoPopup(char charTyped, @NotNull Project project, @NotNull Editor editor, @NotNull PsiFile file) {
        Intrinsics.checkParameterIsNotNull((Object)project, (String)"project");
        Intrinsics.checkParameterIsNotNull((Object)editor, (String)"editor");
        Intrinsics.checkParameterIsNotNull((Object)file, (String)"file");
        PsiFile psiFile = file.getViewProvider().getPsi((Language)CfmlLanguage.INSTANCE);
        if (psiFile == null) {
            return TypedHandlerDelegate.Result.CONTINUE;
        }
        PsiFile cfmlFile = psiFile;
        if (Companion.isNotCfmlFile$intellij_cfml(cfmlFile, editor)) {
            return TypedHandlerDelegate.Result.CONTINUE;
        }
        if (charTyped == '/') {
            CfmlUtil.showCompletion(editor);
        }
        return TypedHandlerDelegate.Result.CONTINUE;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @NotNull
    public TypedHandlerDelegate.Result beforeCharTyped(char c, @NotNull Project project, @NotNull Editor editor, @NotNull PsiFile file, @NotNull FileType fileType) {
        Intrinsics.checkParameterIsNotNull((Object)project, (String)"project");
        Intrinsics.checkParameterIsNotNull((Object)editor, (String)"editor");
        Intrinsics.checkParameterIsNotNull((Object)file, (String)"file");
        Intrinsics.checkParameterIsNotNull((Object)fileType, (String)"fileType");
        PsiFile psiFile = file.getViewProvider().getPsi((Language)CfmlLanguage.INSTANCE);
        if (psiFile == null) {
            return TypedHandlerDelegate.Result.CONTINUE;
        }
        PsiFile cfmlFile = psiFile;
        if (Companion.isNotCfmlFile$intellij_cfml(cfmlFile, editor)) {
            return TypedHandlerDelegate.Result.CONTINUE;
        }
        CaretModel caretModel = editor.getCaretModel();
        Intrinsics.checkExpressionValueIsNotNull((Object)caretModel, (String)"editor.caretModel");
        int offset = caretModel.getOffset();
        switch (c) {
            case '{': {
                CfmlBraceMatcher braceMatcher = new CfmlBraceMatcher();
                HighlighterIterator highlighterIterator = ((EditorEx)editor).getHighlighter().createIterator(offset);
                Intrinsics.checkExpressionValueIsNotNull((Object)highlighterIterator, (String)"(editor as EditorEx).hig\u2026er.createIterator(offset)");
                HighlighterIterator iterator = highlighterIterator;
                DocumentEx documentEx = ((EditorEx)editor).getDocument();
                Intrinsics.checkExpressionValueIsNotNull((Object)documentEx, (String)"editor.document");
                if (braceMatcher.isLBraceToken(iterator, documentEx.getCharsSequence(), fileType)) return TypedHandlerDelegate.Result.CONTINUE;
                EditorModificationUtil.insertStringAtCaret((Editor)editor, (String)"}", (boolean)true, (int)0);
                return TypedHandlerDelegate.Result.CONTINUE;
            }
            case '#': {
                if (!ourEnableDoublePoundInsertion || CfmlEditorUtil.countSharpsBalance(editor) != 0) return TypedHandlerDelegate.Result.CONTINUE;
                char charAtOffset = DocumentUtils.getCharAt(editor.getDocument(), offset);
                if (charAtOffset == '#') {
                    EditorModificationUtil.moveCaretRelatively((Editor)editor, (int)1);
                    return TypedHandlerDelegate.Result.STOP;
                }
                EditorModificationUtil.insertStringAtCaret((Editor)editor, (String)"#", (boolean)true, (int)0);
                return TypedHandlerDelegate.Result.CONTINUE;
            }
            case '>': {
                EditorHighlighter editorHighlighter = ((EditorEx)editor).getHighlighter();
                CaretModel caretModel2 = editor.getCaretModel();
                Intrinsics.checkExpressionValueIsNotNull((Object)caretModel2, (String)"editor.getCaretModel()");
                HighlighterIterator highlighterIterator = editorHighlighter.createIterator(caretModel2.getOffset());
                Intrinsics.checkExpressionValueIsNotNull((Object)highlighterIterator, (String)"(editor as EditorEx).hig\u2026r.getCaretModel().offset)");
                if (highlighterIterator.getTokenType() == CfmlTokenTypes.COMMENT) return TypedHandlerDelegate.Result.CONTINUE;
                EditorHighlighter editorHighlighter2 = ((EditorEx)editor).getHighlighter();
                CaretModel caretModel3 = editor.getCaretModel();
                Intrinsics.checkExpressionValueIsNotNull((Object)caretModel3, (String)"editor.getCaretModel()");
                HighlighterIterator highlighterIterator2 = editorHighlighter2.createIterator(caretModel3.getOffset());
                Intrinsics.checkExpressionValueIsNotNull((Object)highlighterIterator2, (String)"(editor as EditorEx).hig\u2026r.getCaretModel().offset)");
                IElementType iElementType = highlighterIterator2.getTokenType();
                Intrinsics.checkExpressionValueIsNotNull((Object)iElementType, (String)"(editor as EditorEx).hig\u2026Model().offset).tokenType");
                if (iElementType.getLanguage() != CfmlLanguage.INSTANCE) {
                    return TypedHandlerDelegate.Result.CONTINUE;
                }
                Companion.insertCloseTagIfNeeded(editor, cfmlFile, project);
                return TypedHandlerDelegate.Result.STOP;
            }
        }
        return TypedHandlerDelegate.Result.CONTINUE;
    }

    @NotNull
    public TypedHandlerDelegate.Result charTyped(char c, @NotNull Project project, @NotNull Editor editor, @NotNull PsiFile psiFile) {
        TypedHandlerDelegate.Result result;
        Intrinsics.checkParameterIsNotNull((Object)project, (String)"project");
        Intrinsics.checkParameterIsNotNull((Object)editor, (String)"editor");
        Intrinsics.checkParameterIsNotNull((Object)psiFile, (String)"psiFile");
        if (Companion.isNotCfmlFileViewProvider$intellij_cfml(psiFile)) {
            return TypedHandlerDelegate.Result.CONTINUE;
        }
        PsiDocumentManager.getInstance((Project)project).commitAllDocuments();
        PsiFile psiFile2 = PsiDocumentManager.getInstance((Project)project).getPsiFile(editor.getDocument());
        if (psiFile2 == null) {
            return TypedHandlerDelegate.Result.CONTINUE;
        }
        Intrinsics.checkExpressionValueIsNotNull((Object)psiFile2, (String)"PsiDocumentManager.getIn\u2026?: return Result.CONTINUE");
        PsiFile file = psiFile2;
        FileViewProvider fileViewProvider = file.getViewProvider();
        if (fileViewProvider == null) {
            throw new TypeCastException("null cannot be cast to non-null type com.intellij.coldFusion.model.files.CfmlFileViewProvider");
        }
        CfmlFileViewProvider provider = (CfmlFileViewProvider)fileViewProvider;
        switch (c) {
            case '/': {
                result = this.processCloseTag(provider, editor);
                break;
            }
            default: {
                result = TypedHandlerDelegate.Result.CONTINUE;
            }
        }
        return result;
    }

    private final TypedHandlerDelegate.Result processCloseTag(CfmlFileViewProvider provider, Editor editor) {
        CaretModel caretModel = editor.getCaretModel();
        Intrinsics.checkExpressionValueIsNotNull((Object)caretModel, (String)"editor.caretModel");
        int offset = caretModel.getOffset();
        PsiElement psiElement = provider.findElementAt(offset - 1, XMLLanguage.class);
        if (psiElement == null) {
            return TypedHandlerDelegate.Result.CONTINUE;
        }
        Intrinsics.checkExpressionValueIsNotNull((Object)psiElement, (String)"provider.findElementAt(o\u2026?: return Result.CONTINUE");
        PsiElement xmlElement = psiElement;
        if (!(xmlElement.getLanguage() instanceof XMLLanguage)) {
            return TypedHandlerDelegate.Result.CONTINUE;
        }
        ASTNode aSTNode = xmlElement.getNode();
        if (aSTNode == null) {
            return TypedHandlerDelegate.Result.CONTINUE;
        }
        ASTNode prevXmlLeaf = aSTNode;
        if (Intrinsics.areEqual((Object)"</", (Object)prevXmlLeaf.getText()) && prevXmlLeaf.getElementType() == XmlTokenType.XML_END_TAG_START || CfmlTagUtil.INSTANCE.isClosingTag(provider, offset)) {
            PsiElement psiElement2 = provider.findElementAt(offset - 1, CfmlLanguage.class);
            if (psiElement2 == null) {
                return TypedHandlerDelegate.Result.CONTINUE;
            }
            Intrinsics.checkExpressionValueIsNotNull((Object)psiElement2, (String)"provider.findElementAt(o\u2026?: return Result.CONTINUE");
            PsiElement cfmlElement = psiElement2;
            CfmlTag cfmlTag = this.findOpeningCfmlTag(cfmlElement);
            if (cfmlTag == null) {
                return TypedHandlerDelegate.Result.CONTINUE;
            }
            CfmlTag cfmlTag2 = cfmlTag;
            CharSequence charSequence = cfmlTag2.getTagName();
            if (!(charSequence == null || charSequence.length() == 0)) {
                EditorModificationUtil.insertStringAtCaret((Editor)editor, (String)(cfmlTag2.getTagName() + '>'), (boolean)false);
                XmlSlashTypedHandler.autoIndent((Editor)editor);
                return TypedHandlerDelegate.Result.STOP;
            }
        }
        return TypedHandlerDelegate.Result.CONTINUE;
    }

    private final CfmlTag findOpeningCfmlTag(PsiElement cfmlElement) {
        CfmlTag cfmlTag = CfmlTagUtil.INSTANCE.getUnclosedTagFromPrevSiblings(cfmlElement);
        if (cfmlTag == null) {
            cfmlTag = CfmlTagUtil.INSTANCE.getUnclosedParentTag(cfmlElement);
        }
        return cfmlTag;
    }

    static {
        Companion = new Companion(null);
        ourEnableDoublePoundInsertion = SystemProperties.getBooleanProperty((String)"idea.cfml.insert.pair.pound", (boolean)true);
    }

    @Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u001e\u0010\u0007\u001a\u00020\u00042\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\rJ\u001d\u0010\u000e\u001a\u00020\u00042\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\b\u001a\u00020\tH\u0000\u00a2\u0006\u0002\b\u000fJ\u0015\u0010\u0010\u001a\u00020\u00042\u0006\u0010\n\u001a\u00020\u000bH\u0000\u00a2\u0006\u0002\b\u0011R\u0011\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\u0012"}, d2={"Lcom/intellij/coldFusion/UI/editorActions/typedHandlers/CfmlTypedHandler$Companion;", "", "()V", "ourEnableDoublePoundInsertion", "", "getOurEnableDoublePoundInsertion", "()Z", "insertCloseTagIfNeeded", "editor", "Lcom/intellij/openapi/editor/Editor;", "file", "Lcom/intellij/psi/PsiFile;", "project", "Lcom/intellij/openapi/project/Project;", "isNotCfmlFile", "isNotCfmlFile$intellij_cfml", "isNotCfmlFileViewProvider", "isNotCfmlFileViewProvider$intellij_cfml", "intellij.cfml"})
    public static final class Companion {
        public final boolean getOurEnableDoublePoundInsertion() {
            return ourEnableDoublePoundInsertion;
        }

        public final boolean insertCloseTagIfNeeded(@NotNull Editor editor, @NotNull PsiFile file, @NotNull Project project) {
            PsiElement tagElement;
            Intrinsics.checkParameterIsNotNull((Object)editor, (String)"editor");
            Intrinsics.checkParameterIsNotNull((Object)file, (String)"file");
            Intrinsics.checkParameterIsNotNull((Object)project, (String)"project");
            Document document = editor.getDocument();
            Intrinsics.checkExpressionValueIsNotNull((Object)document, (String)"editor.document");
            Document document2 = document;
            PsiDocumentManager documentManager = PsiDocumentManager.getInstance((Project)project);
            CaretModel caretModel = editor.getCaretModel();
            Intrinsics.checkExpressionValueIsNotNull((Object)caretModel, (String)"editor.caretModel");
            int offset = caretModel.getOffset();
            documentManager.commitDocument(document2);
            char charAtOffset = DocumentUtils.getCharAt(document2, offset);
            if (charAtOffset != '>') {
                EditorModificationUtil.insertStringAtCaret((Editor)editor, (String)">", (boolean)true, (int)0);
            }
            EditorModificationUtil.moveCaretRelatively((Editor)editor, (int)1);
            if (DocumentUtils.getCharAt(document2, ++offset - 2) == '/') {
                return false;
            }
            HighlighterIterator highlighterIterator = ((EditorEx)editor).getHighlighter().createIterator(offset - 2);
            Intrinsics.checkExpressionValueIsNotNull((Object)highlighterIterator, (String)"(editor as EditorEx).hig\u2026reateIterator(offset - 2)");
            HighlighterIterator iterator = highlighterIterator;
            while (!iterator.atEnd() && Intrinsics.areEqual((Object)iterator.getTokenType(), (Object)CfmlTokenTypes.CF_TAG_NAME) ^ true) {
                if (CfmlUtil.isControlToken(iterator.getTokenType())) {
                    return false;
                }
                iterator.retreat();
            }
            if (!iterator.atEnd()) {
                iterator.retreat();
                if (!iterator.atEnd() && Intrinsics.areEqual((Object)iterator.getTokenType(), (Object)CfmlTokenTypes.LSLASH_ANGLEBRACKET)) {
                    return false;
                }
                iterator.advance();
            }
            if (iterator.atEnd()) {
                return false;
            }
            String tagName = ((Object)document2.getCharsSequence().subSequence(iterator.getStart(), iterator.getEnd())).toString();
            if (CfmlUtil.isSingleCfmlTag(tagName, project) || CfmlUtil.isUserDefined(tagName)) {
                return false;
            }
            for (tagElement = file.findElementAt(iterator.getStart()); tagElement != null && !(tagElement instanceof CfmlTag); tagElement = tagElement.getParent()) {
            }
            if (tagElement == null) {
                return false;
            }
            boolean doInsertion = false;
            if (tagElement.getLastChild() instanceof PsiErrorElement) {
                doInsertion = true;
            } else {
                HighlighterIterator highlighterIterator2 = ((EditorEx)editor).getHighlighter().createIterator(0);
                Intrinsics.checkExpressionValueIsNotNull((Object)highlighterIterator2, (String)"editor.highlighter.createIterator(0)");
                iterator = highlighterIterator2;
                while (!iterator.atEnd() && iterator.getStart() < offset) {
                    String currentTagName;
                    if (iterator.getTokenType() == CfmlTokenTypes.CF_TAG_NAME && Intrinsics.areEqual((Object)tagName, (Object)(currentTagName = ((Object)document2.getCharsSequence().subSequence(iterator.getStart(), iterator.getEnd())).toString()))) {
                        PsiElement currentTagElement = file.findElementAt(iterator.getStart());
                        PsiElement psiElement = currentTagElement = PsiTreeUtil.getParentOfType((PsiElement)currentTagElement, CfmlTag.class);
                        if (psiElement == null) {
                            Intrinsics.throwNpe();
                        }
                        if (psiElement.getLastChild() instanceof PsiErrorElement) {
                            doInsertion = true;
                            break;
                        }
                    }
                    iterator.advance();
                }
            }
            String tagNameFromPsi = ((CfmlTag)tagElement).getTagName();
            if (doInsertion && CfmlUtil.isEndTagRequired(tagNameFromPsi, project)) {
                if (!Comparing.equal((String)tagNameFromPsi, (String)tagName, (boolean)false)) {
                    String string = tagNameFromPsi;
                    Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"tagNameFromPsi");
                    tagName = string;
                }
                EditorModificationUtil.insertStringAtCaret((Editor)editor, (String)("</" + tagName + '>'), (boolean)true, (int)0);
                return true;
            }
            return false;
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public final boolean isNotCfmlFile$intellij_cfml(@NotNull PsiFile file, @NotNull Editor editor) {
            Intrinsics.checkParameterIsNotNull((Object)file, (String)"file");
            Intrinsics.checkParameterIsNotNull((Object)editor, (String)"editor");
            if (!(file instanceof CfmlFile)) return true;
            CaretModel caretModel = editor.getCaretModel();
            Intrinsics.checkExpressionValueIsNotNull((Object)caretModel, (String)"editor.caretModel");
            if (caretModel.getOffset() != 0) return false;
            return true;
        }

        public final boolean isNotCfmlFileViewProvider$intellij_cfml(@NotNull PsiFile file) {
            Intrinsics.checkParameterIsNotNull((Object)file, (String)"file");
            return !(file.getViewProvider() instanceof CfmlFileViewProvider);
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

