/*
 * Decompiled with CFR 0.152.
 */
package com.android.ide.common.symbols;

import com.android.ide.common.res2.MergingException;
import com.android.ide.common.res2.ValueResourceNameValidator;
import com.android.ide.common.symbols.SymbolJavaType;
import com.android.resources.ResourceAccessibility;
import com.android.resources.ResourceType;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.JvmField;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 9}, bv={1, 0, 2}, k=1, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0007\b'\u0018\u0000 \u00192\u00020\u0001:\u0002\u0019\u001aB\u0007\b\u0004\u00a2\u0006\u0002\u0010\u0002R\u0018\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0006\u0010\u0007R\u0012\u0010\b\u001a\u00020\tX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\n\u0010\u000bR\u0012\u0010\f\u001a\u00020\u0005X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\r\u0010\u000eR\u0012\u0010\u000f\u001a\u00020\u0010X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0011\u0010\u0012R\u0012\u0010\u0013\u001a\u00020\u0014X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0015\u0010\u0016R\u0012\u0010\u0017\u001a\u00020\u0005X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0018\u0010\u000e\u00a8\u0006\u001b"}, d2={"Lcom/android/ide/common/symbols/Symbol;", "", "()V", "children", "Lcom/google/common/collect/ImmutableList;", "", "getChildren", "()Lcom/google/common/collect/ImmutableList;", "javaType", "Lcom/android/ide/common/symbols/SymbolJavaType;", "getJavaType", "()Lcom/android/ide/common/symbols/SymbolJavaType;", "name", "getName", "()Ljava/lang/String;", "resourceAccessibility", "Lcom/android/resources/ResourceAccessibility;", "getResourceAccessibility", "()Lcom/android/resources/ResourceAccessibility;", "resourceType", "Lcom/android/resources/ResourceType;", "getResourceType", "()Lcom/android/resources/ResourceType;", "value", "getValue", "Companion", "SymbolImpl", "sdk-common"})
public abstract class Symbol {
    @JvmField
    @NotNull
    public static final ImmutableList<String> NO_CHILDREN;
    public static final Companion Companion;

    @NotNull
    public abstract ResourceAccessibility getResourceAccessibility();

    @NotNull
    public abstract ResourceType getResourceType();

    @NotNull
    public abstract String getValue();

    @NotNull
    public abstract String getName();

    @NotNull
    public abstract SymbolJavaType getJavaType();

    @NotNull
    public abstract ImmutableList<String> getChildren();

    protected Symbol() {
    }

    static {
        Companion = new Companion(null);
        ImmutableList immutableList = ImmutableList.of();
        Intrinsics.checkExpressionValueIsNotNull((Object)immutableList, (String)"ImmutableList.of()");
        NO_CHILDREN = immutableList;
    }

    @JvmStatic
    @NotNull
    public static final Symbol createAndValidateSymbol(@NotNull ResourceType resourceType, @NotNull String name, @NotNull SymbolJavaType javaType, @NotNull String value, @NotNull List<String> children) {
        Intrinsics.checkParameterIsNotNull((Object)resourceType, (String)"resourceType");
        Intrinsics.checkParameterIsNotNull((Object)name, (String)"name");
        Intrinsics.checkParameterIsNotNull((Object)((Object)javaType), (String)"javaType");
        Intrinsics.checkParameterIsNotNull((Object)value, (String)"value");
        Intrinsics.checkParameterIsNotNull(children, (String)"children");
        return Companion.createAndValidateSymbol(resourceType, name, javaType, value, children);
    }

    @JvmStatic
    @NotNull
    public static final Symbol createSymbol(@NotNull ResourceType resourceType, @NotNull String name, @NotNull SymbolJavaType javaType, @NotNull String value, @NotNull List<String> children) {
        Intrinsics.checkParameterIsNotNull((Object)resourceType, (String)"resourceType");
        Intrinsics.checkParameterIsNotNull((Object)name, (String)"name");
        Intrinsics.checkParameterIsNotNull((Object)((Object)javaType), (String)"javaType");
        Intrinsics.checkParameterIsNotNull((Object)value, (String)"value");
        Intrinsics.checkParameterIsNotNull(children, (String)"children");
        return Companion.createSymbol(resourceType, name, javaType, value, children);
    }

    @JvmStatic
    @NotNull
    public static final Symbol createSymbol(@NotNull ResourceAccessibility resourceAccessibility, @NotNull ResourceType resourceType, @NotNull String name, @NotNull SymbolJavaType javaType, @NotNull String value, @NotNull List<String> children) {
        Intrinsics.checkParameterIsNotNull((Object)resourceAccessibility, (String)"resourceAccessibility");
        Intrinsics.checkParameterIsNotNull((Object)resourceType, (String)"resourceType");
        Intrinsics.checkParameterIsNotNull((Object)name, (String)"name");
        Intrinsics.checkParameterIsNotNull((Object)((Object)javaType), (String)"javaType");
        Intrinsics.checkParameterIsNotNull((Object)value, (String)"value");
        Intrinsics.checkParameterIsNotNull(children, (String)"children");
        return Companion.createSymbol(resourceAccessibility, resourceType, name, javaType, value, children);
    }

    @Metadata(mv={1, 1, 9}, bv={1, 0, 2}, k=1, d1={"\u0000@\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0014\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\b\u0082\b\u0018\u00002\u00020\u0001B;\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\u0007\u0012\u0006\u0010\t\u001a\u00020\n\u0012\f\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\u00070\f\u00a2\u0006\u0002\u0010\rJ\t\u0010\u0019\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u001a\u001a\u00020\u0005H\u00c6\u0003J\t\u0010\u001b\u001a\u00020\u0007H\u00c6\u0003J\t\u0010\u001c\u001a\u00020\u0007H\u00c6\u0003J\t\u0010\u001d\u001a\u00020\nH\u00c6\u0003J\u000f\u0010\u001e\u001a\b\u0012\u0004\u0012\u00020\u00070\fH\u00c6\u0003JK\u0010\u001f\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u00052\b\b\u0002\u0010\u0006\u001a\u00020\u00072\b\b\u0002\u0010\b\u001a\u00020\u00072\b\b\u0002\u0010\t\u001a\u00020\n2\u000e\b\u0002\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\u00070\fH\u00c6\u0001J\u0013\u0010 \u001a\u00020!2\b\u0010\"\u001a\u0004\u0018\u00010#H\u00d6\u0003J\t\u0010$\u001a\u00020%H\u00d6\u0001J\t\u0010&\u001a\u00020\u0007H\u00d6\u0001R\u001a\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\u00070\fX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000fR\u0014\u0010\t\u001a\u00020\nX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0011R\u0014\u0010\b\u001a\u00020\u0007X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u0013R\u0014\u0010\u0002\u001a\u00020\u0003X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0014\u0010\u0015R\u0014\u0010\u0004\u001a\u00020\u0005X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0016\u0010\u0017R\u0014\u0010\u0006\u001a\u00020\u0007X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0018\u0010\u0013\u00a8\u0006'"}, d2={"Lcom/android/ide/common/symbols/Symbol$SymbolImpl;", "Lcom/android/ide/common/symbols/Symbol;", "resourceAccessibility", "Lcom/android/resources/ResourceAccessibility;", "resourceType", "Lcom/android/resources/ResourceType;", "value", "", "name", "javaType", "Lcom/android/ide/common/symbols/SymbolJavaType;", "children", "Lcom/google/common/collect/ImmutableList;", "(Lcom/android/resources/ResourceAccessibility;Lcom/android/resources/ResourceType;Ljava/lang/String;Ljava/lang/String;Lcom/android/ide/common/symbols/SymbolJavaType;Lcom/google/common/collect/ImmutableList;)V", "getChildren", "()Lcom/google/common/collect/ImmutableList;", "getJavaType", "()Lcom/android/ide/common/symbols/SymbolJavaType;", "getName", "()Ljava/lang/String;", "getResourceAccessibility", "()Lcom/android/resources/ResourceAccessibility;", "getResourceType", "()Lcom/android/resources/ResourceType;", "getValue", "component1", "component2", "component3", "component4", "component5", "component6", "copy", "equals", "", "other", "", "hashCode", "", "toString", "sdk-common"})
    private static final class SymbolImpl
    extends Symbol {
        @NotNull
        private final ResourceAccessibility resourceAccessibility;
        @NotNull
        private final ResourceType resourceType;
        @NotNull
        private final String value;
        @NotNull
        private final String name;
        @NotNull
        private final SymbolJavaType javaType;
        @NotNull
        private final ImmutableList<String> children;

        @Override
        @NotNull
        public ResourceAccessibility getResourceAccessibility() {
            return this.resourceAccessibility;
        }

        @Override
        @NotNull
        public ResourceType getResourceType() {
            return this.resourceType;
        }

        @Override
        @NotNull
        public String getValue() {
            return this.value;
        }

        @Override
        @NotNull
        public String getName() {
            return this.name;
        }

        @Override
        @NotNull
        public SymbolJavaType getJavaType() {
            return this.javaType;
        }

        @Override
        @NotNull
        public ImmutableList<String> getChildren() {
            return this.children;
        }

        public SymbolImpl(@NotNull ResourceAccessibility resourceAccessibility, @NotNull ResourceType resourceType, @NotNull String value, @NotNull String name, @NotNull SymbolJavaType javaType, @NotNull ImmutableList<String> children) {
            Intrinsics.checkParameterIsNotNull((Object)resourceAccessibility, (String)"resourceAccessibility");
            Intrinsics.checkParameterIsNotNull((Object)resourceType, (String)"resourceType");
            Intrinsics.checkParameterIsNotNull((Object)value, (String)"value");
            Intrinsics.checkParameterIsNotNull((Object)name, (String)"name");
            Intrinsics.checkParameterIsNotNull((Object)((Object)javaType), (String)"javaType");
            Intrinsics.checkParameterIsNotNull(children, (String)"children");
            this.resourceAccessibility = resourceAccessibility;
            this.resourceType = resourceType;
            this.value = value;
            this.name = name;
            this.javaType = javaType;
            this.children = children;
        }

        @NotNull
        public final ResourceAccessibility component1() {
            return this.getResourceAccessibility();
        }

        @NotNull
        public final ResourceType component2() {
            return this.getResourceType();
        }

        @NotNull
        public final String component3() {
            return this.getValue();
        }

        @NotNull
        public final String component4() {
            return this.getName();
        }

        @NotNull
        public final SymbolJavaType component5() {
            return this.getJavaType();
        }

        @NotNull
        public final ImmutableList<String> component6() {
            return this.getChildren();
        }

        @NotNull
        public final SymbolImpl copy(@NotNull ResourceAccessibility resourceAccessibility, @NotNull ResourceType resourceType, @NotNull String value, @NotNull String name, @NotNull SymbolJavaType javaType, @NotNull ImmutableList<String> children) {
            Intrinsics.checkParameterIsNotNull((Object)resourceAccessibility, (String)"resourceAccessibility");
            Intrinsics.checkParameterIsNotNull((Object)resourceType, (String)"resourceType");
            Intrinsics.checkParameterIsNotNull((Object)value, (String)"value");
            Intrinsics.checkParameterIsNotNull((Object)name, (String)"name");
            Intrinsics.checkParameterIsNotNull((Object)((Object)javaType), (String)"javaType");
            Intrinsics.checkParameterIsNotNull(children, (String)"children");
            return new SymbolImpl(resourceAccessibility, resourceType, value, name, javaType, children);
        }

        @NotNull
        public static /* bridge */ /* synthetic */ SymbolImpl copy$default(SymbolImpl symbolImpl, ResourceAccessibility resourceAccessibility, ResourceType resourceType, String string, String string2, SymbolJavaType symbolJavaType, ImmutableList immutableList, int n, Object object) {
            if ((n & 1) != 0) {
                resourceAccessibility = symbolImpl.getResourceAccessibility();
            }
            if ((n & 2) != 0) {
                resourceType = symbolImpl.getResourceType();
            }
            if ((n & 4) != 0) {
                string = symbolImpl.getValue();
            }
            if ((n & 8) != 0) {
                string2 = symbolImpl.getName();
            }
            if ((n & 0x10) != 0) {
                symbolJavaType = symbolImpl.getJavaType();
            }
            if ((n & 0x20) != 0) {
                immutableList = symbolImpl.getChildren();
            }
            return symbolImpl.copy(resourceAccessibility, resourceType, string, string2, symbolJavaType, immutableList);
        }

        public String toString() {
            return "SymbolImpl(resourceAccessibility=" + this.getResourceAccessibility() + ", resourceType=" + this.getResourceType() + ", value=" + this.getValue() + ", name=" + this.getName() + ", javaType=" + (Object)((Object)this.getJavaType()) + ", children=" + this.getChildren() + ")";
        }

        public int hashCode() {
            ResourceAccessibility resourceAccessibility = this.getResourceAccessibility();
            ResourceType resourceType = this.getResourceType();
            String string = this.getValue();
            String string2 = this.getName();
            SymbolJavaType symbolJavaType = this.getJavaType();
            ImmutableList<String> immutableList = this.getChildren();
            return (((((resourceAccessibility != null ? resourceAccessibility.hashCode() : 0) * 31 + (resourceType != null ? resourceType.hashCode() : 0)) * 31 + (string != null ? string.hashCode() : 0)) * 31 + (string2 != null ? string2.hashCode() : 0)) * 31 + (symbolJavaType != null ? ((Object)((Object)symbolJavaType)).hashCode() : 0)) * 31 + (immutableList != null ? immutableList.hashCode() : 0);
        }

        public boolean equals(Object object) {
            block3: {
                block2: {
                    if (this == object) break block2;
                    if (!(object instanceof SymbolImpl)) break block3;
                    SymbolImpl symbolImpl = (SymbolImpl)object;
                    if (!Intrinsics.areEqual((Object)this.getResourceAccessibility(), (Object)symbolImpl.getResourceAccessibility()) || !Intrinsics.areEqual((Object)this.getResourceType(), (Object)symbolImpl.getResourceType()) || !Intrinsics.areEqual((Object)this.getValue(), (Object)symbolImpl.getValue()) || !Intrinsics.areEqual((Object)this.getName(), (Object)symbolImpl.getName()) || !Intrinsics.areEqual((Object)((Object)this.getJavaType()), (Object)((Object)symbolImpl.getJavaType())) || !Intrinsics.areEqual(this.getChildren(), symbolImpl.getChildren())) break block3;
                }
                return true;
            }
            return false;
        }
    }

    @Metadata(mv={1, 1, 9}, bv={1, 0, 2}, k=1, d1={"\u0000@\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J8\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u00052\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u00052\u000e\b\u0002\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u00050\u000fH\u0007J@\u0010\u0010\u001a\u00020\u00072\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u00052\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u00052\u000e\b\u0002\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u00050\u000fH\u0007J8\u0010\u0010\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u00052\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u00052\u000e\b\u0002\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u00050\u000fH\u0007J\u001a\u0010\u0013\u001a\u00020\u00142\b\u0010\n\u001a\u0004\u0018\u00010\u00052\u0006\u0010\b\u001a\u00020\tH\u0002R\u0016\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u00048\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0015"}, d2={"Lcom/android/ide/common/symbols/Symbol$Companion;", "", "()V", "NO_CHILDREN", "Lcom/google/common/collect/ImmutableList;", "", "createAndValidateSymbol", "Lcom/android/ide/common/symbols/Symbol;", "resourceType", "Lcom/android/resources/ResourceType;", "name", "javaType", "Lcom/android/ide/common/symbols/SymbolJavaType;", "value", "children", "", "createSymbol", "resourceAccessibility", "Lcom/android/resources/ResourceAccessibility;", "validateSymbol", "", "sdk-common"})
    public static final class Companion {
        @JvmStatic
        @NotNull
        public final Symbol createAndValidateSymbol(@NotNull ResourceType resourceType, @NotNull String name, @NotNull SymbolJavaType javaType, @NotNull String value, @NotNull List<String> children) {
            Intrinsics.checkParameterIsNotNull((Object)resourceType, (String)"resourceType");
            Intrinsics.checkParameterIsNotNull((Object)name, (String)"name");
            Intrinsics.checkParameterIsNotNull((Object)((Object)javaType), (String)"javaType");
            Intrinsics.checkParameterIsNotNull((Object)value, (String)"value");
            Intrinsics.checkParameterIsNotNull(children, (String)"children");
            this.validateSymbol(name, resourceType);
            return this.createSymbol(resourceType, name, javaType, value, children);
        }

        @JvmStatic
        @NotNull
        public static /* bridge */ /* synthetic */ Symbol createAndValidateSymbol$default(Companion companion, ResourceType resourceType, String string, SymbolJavaType symbolJavaType, String string2, List list, int n, Object object) {
            if ((n & 0x10) != 0) {
                ImmutableList immutableList = ImmutableList.of();
                Intrinsics.checkExpressionValueIsNotNull((Object)immutableList, (String)"ImmutableList.of()");
                list = (List)immutableList;
            }
            return companion.createAndValidateSymbol(resourceType, string, symbolJavaType, string2, list);
        }

        @JvmStatic
        @NotNull
        public final Symbol createSymbol(@NotNull ResourceType resourceType, @NotNull String name, @NotNull SymbolJavaType javaType, @NotNull String value, @NotNull List<String> children) {
            Intrinsics.checkParameterIsNotNull((Object)resourceType, (String)"resourceType");
            Intrinsics.checkParameterIsNotNull((Object)name, (String)"name");
            Intrinsics.checkParameterIsNotNull((Object)((Object)javaType), (String)"javaType");
            Intrinsics.checkParameterIsNotNull((Object)value, (String)"value");
            Intrinsics.checkParameterIsNotNull(children, (String)"children");
            ImmutableList immutableList = ImmutableList.copyOf((Collection)children);
            Intrinsics.checkExpressionValueIsNotNull((Object)immutableList, (String)"ImmutableList.copyOf(children)");
            return new SymbolImpl(ResourceAccessibility.DEFAULT, resourceType, value, name, javaType, (ImmutableList<String>)immutableList);
        }

        @JvmStatic
        @NotNull
        public static /* bridge */ /* synthetic */ Symbol createSymbol$default(Companion companion, ResourceType resourceType, String string, SymbolJavaType symbolJavaType, String string2, List list, int n, Object object) {
            if ((n & 0x10) != 0) {
                ImmutableList immutableList = ImmutableList.of();
                Intrinsics.checkExpressionValueIsNotNull((Object)immutableList, (String)"ImmutableList.of()");
                list = (List)immutableList;
            }
            return companion.createSymbol(resourceType, string, symbolJavaType, string2, list);
        }

        @JvmStatic
        @NotNull
        public final Symbol createSymbol(@NotNull ResourceAccessibility resourceAccessibility, @NotNull ResourceType resourceType, @NotNull String name, @NotNull SymbolJavaType javaType, @NotNull String value, @NotNull List<String> children) {
            Intrinsics.checkParameterIsNotNull((Object)resourceAccessibility, (String)"resourceAccessibility");
            Intrinsics.checkParameterIsNotNull((Object)resourceType, (String)"resourceType");
            Intrinsics.checkParameterIsNotNull((Object)name, (String)"name");
            Intrinsics.checkParameterIsNotNull((Object)((Object)javaType), (String)"javaType");
            Intrinsics.checkParameterIsNotNull((Object)value, (String)"value");
            Intrinsics.checkParameterIsNotNull(children, (String)"children");
            ImmutableList immutableList = ImmutableList.copyOf((Collection)children);
            Intrinsics.checkExpressionValueIsNotNull((Object)immutableList, (String)"ImmutableList.copyOf(children)");
            return new SymbolImpl(resourceAccessibility, resourceType, value, name, javaType, (ImmutableList<String>)immutableList);
        }

        @JvmStatic
        @NotNull
        public static /* bridge */ /* synthetic */ Symbol createSymbol$default(Companion companion, ResourceAccessibility resourceAccessibility, ResourceType resourceType, String string, SymbolJavaType symbolJavaType, String string2, List list, int n, Object object) {
            if ((n & 0x20) != 0) {
                ImmutableList immutableList = ImmutableList.of();
                Intrinsics.checkExpressionValueIsNotNull((Object)immutableList, (String)"ImmutableList.of()");
                list = (List)immutableList;
            }
            return companion.createSymbol(resourceAccessibility, resourceType, string, symbolJavaType, string2, list);
        }

        private final void validateSymbol(String name, ResourceType resourceType) {
            Preconditions.checkArgument((name != null ? 1 : 0) != 0, (String)"Resource name cannot be null", (Object[])new Object[0]);
            String string = name;
            if (string == null) {
                Intrinsics.throwNpe();
            }
            Preconditions.checkArgument((!StringsKt.contains$default((CharSequence)string, (CharSequence)".", (boolean)false, (int)2, null) ? 1 : 0) != 0, (String)("Resource name cannot contain dots: " + name), (Object[])new Object[0]);
            try {
                ValueResourceNameValidator.validate(name, resourceType, null);
            }
            catch (MergingException e) {
                throw (Throwable)new IllegalArgumentException(e);
            }
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

