/*
 * Decompiled with CFR 0.152.
 */
package com.android.ide.common.gradle.model;

import com.android.builder.model.level2.DependencyGraphs;
import com.android.builder.model.level2.GraphItem;
import com.android.ide.common.gradle.model.IdeGraphItem;
import com.android.ide.common.gradle.model.IdeModel;
import com.android.ide.common.gradle.model.ModelCache;
import com.google.common.collect.ImmutableList;
import java.util.Collection;
import java.util.List;
import java.util.Objects;

public final class IdeDependencyGraphs
extends IdeModel
implements DependencyGraphs {
    private static final long serialVersionUID = 1L;
    private final List<GraphItem> myCompileDependencies;
    private final List<GraphItem> myPackageDependencies;
    private final List<String> myProvidedLibraries;
    private final List<String> mySkippedLibraries;
    private final int myHashCode;

    public IdeDependencyGraphs(DependencyGraphs graphs, ModelCache modelCache) {
        super(graphs, modelCache);
        this.myCompileDependencies = IdeDependencyGraphs.copy(graphs.getCompileDependencies(), modelCache, (K item) -> new IdeGraphItem((GraphItem)item, modelCache));
        this.myPackageDependencies = IdeDependencyGraphs.copy(graphs.getPackageDependencies(), modelCache, (K item) -> new IdeGraphItem((GraphItem)item, modelCache));
        this.myProvidedLibraries = ImmutableList.copyOf((Collection)graphs.getProvidedLibraries());
        this.mySkippedLibraries = ImmutableList.copyOf((Collection)graphs.getSkippedLibraries());
        this.myHashCode = this.calculateHashCode();
    }

    public List<GraphItem> getCompileDependencies() {
        return this.myCompileDependencies;
    }

    public List<GraphItem> getPackageDependencies() {
        return this.myPackageDependencies;
    }

    public List<String> getProvidedLibraries() {
        return this.myProvidedLibraries;
    }

    public List<String> getSkippedLibraries() {
        return this.mySkippedLibraries;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof IdeDependencyGraphs)) {
            return false;
        }
        IdeDependencyGraphs graphs = (IdeDependencyGraphs)o;
        return Objects.equals(this.myCompileDependencies, graphs.myCompileDependencies) && Objects.equals(this.myPackageDependencies, graphs.myPackageDependencies) && Objects.equals(this.myProvidedLibraries, graphs.myProvidedLibraries) && Objects.equals(this.mySkippedLibraries, graphs.mySkippedLibraries);
    }

    public int hashCode() {
        return this.myHashCode;
    }

    private int calculateHashCode() {
        return Objects.hash(this.myCompileDependencies, this.myPackageDependencies, this.myProvidedLibraries, this.mySkippedLibraries);
    }

    public String toString() {
        return "IdeDependencyGraphs{myCompileDependencies=" + this.myCompileDependencies + ", myPackageDependencies=" + this.myPackageDependencies + ", myProvidedLibraries=" + this.myProvidedLibraries + ", mySkippedLibraries=" + this.mySkippedLibraries + '}';
    }
}

