/*
 * Decompiled with CFR 0.152.
 */
package com.android.ide.common.blame.parser;

import com.android.ide.common.blame.Message;
import com.android.ide.common.blame.SourceFilePosition;
import com.android.ide.common.blame.parser.ParsingFailedException;
import com.android.ide.common.blame.parser.PatternAwareOutputParser;
import com.android.ide.common.blame.parser.util.OutputLineReader;
import com.android.utils.ILogger;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.List;

public class ToolOutputParser {
    private final List<PatternAwareOutputParser> mParsers;
    private final ILogger mLogger;
    private final Message.Kind mUnparsedMessageKind;

    public ToolOutputParser(Iterable<PatternAwareOutputParser> parsers, ILogger logger) {
        this((ImmutableList<PatternAwareOutputParser>)ImmutableList.copyOf(parsers), Message.Kind.SIMPLE, logger);
    }

    public ToolOutputParser(PatternAwareOutputParser[] parsers, ILogger logger) {
        this((ImmutableList<PatternAwareOutputParser>)ImmutableList.copyOf((Object[])parsers), Message.Kind.SIMPLE, logger);
    }

    public ToolOutputParser(PatternAwareOutputParser parser, ILogger logger) {
        this((ImmutableList<PatternAwareOutputParser>)ImmutableList.of((Object)parser), Message.Kind.SIMPLE, logger);
    }

    public ToolOutputParser(PatternAwareOutputParser parser, Message.Kind unparsedMessageKind, ILogger logger) {
        this((ImmutableList<PatternAwareOutputParser>)ImmutableList.of((Object)parser), unparsedMessageKind, logger);
    }

    private ToolOutputParser(ImmutableList<PatternAwareOutputParser> parsers, Message.Kind unparsedMessageKind, ILogger logger) {
        this.mParsers = parsers;
        this.mUnparsedMessageKind = unparsedMessageKind;
        this.mLogger = logger;
    }

    public List<Message> parseToolOutput(String output) {
        return this.parseToolOutput(output, false);
    }

    public List<Message> parseToolOutput(String output, boolean ignoreUnrecognizedText) {
        String line;
        OutputLineReader outputReader = new OutputLineReader(output);
        if (outputReader.getLineCount() == 0) {
            return Collections.emptyList();
        }
        ArrayList messages = Lists.newArrayList();
        while ((line = outputReader.readLine()) != null) {
            if (line.trim().isEmpty()) continue;
            boolean handled = false;
            for (PatternAwareOutputParser parser : this.mParsers) {
                try {
                    if (!parser.parse(line, outputReader, messages, this.mLogger)) continue;
                    handled = true;
                    break;
                }
                catch (ParsingFailedException e) {
                    return Collections.emptyList();
                }
            }
            if (handled) {
                Message last;
                int messageCount = messages.size();
                if (messageCount <= 0 || !(last = (Message)messages.get(messageCount - 1)).getText().contains("Build cancelled")) continue;
                break;
            }
            if (ignoreUnrecognizedText) continue;
            messages.add(new Message(this.mUnparsedMessageKind, line, SourceFilePosition.UNKNOWN, new SourceFilePosition[0]));
        }
        LinkedHashSet uniqueMessages = new LinkedHashSet(messages);
        return Lists.newArrayList(uniqueMessages);
    }
}

