/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.spring.web.mvc.navigation;

import com.intellij.codeInsight.daemon.GutterIconNavigationHandler;
import com.intellij.codeInsight.daemon.RelatedItemLineMarkerInfo;
import com.intellij.codeInsight.daemon.RelatedItemLineMarkerProvider;
import com.intellij.codeInsight.daemon.impl.PsiElementListNavigator;
import com.intellij.codeInsight.navigation.BackgroundUpdaterTask;
import com.intellij.ide.util.DefaultPsiElementCellRenderer;
import com.intellij.navigation.GotoRelatedItem;
import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.NotNullLazyValue;
import com.intellij.psi.NavigatablePsiElement;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiIdentifier;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiSubstitutor;
import com.intellij.psi.util.PsiFormatUtil;
import com.intellij.spring.gutter.groups.SpringGutterIconBuilder;
import com.intellij.spring.model.utils.SpringCommonUtils;
import com.intellij.spring.web.mvc.SpringControllerClassInfo;
import com.intellij.spring.web.mvc.SpringMvcLibraryUtil;
import com.intellij.spring.web.mvc.model.SpringMVCModel;
import com.intellij.spring.web.mvc.model.SpringMVCModelService;
import com.intellij.spring.web.mvc.views.ViewResolver;
import com.intellij.util.CommonProcessors;
import com.intellij.util.Processor;
import com.intellij.util.containers.ContainerUtil;
import icons.SpringApiIcons;
import java.awt.event.MouseEvent;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import javax.swing.Icon;
import javax.swing.ListCellRenderer;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class SpringMvcRequestMappingRelatedItemLineMarkerProvider
extends RelatedItemLineMarkerProvider {
    public String getId() {
        return "SpringMvcRequestMappingRelatedItemLineMarkerProvider";
    }

    public String getName() {
        return "Related Views";
    }

    @Nullable
    public Icon getIcon() {
        return SpringApiIcons.RequestMapping;
    }

    public void collectNavigationMarkers(@NotNull List<PsiElement> elements, @NotNull Collection<? super RelatedItemLineMarkerInfo> result, boolean forNavigation) {
        PsiElement psiElement;
        if (elements == null) {
            SpringMvcRequestMappingRelatedItemLineMarkerProvider.$$$reportNull$$$0(0);
        }
        if (result == null) {
            SpringMvcRequestMappingRelatedItemLineMarkerProvider.$$$reportNull$$$0(1);
        }
        if ((psiElement = (PsiElement)ContainerUtil.getFirstItem(elements)) == null) {
            return;
        }
        if (!SpringMvcLibraryUtil.isSpringMVCEnabled((Project)psiElement.getProject())) {
            return;
        }
        super.collectNavigationMarkers(elements, result, forNavigation);
    }

    protected void collectNavigationMarkers(final @NotNull PsiElement context, @NotNull Collection<? super RelatedItemLineMarkerInfo> result) {
        if (context == null) {
            SpringMvcRequestMappingRelatedItemLineMarkerProvider.$$$reportNull$$$0(2);
        }
        if (result == null) {
            SpringMvcRequestMappingRelatedItemLineMarkerProvider.$$$reportNull$$$0(3);
        }
        if (!(context instanceof PsiIdentifier)) {
            return;
        }
        PsiElement parent = context.getParent();
        if (!(parent instanceof PsiMethod)) {
            return;
        }
        final PsiMethod method = (PsiMethod)parent;
        if (!SpringControllerClassInfo.isRequestHandlerCandidate(method)) {
            return;
        }
        PsiClass psiClass = method.getContainingClass();
        if (!SpringCommonUtils.isSpringBeanCandidateClass((PsiClass)psiClass)) {
            return;
        }
        SpringControllerClassInfo info = SpringControllerClassInfo.getInfo(psiClass);
        if (!info.isRequestHandler(method)) {
            return;
        }
        final SpringMVCModel model = SpringMVCModelService.getInstance().getModel(context);
        if (model == null) {
            return;
        }
        final Set views = info.getViews(method).keySet();
        if (views.isEmpty()) {
            return;
        }
        CommonProcessors.FindFirstProcessor findFirstProcessor = new CommonProcessors.FindFirstProcessor();
        SpringMvcRequestMappingRelatedItemLineMarkerProvider.processViews(context, model, views, (Processor<PsiFile>)findFirstProcessor);
        if (!findFirstProcessor.isFound()) {
            return;
        }
        final PsiFile firstResult = (PsiFile)findFirstProcessor.getFoundValue();
        GutterIconNavigationHandler<PsiElement> handler = new GutterIconNavigationHandler<PsiElement>(){

            public void navigate(MouseEvent e, PsiElement elt) {
                final String title = "Request Mapping " + PsiFormatUtil.formatMethod((PsiMethod)method, (PsiSubstitutor)PsiSubstitutor.EMPTY, (int)4097, (int)2, (int)0);
                BackgroundUpdaterTask updaterTask = new BackgroundUpdaterTask(context.getProject(), "Searching views for " + title, null){

                    public String getCaption(int size) {
                        String suffix = this.isFinished() ? "" : " so far";
                        return String.format("<html><body>Views for <b>%s</b> (%d found%s)</body></html>", title, size, suffix);
                    }

                    public void run(@NotNull ProgressIndicator indicator) {
                        if (indicator == null) {
                            1.$$$reportNull$$$0(0);
                        }
                        super.run(indicator);
                        SpringMvcRequestMappingRelatedItemLineMarkerProvider.processViews(context, model, views, (Processor<PsiFile>)file -> {
                            if (indicator == null) {
                                1.$$$reportNull$$$0(1);
                            }
                            ProgressManager.checkCanceled();
                            if (((Boolean)ReadAction.compute(() -> !this.updateComponent((PsiElement)file))).booleanValue()) {
                                indicator.cancel();
                            }
                            return true;
                        });
                    }

                    public void onSuccess() {
                        super.onSuccess();
                        PsiElement oneElement = this.getTheOnlyOneElement();
                        if (oneElement instanceof NavigatablePsiElement) {
                            ((NavigatablePsiElement)oneElement).navigate(true);
                            this.myPopup.cancel();
                        }
                    }

                    private static /* synthetic */ void $$$reportNull$$$0(int n) {
                        Object[] objectArray;
                        Object[] objectArray2 = new Object[3];
                        objectArray2[0] = "indicator";
                        objectArray2[1] = "com/intellij/spring/web/mvc/navigation/SpringMvcRequestMappingRelatedItemLineMarkerProvider$1$1";
                        switch (n) {
                            default: {
                                objectArray = objectArray2;
                                objectArray2[2] = "run";
                                break;
                            }
                            case 1: {
                                objectArray = objectArray2;
                                objectArray2[2] = "lambda$run$1";
                                break;
                            }
                        }
                        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
                    }
                };
                PsiElementListNavigator.openTargets((MouseEvent)e, (NavigatablePsiElement[])new NavigatablePsiElement[]{firstResult}, (String)updaterTask.getCaption(1), (String)title, (ListCellRenderer)new DefaultPsiElementCellRenderer(), (BackgroundUpdaterTask)updaterTask);
            }
        };
        SpringGutterIconBuilder.CustomNavigationHandlerBuilder builder = SpringGutterIconBuilder.CustomNavigationHandlerBuilder.createBuilder((Icon)SpringApiIcons.Gutter.RequestMapping, (String)"Related views", (GutterIconNavigationHandler)handler, dom -> GotoRelatedItem.createItems(Collections.singleton(dom), (String)"Spring View"));
        builder.setTargets((NotNullLazyValue)new NotNullLazyValue<Collection<? extends PsiFile>>(){

            @NotNull
            protected Collection<? extends PsiFile> compute() {
                CommonProcessors.CollectProcessor processor2 = new CommonProcessors.CollectProcessor();
                SpringMvcRequestMappingRelatedItemLineMarkerProvider.processViews(context, model, views, (Processor<PsiFile>)((Processor)processor2));
                Collection collection = processor2.getResults();
                if (collection == null) {
                    2.$$$reportNull$$$0(0);
                }
                return collection;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/spring/web/mvc/navigation/SpringMvcRequestMappingRelatedItemLineMarkerProvider$2", "compute"));
            }
        });
        result.add((RelatedItemLineMarkerInfo)builder.createSpringRelatedMergeableLineMarkerInfo(context));
    }

    private static boolean processViews(PsiElement context, SpringMVCModel model, Set<String> views, Processor<PsiFile> processor2) {
        List resolvers = model.getViewResolvers();
        block0: for (String view : views) {
            for (ViewResolver resolver : resolvers) {
                PsiElement psiElement = (PsiElement)ReadAction.compute(() -> resolver.resolveFinalView(context, view, model));
                if (psiElement == null) continue;
                if (processor2.process(ReadAction.compute(() -> psiElement.getContainingFile()))) continue block0;
                return false;
            }
        }
        return true;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[3];
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[0] = "elements";
                break;
            }
            case 1: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[0] = "result";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[0] = "context";
                break;
            }
        }
        objectArray[1] = "com/intellij/spring/web/mvc/navigation/SpringMvcRequestMappingRelatedItemLineMarkerProvider";
        objectArray[2] = "collectNavigationMarkers";
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

