/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.spring.web.mvc.jsp;

import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleUtilCore;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiVariable;
import com.intellij.psi.impl.source.jsp.el.impl.ELElementProcessor;
import com.intellij.psi.impl.source.jsp.el.impl.ElVariablesProvider;
import com.intellij.psi.impl.source.jsp.el.impl.JspElVariablesProvider;
import com.intellij.psi.jsp.el.ELExpressionHolder;
import com.intellij.spring.contexts.model.SpringModel;
import com.intellij.spring.model.CommonSpringBean;
import com.intellij.spring.model.SpringModelSearchParameters;
import com.intellij.spring.model.utils.SpringCommonUtils;
import com.intellij.spring.model.utils.SpringPropertyUtils;
import com.intellij.spring.web.mvc.jsp.SpringModelELVariable;
import com.intellij.spring.web.mvc.model.SpringMVCModel;
import com.intellij.spring.web.mvc.model.SpringMVCModelService;
import com.intellij.util.Processor;
import org.jetbrains.annotations.NotNull;

public class SpringMvcElVariablesProvider
extends ElVariablesProvider {
    private static final ElVariablesProvider JSP_EL_VARIABLES_PROVIDER = new JspElVariablesProvider();

    public boolean processImplicitVariables(@NotNull PsiElement element, @NotNull ELExpressionHolder holder, @NotNull ELElementProcessor processor2) {
        Module module;
        if (element == null) {
            SpringMvcElVariablesProvider.$$$reportNull$$$0(0);
        }
        if (holder == null) {
            SpringMvcElVariablesProvider.$$$reportNull$$$0(1);
        }
        if (processor2 == null) {
            SpringMvcElVariablesProvider.$$$reportNull$$$0(2);
        }
        if ((module = ModuleUtilCore.findModuleForPsiElement((PsiElement)holder)) == null) {
            return true;
        }
        boolean viaJsp = JSP_EL_VARIABLES_PROVIDER.processImplicitVariables(element, holder, processor2);
        if (!viaJsp) {
            return false;
        }
        SpringMVCModel model = SpringMVCModelService.getInstance().getModel(element);
        if (model == null) {
            return true;
        }
        if (!SpringMvcElVariablesProvider.processVariables(holder, processor2, model)) {
            return false;
        }
        return SpringMvcElVariablesProvider.processConfigurationVariables(holder, processor2, module, model);
    }

    private static boolean processVariables(ELExpressionHolder holder, ELElementProcessor elElementProcessor, SpringMVCModel model) {
        return model.processVariables((PsiElement)holder, arg_0 -> ((ELElementProcessor)elElementProcessor).processVariable(arg_0), elElementProcessor.getNameHint());
    }

    private static boolean processConfigurationVariables(ELExpressionHolder holder, ELElementProcessor elElementProcessor, Module module, SpringMVCModel model) {
        PsiClass internalViewResolver = SpringCommonUtils.findLibraryClass((Module)module, (String)"org.springframework.web.servlet.view.InternalResourceViewResolver");
        if (internalViewResolver == null) {
            return false;
        }
        Processor processor2 = pointer -> {
            CommonSpringBean bean = pointer.getSpringBean();
            String contextAttributeName = SpringPropertyUtils.getPropertyStringValue((CommonSpringBean)bean, (String)"requestContextAttribute");
            if (StringUtil.isEmpty((String)contextAttributeName)) {
                return true;
            }
            PsiClassType type = JavaPsiFacade.getElementFactory((Project)holder.getProject()).createTypeByFQClassName("org.springframework.web.servlet.support.RequestContext");
            SpringModelELVariable variable = new SpringModelELVariable((PsiElement)holder, contextAttributeName, (PsiType)type, bean.getIdentifyingPsiElement(), "NESTED");
            return elElementProcessor.processVariable((PsiVariable)variable);
        };
        SpringModelSearchParameters.BeanClass searchParameters = SpringModelSearchParameters.byClass((PsiClass)internalViewResolver).withInheritors();
        for (SpringModel springModel : model.getAllModels()) {
            if (springModel.processByClass(searchParameters, processor2)) continue;
            return false;
        }
        return true;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[3];
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[0] = "element";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[0] = "holder";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[0] = "processor";
                break;
            }
        }
        objectArray[1] = "com/intellij/spring/web/mvc/jsp/SpringMvcElVariablesProvider";
        objectArray[2] = "processImplicitVariables";
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

