/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.internal.impldep.org.simpleframework.util.lease;

import java.util.concurrent.Delayed;
import java.util.concurrent.TimeUnit;
import org.gradle.internal.impldep.org.simpleframework.util.lease.Contract;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class Entry<T>
implements Contract<T> {
    private volatile long time;
    private T key;

    public Entry(T key, long lease, TimeUnit scale) {
        this.time = this.getTime() + scale.toNanos(lease);
        this.key = key;
    }

    @Override
    public T getKey() {
        return this.key;
    }

    @Override
    public long getDelay(TimeUnit unit) {
        return unit.convert(this.time - this.getTime(), TimeUnit.NANOSECONDS);
    }

    @Override
    public void setDelay(long delay, TimeUnit unit) {
        this.time = this.getTime() + unit.toNanos(delay);
    }

    private long getTime() {
        return System.nanoTime();
    }

    @Override
    public int compareTo(Delayed other) {
        Entry entry = (Entry)other;
        if (other == this) {
            return 0;
        }
        return this.compareTo(entry);
    }

    @Override
    private int compareTo(Entry entry) {
        long diff = this.time - entry.time;
        if (diff < 0L) {
            return -1;
        }
        if (diff > 0L) {
            return 1;
        }
        return 0;
    }

    @Override
    public String toString() {
        return String.format("contract %s", this.key);
    }
}

