/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.uml.java.providers;

import com.intellij.diagram.extras.providers.SupersProvider;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.uml.utils.UmlBundle;
import java.util.Comparator;
import java.util.HashSet;
import java.util.Set;

public class PsiClassParents
extends SupersProvider<PsiElement> {
    public static Set<PsiClass> getSupers(PsiClass child) {
        HashSet<PsiClass> supers = new HashSet<PsiClass>();
        if (child == null) {
            return supers;
        }
        for (PsiClass psiClass : child.getSupers()) {
            supers.add(psiClass);
            supers.addAll(PsiClassParents.getSupers(psiClass));
        }
        return supers;
    }

    public PsiClass[] getElements(PsiElement element, Project project) {
        if (element instanceof PsiClass) {
            Set<PsiClass> classes = PsiClassParents.getSupers((PsiClass)element);
            return classes.toArray(PsiClass.EMPTY_ARRAY);
        }
        return PsiClass.EMPTY_ARRAY;
    }

    public String getHeaderName(PsiElement element, Project project) {
        return UmlBundle.message("show.supers.for", element instanceof PsiClass ? ((PsiClass)element).getName() : "");
    }

    public Comparator getComparator() {
        return PSI_COMPARATOR;
    }
}

