/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.javaee.weblogic.runDebug.configuration;

import com.intellij.javaee.J2EEBundle;
import com.intellij.javaee.appServerIntegrations.ApplicationServer;
import com.intellij.javaee.oss.server.JavaeePersistentData;
import com.intellij.javaee.run.configuration.ApplicationServerSelectionListener;
import com.intellij.javaee.run.configuration.CommonModel;
import com.intellij.javaee.run.configuration.PredefinedLogFilesListener;
import com.intellij.javaee.run.configuration.PredefinedLogFilesProviderEditor;
import com.intellij.javaee.run.configuration.ServerModelBase;
import com.intellij.javaee.run.configuration.view.JavaeeRunConfigurationEditorUtil;
import com.intellij.javaee.weblogic.beaInstallation.BeaDomain;
import com.intellij.javaee.weblogic.beaInstallation.BeaServer;
import com.intellij.javaee.weblogic.beaInstallation.WeblogicUtil;
import com.intellij.javaee.weblogic.runDebug.configuration.WeblogicModel;
import com.intellij.openapi.fileChooser.FileChooser;
import com.intellij.openapi.fileChooser.FileChooserDescriptor;
import com.intellij.openapi.fileChooser.FileChooserDescriptorFactory;
import com.intellij.openapi.options.ConfigurationException;
import com.intellij.openapi.options.SettingsEditor;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.ui.ComboBoxFieldPanel;
import com.intellij.ui.ListCellRendererWrapper;
import com.intellij.ui.PanelWithAnchor;
import com.intellij.ui.components.JBLabel;
import com.intellij.uiDesigner.core.GridConstraints;
import com.intellij.uiDesigner.core.GridLayoutManager;
import com.intellij.uiDesigner.core.Spacer;
import com.intellij.util.EventDispatcher;
import java.awt.BorderLayout;
import java.awt.CardLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.util.ArrayList;
import java.util.Collections;
import java.util.EventListener;
import java.util.ResourceBundle;
import javax.swing.AbstractButton;
import javax.swing.ButtonGroup;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JPasswordField;
import javax.swing.JRadioButton;
import javax.swing.JTextField;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

class WeblogicLocalRunConfigurationEditor
extends SettingsEditor<CommonModel>
implements ApplicationServerSelectionListener,
PredefinedLogFilesProviderEditor,
PanelWithAnchor {
    @NonNls
    private static final String ADMIN_CARD_NAME = "Admin";
    @NonNls
    private static final String MANAGED_CARD_NAME = "Managed";
    private final EventDispatcher<PredefinedLogFilesListener> myDispatcher;
    private ApplicationServer myLastSelectedServer;
    private JPanel myPanel;
    private JPanel myDomainPathPanel;
    private final ComboBoxFieldPanel myDomainPath;
    private JTextField myUser;
    private JPasswordField myPassword;
    private JLabel myPasswordLabel;
    private JComboBox myManagedServerComboBox;
    private JRadioButton myAdminRadioButton;
    private JRadioButton myManagedRadioButton;
    private JComboBox myAdminServerComboBox;
    private JPanel myRadioPanel;
    private JTextField myAdminHostField;
    private JTextField myAdminPortField;
    private JPanel myServerSettingsPanel;
    private JBLabel myDomainPathLabel;
    private JBLabel myServerToLaunchLabel;
    private JBLabel myAdminServerLabel;
    private JComponent anchor;
    private VersionBehavior myVersionBehavior;
    private After9LaunchBehavior myAfter9LaunchBehavior;
    private final After9LaunchBehavior[] myAvailableAfter9LaunchBehaviors;
    private boolean myKeepSelectedDomainPath;

    WeblogicLocalRunConfigurationEditor() {
        this.$$$setupUI$$$();
        this.myDispatcher = EventDispatcher.create(PredefinedLogFilesListener.class);
        this.myDomainPath = new ComboBoxFieldPanel();
        this.myVersionBehavior = new After9VersionBehavior();
        this.myAvailableAfter9LaunchBehaviors = new After9LaunchBehavior[]{new After9AdminLaunchBehavior(), new After9ManagedLaunchBehavior()};
        this.myKeepSelectedDomainPath = false;
        final FileChooserDescriptor domainPathChooserDescriptor = FileChooserDescriptorFactory.createSingleFolderDescriptor();
        this.myDomainPath.setBrowseButtonActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                String path = WeblogicLocalRunConfigurationEditor.this.myDomainPath.getText();
                VirtualFile toSelect = path != null && path.length() > 0 ? LocalFileSystem.getInstance().findFileByPath(path.replace(File.separatorChar, '/')) : null;
                VirtualFile file = FileChooser.chooseFile((FileChooserDescriptor)domainPathChooserDescriptor, (Component)WeblogicLocalRunConfigurationEditor.this.myPanel, null, (VirtualFile)toSelect);
                if (file != null) {
                    WeblogicLocalRunConfigurationEditor.this.myDomainPath.setText(file.getPath().replace('/', File.separatorChar));
                    WeblogicLocalRunConfigurationEditor.this.loadDomain();
                }
            }
        });
        this.myDomainPath.createComponent();
        this.myDomainPath.getComboBox().addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (WeblogicLocalRunConfigurationEditor.this.myKeepSelectedDomainPath) {
                    return;
                }
                WeblogicLocalRunConfigurationEditor.this.loadDomain();
            }
        });
        this.setupServerComboBox(this.myAdminServerComboBox);
        this.setupServerComboBox(this.myManagedServerComboBox);
        this.myDomainPathPanel.setLayout(new BorderLayout());
        this.myDomainPathPanel.add((Component)this.myDomainPath, "Center");
        ActionListener radioListener = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                WeblogicLocalRunConfigurationEditor.this.updateAfter9LaunchBehavior();
            }
        };
        this.myAdminRadioButton.addActionListener(radioListener);
        this.myManagedRadioButton.addActionListener(radioListener);
        this.myAdminRadioButton.setSelected(true);
        this.updateAfter9LaunchBehavior();
        this.setAnchor((JComponent)this.myServerToLaunchLabel);
    }

    private void updateAfter9LaunchBehavior() {
        this.updateAfter9LaunchBehavior(true);
    }

    private void updateAfter9LaunchBehavior(boolean activate) {
        for (After9LaunchBehavior behavior : this.myAvailableAfter9LaunchBehaviors) {
            if (!behavior.getRadioButton().isSelected()) continue;
            this.myAfter9LaunchBehavior = behavior;
            if (!activate) break;
            behavior.activate();
            break;
        }
    }

    private void setupServerComboBox(JComboBox comboBox) {
        comboBox.setRenderer(new ListCellRendererWrapper<BeaServer>(){

            public void customize(JList list, BeaServer value, int index, boolean selected, boolean hasFocus) {
                this.setText(value.getName());
            }
        });
        comboBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                WeblogicLocalRunConfigurationEditor.this.predefinedLogFilesChanged();
            }
        });
    }

    private void predefinedLogFilesChanged() {
        try {
            ((PredefinedLogFilesListener)this.myDispatcher.getMulticaster()).predefinedLogFilesChanged((CommonModel)this.getSnapshot());
        }
        catch (ConfigurationException configurationException) {
            // empty catch block
        }
    }

    public void serverSelected(@Nullable ApplicationServer server) {
        if (this.myLastSelectedServer == server) {
            return;
        }
        this.myLastSelectedServer = server;
        this.refreshDomainsList(server);
    }

    public void serverProbablyEdited(@Nullable ApplicationServer server) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void refreshDomainsList(@Nullable ApplicationServer server) {
        String selectedDomainPath = this.myDomainPath.getText();
        ArrayList<String> domainPaths = new ArrayList<String>();
        try {
            this.myKeepSelectedDomainPath = false;
            if (server != null) {
                BeaDomain[] domains = this.getDomains(WeblogicLocalRunConfigurationEditor.getBeaPath(server));
                for (BeaDomain domain : domains) {
                    String domainPath = domain.getLocation().getAbsolutePath();
                    if (domainPath.equals(selectedDomainPath)) {
                        this.myKeepSelectedDomainPath = true;
                    }
                    domainPaths.add(domainPath);
                }
                Collections.sort(domainPaths);
            }
            JComboBox comboBox = this.myDomainPath.getComboBox();
            comboBox.removeAllItems();
            for (String domainPath : domainPaths) {
                comboBox.addItem(domainPath);
            }
            if (this.myKeepSelectedDomainPath) {
                this.myDomainPath.setText(selectedDomainPath);
            }
        }
        finally {
            this.myKeepSelectedDomainPath = false;
        }
    }

    public JComponent getAnchor() {
        return this.anchor;
    }

    public void setAnchor(JComponent anchor) {
        this.anchor = anchor;
        this.myDomainPathLabel.setAnchor(anchor);
        this.myServerToLaunchLabel.setAnchor(anchor);
        this.myAdminServerLabel.setAnchor(anchor);
    }

    private static String getBeaPath(ApplicationServer server) {
        JavaeePersistentData persistentData = (JavaeePersistentData)server.getPersistentData();
        return persistentData.HOME;
    }

    private BeaDomain[] getDomains(String path) {
        return WeblogicUtil.loadDomains(new File(path));
    }

    public void applyEditorTo(@NotNull CommonModel configuration) throws ConfigurationException {
        if (configuration == null) {
            WeblogicLocalRunConfigurationEditor.$$$reportNull$$$0(0);
        }
        WeblogicModel wl = (WeblogicModel)configuration.getServerModel();
        String domainPath = this.myDomainPath.getText();
        if (domainPath.length() != 0) {
            BeaDomain domain = WeblogicUtil.createDomain(new File(domainPath));
            wl.DOMAIN_PATH = FileUtil.toSystemIndependentName((String)domain.getLocation().getAbsolutePath());
            wl.DOMAIN_NAME = domain.getName();
            this.myVersionBehavior.applyEditorTo(wl);
        } else {
            wl.DOMAIN_PATH = "";
            wl.DOMAIN_NAME = "";
            wl.SERVER_NAME = "";
            wl.CONNECT_TO_MANAGED_SERVER = false;
        }
        wl.USERNAME = this.myUser.getText();
        JavaeeRunConfigurationEditorUtil.applyPasswordTo((ServerModelBase)wl, (JPasswordField)this.myPassword);
    }

    public void resetEditorFrom(@NotNull CommonModel configuration) {
        if (configuration == null) {
            WeblogicLocalRunConfigurationEditor.$$$reportNull$$$0(1);
        }
        WeblogicModel wl = (WeblogicModel)configuration.getServerModel();
        this.myVersionBehavior = new After9VersionBehavior();
        this.refreshDomainsList(configuration.getApplicationServer());
        this.myDomainPath.setText(FileUtil.toSystemDependentName((String)wl.DOMAIN_PATH));
        this.doLoadDomain();
        this.myVersionBehavior.resetEditorFrom(wl);
        this.myVersionBehavior.onDomainChanged();
        this.myUser.setText(wl.USERNAME);
        JavaeeRunConfigurationEditorUtil.resetPasswordFrom((ServerModelBase)wl, (JPasswordField)this.myPassword, (JLabel)this.myPasswordLabel);
    }

    @NotNull
    public JComponent createEditor() {
        JPanel jPanel = this.myPanel;
        if (jPanel == null) {
            WeblogicLocalRunConfigurationEditor.$$$reportNull$$$0(2);
        }
        return jPanel;
    }

    public void addListener(PredefinedLogFilesListener listener) {
        this.myDispatcher.addListener((EventListener)listener);
    }

    public void removeListener(PredefinedLogFilesListener listener) {
        this.myDispatcher.removeListener((EventListener)listener);
    }

    private static void setSelectedServer(JComboBox serverComboBox, String serverName) {
        for (int i = 0; i < serverComboBox.getItemCount(); ++i) {
            BeaServer server = (BeaServer)serverComboBox.getItemAt(i);
            if (!serverName.equals(server.getName())) continue;
            serverComboBox.setSelectedIndex(i);
            break;
        }
    }

    private static String getSelectedServer(JComboBox serverComboBox) {
        BeaServer selectedServer = (BeaServer)serverComboBox.getSelectedItem();
        return selectedServer != null ? selectedServer.getName() : "";
    }

    private void showCard(String cardName) {
        ((CardLayout)this.myServerSettingsPanel.getLayout()).show(this.myServerSettingsPanel, cardName);
    }

    private void loadDomain() {
        this.doLoadDomain();
        this.myVersionBehavior.onDomainChanged();
    }

    private void doLoadDomain() {
        BeaDomain domain = WeblogicUtil.createDomain(new File(this.myDomainPath.getText()));
        BeaServer[] servers = domain.getServers();
        this.myAdminServerComboBox.removeAllItems();
        this.myManagedServerComboBox.removeAllItems();
        for (BeaServer server : servers) {
            if (server.isAdmin()) {
                this.myAdminServerComboBox.addItem(server);
                continue;
            }
            this.myManagedServerComboBox.addItem(server);
        }
        if (this.myAdminServerComboBox.getItemCount() > 0) {
            this.myAdminServerComboBox.setSelectedIndex(0);
        }
        this.predefinedLogFilesChanged();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "configuration";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/javaee/weblogic/runDebug/configuration/WeblogicLocalRunConfigurationEditor";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/javaee/weblogic/runDebug/configuration/WeblogicLocalRunConfigurationEditor";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "createEditor";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "applyEditorTo";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "resetEditorFrom";
                break;
            }
            case 2: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private /* synthetic */ void $$$setupUI$$$() {
        JTextField jTextField;
        JTextField jTextField2;
        JComboBox jComboBox;
        JComboBox jComboBox2;
        JBLabel jBLabel;
        JPanel jPanel;
        JBLabel jBLabel2;
        JRadioButton jRadioButton;
        JRadioButton jRadioButton2;
        JPanel jPanel2;
        JTextField jTextField3;
        JPanel jPanel3;
        JBLabel jBLabel3;
        JPasswordField jPasswordField;
        JLabel jLabel;
        JPanel jPanel4;
        this.myPanel = jPanel4 = new JPanel();
        jPanel4.setLayout((LayoutManager)new GridLayoutManager(6, 2, new Insets(0, 0, 0, 0), -1, -1, false, false));
        Spacer spacer = new Spacer();
        jPanel4.add((Component)spacer, new GridConstraints(5, 1, 1, 1, 0, 2, 1, 6, null, null, null));
        this.myPasswordLabel = jLabel = new JLabel();
        ((Component)jLabel).setEnabled(false);
        this.$$$loadLabelText$$$(jLabel, ResourceBundle.getBundle("com/intellij/javaee/weblogic/WeblogicBundle").getString("label.run.configuration.password"));
        ((Component)jLabel).setVisible(false);
        jPanel4.add((Component)jLabel, new GridConstraints(1, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        this.myPassword = jPasswordField = new JPasswordField();
        ((Component)jPasswordField).setEnabled(false);
        ((Component)jPasswordField).setVisible(false);
        jPanel4.add((Component)jPasswordField, new GridConstraints(1, 1, 1, 1, 8, 1, 6, 0, null, new Dimension(100, 20), null));
        JLabel jLabel2 = new JLabel();
        this.$$$loadLabelText$$$(jLabel2, ResourceBundle.getBundle("com/intellij/javaee/weblogic/WeblogicBundle").getString("label.run.configuration.user"));
        jPanel4.add((Component)jLabel2, new GridConstraints(0, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        this.myDomainPathLabel = jBLabel3 = new JBLabel();
        this.$$$loadLabelText$$$((JLabel)jBLabel3, ResourceBundle.getBundle("com/intellij/javaee/weblogic/WeblogicBundle").getString("label.run.configuration.domain.path"));
        jPanel4.add((Component)jBLabel3, new GridConstraints(2, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        this.myDomainPathPanel = jPanel3 = new JPanel();
        jPanel4.add((Component)jPanel3, new GridConstraints(2, 1, 1, 1, 0, 1, 3, 1, null, new Dimension(100, -1), null));
        this.myUser = jTextField3 = new JTextField();
        jPanel4.add((Component)jTextField3, new GridConstraints(0, 1, 1, 1, 8, 1, 6, 0, null, new Dimension(100, 20), null));
        this.myRadioPanel = jPanel2 = new JPanel();
        jPanel2.setLayout((LayoutManager)new GridLayoutManager(1, 4, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel4.add((Component)jPanel2, new GridConstraints(3, 0, 1, 2, 0, 3, 3, 3, null, null, null));
        this.myAdminRadioButton = jRadioButton2 = new JRadioButton();
        this.$$$loadButtonText$$$(jRadioButton2, ResourceBundle.getBundle("com/intellij/javaee/weblogic/WeblogicBundle").getString("radio.run.configuration.admin"));
        jPanel2.add((Component)jRadioButton2, new GridConstraints(0, 1, 1, 1, 8, 0, 3, 0, null, null, null));
        this.myManagedRadioButton = jRadioButton = new JRadioButton();
        this.$$$loadButtonText$$$(jRadioButton, ResourceBundle.getBundle("com/intellij/javaee/weblogic/WeblogicBundle").getString("radio.run.configuration.managed"));
        jPanel2.add((Component)jRadioButton, new GridConstraints(0, 2, 1, 1, 8, 0, 3, 0, null, null, null));
        Spacer spacer2 = new Spacer();
        jPanel2.add((Component)spacer2, new GridConstraints(0, 3, 1, 1, 0, 1, 6, 1, null, null, null));
        this.myServerToLaunchLabel = jBLabel2 = new JBLabel();
        this.$$$loadLabelText$$$((JLabel)jBLabel2, ResourceBundle.getBundle("com/intellij/javaee/weblogic/WeblogicBundle").getString("label.run.configuration.server.to.launch"));
        jPanel2.add((Component)jBLabel2, new GridConstraints(0, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        this.myServerSettingsPanel = jPanel = new JPanel();
        jPanel.setLayout(new CardLayout(0, 0));
        jPanel4.add((Component)jPanel, new GridConstraints(4, 0, 1, 2, 0, 3, 3, 3, null, null, null));
        JPanel jPanel5 = new JPanel();
        jPanel5.setLayout((LayoutManager)new GridLayoutManager(2, 3, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel.add((Component)jPanel5, ADMIN_CARD_NAME);
        this.myAdminServerLabel = jBLabel = new JBLabel();
        this.$$$loadLabelText$$$((JLabel)jBLabel, ResourceBundle.getBundle("com/intellij/javaee/weblogic/WeblogicBundle").getString("label.bea.server.name.text"));
        jPanel5.add((Component)jBLabel, new GridConstraints(0, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        Spacer spacer3 = new Spacer();
        jPanel5.add((Component)spacer3, new GridConstraints(0, 2, 1, 1, 0, 1, 6, 1, null, null, null));
        this.myAdminServerComboBox = jComboBox2 = new JComboBox();
        jPanel5.add(jComboBox2, new GridConstraints(0, 1, 1, 1, 8, 1, 2, 0, null, null, null));
        Spacer spacer4 = new Spacer();
        jPanel5.add((Component)spacer4, new GridConstraints(1, 0, 1, 1, 0, 2, 1, 6, null, null, null));
        JPanel jPanel6 = new JPanel();
        jPanel6.setLayout((LayoutManager)new GridLayoutManager(3, 3, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel.add((Component)jPanel6, MANAGED_CARD_NAME);
        JLabel jLabel3 = new JLabel();
        this.$$$loadLabelText$$$(jLabel3, ResourceBundle.getBundle("com/intellij/javaee/weblogic/WeblogicBundle").getString("label.bea.managed.server.name.text"));
        jPanel6.add((Component)jLabel3, new GridConstraints(0, 0, 1, 1, 8, 0, 0, 0, null, new Dimension(170, -1), null));
        Spacer spacer5 = new Spacer();
        jPanel6.add((Component)spacer5, new GridConstraints(0, 2, 1, 1, 0, 1, 6, 1, null, null, null));
        this.myManagedServerComboBox = jComboBox = new JComboBox();
        jPanel6.add(jComboBox, new GridConstraints(0, 1, 1, 1, 8, 1, 2, 0, null, null, null));
        JLabel jLabel4 = new JLabel();
        this.$$$loadLabelText$$$(jLabel4, ResourceBundle.getBundle("com/intellij/javaee/weblogic/WeblogicBundle").getString("label.run.configuration.admin.server.host"));
        jPanel6.add((Component)jLabel4, new GridConstraints(1, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        this.myAdminHostField = jTextField2 = new JTextField();
        jPanel6.add((Component)jTextField2, new GridConstraints(1, 1, 1, 1, 8, 1, 6, 0, null, new Dimension(150, -1), null));
        JLabel jLabel5 = new JLabel();
        this.$$$loadLabelText$$$(jLabel5, ResourceBundle.getBundle("com/intellij/javaee/weblogic/WeblogicBundle").getString("label.run.configuration.admin.server.port"));
        jPanel6.add((Component)jLabel5, new GridConstraints(2, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        this.myAdminPortField = jTextField = new JTextField();
        jPanel6.add((Component)jTextField, new GridConstraints(2, 1, 1, 1, 8, 1, 6, 0, null, new Dimension(150, -1), null));
        jLabel.setLabelFor(jPasswordField);
        jLabel2.setLabelFor(jTextField3);
        jBLabel.setLabelFor(jComboBox);
        jLabel3.setLabelFor(jComboBox);
        ButtonGroup buttonGroup = new ButtonGroup();
        buttonGroup.add(jRadioButton2);
        buttonGroup.add(jRadioButton);
    }

    public /* synthetic */ JComponent $$$getRootComponent$$$() {
        return this.myPanel;
    }

    private /* synthetic */ void $$$loadLabelText$$$(JLabel jLabel, String string) {
        StringBuffer stringBuffer = new StringBuffer();
        boolean bl = false;
        char c = '\u0000';
        int n = -1;
        for (int i = 0; i < string.length(); ++i) {
            if (string.charAt(i) == '&') {
                if (++i == string.length()) break;
                if (!bl && string.charAt(i) != '&') {
                    bl = true;
                    c = string.charAt(i);
                    n = stringBuffer.length();
                }
            }
            stringBuffer.append(string.charAt(i));
        }
        jLabel.setText(stringBuffer.toString());
        if (bl) {
            jLabel.setDisplayedMnemonic(c);
            jLabel.setDisplayedMnemonicIndex(n);
        }
    }

    private /* synthetic */ void $$$loadButtonText$$$(AbstractButton abstractButton, String string) {
        StringBuffer stringBuffer = new StringBuffer();
        boolean bl = false;
        char c = '\u0000';
        int n = -1;
        for (int i = 0; i < string.length(); ++i) {
            if (string.charAt(i) == '&') {
                if (++i == string.length()) break;
                if (!bl && string.charAt(i) != '&') {
                    bl = true;
                    c = string.charAt(i);
                    n = stringBuffer.length();
                }
            }
            stringBuffer.append(string.charAt(i));
        }
        abstractButton.setText(stringBuffer.toString());
        if (bl) {
            abstractButton.setMnemonic(c);
            abstractButton.setDisplayedMnemonicIndex(n);
        }
    }

    private class After9ManagedLaunchBehavior
    extends After9LaunchBehavior {
        After9ManagedLaunchBehavior() {
            super(WeblogicLocalRunConfigurationEditor.this.myManagedRadioButton);
        }

        @Override
        public void activate() {
            WeblogicLocalRunConfigurationEditor.this.showCard(WeblogicLocalRunConfigurationEditor.MANAGED_CARD_NAME);
        }

        @Override
        public void resetEditorFrom(WeblogicModel wl) {
            WeblogicLocalRunConfigurationEditor.setSelectedServer(WeblogicLocalRunConfigurationEditor.this.myManagedServerComboBox, wl.SERVER_NAME);
            WeblogicLocalRunConfigurationEditor.this.myAdminHostField.setText(wl.ADMIN_SERVER_HOST);
            WeblogicLocalRunConfigurationEditor.this.myAdminPortField.setText(String.valueOf(wl.ADMIN_SERVER_PORT));
        }

        @Override
        public void applyEditorTo(WeblogicModel wl) throws ConfigurationException {
            wl.SERVER_NAME = WeblogicLocalRunConfigurationEditor.getSelectedServer(WeblogicLocalRunConfigurationEditor.this.myManagedServerComboBox);
            wl.CONNECT_TO_MANAGED_SERVER = true;
            wl.ADMIN_SERVER_HOST = WeblogicLocalRunConfigurationEditor.this.myAdminHostField.getText();
            try {
                wl.ADMIN_SERVER_PORT = Integer.parseInt(WeblogicLocalRunConfigurationEditor.this.myAdminPortField.getText());
            }
            catch (NumberFormatException ignore) {
                throw new ConfigurationException(J2EEBundle.message((String)"exception.text.invalid.port.value", (Object[])new Object[]{WeblogicLocalRunConfigurationEditor.this.myAdminPortField.getText()}));
            }
        }
    }

    private class After9AdminLaunchBehavior
    extends After9LaunchBehavior {
        After9AdminLaunchBehavior() {
            super(WeblogicLocalRunConfigurationEditor.this.myAdminRadioButton);
        }

        @Override
        public void activate() {
            WeblogicLocalRunConfigurationEditor.this.showCard(WeblogicLocalRunConfigurationEditor.ADMIN_CARD_NAME);
        }

        @Override
        public void resetEditorFrom(WeblogicModel wl) {
            WeblogicLocalRunConfigurationEditor.setSelectedServer(WeblogicLocalRunConfigurationEditor.this.myAdminServerComboBox, wl.SERVER_NAME);
            WeblogicLocalRunConfigurationEditor.this.myAdminHostField.setText("");
            WeblogicLocalRunConfigurationEditor.this.myAdminPortField.setText("");
        }

        @Override
        public void applyEditorTo(WeblogicModel wl) {
            wl.SERVER_NAME = WeblogicLocalRunConfigurationEditor.getSelectedServer(WeblogicLocalRunConfigurationEditor.this.myAdminServerComboBox);
            wl.CONNECT_TO_MANAGED_SERVER = false;
        }
    }

    private static abstract class After9LaunchBehavior {
        private final JRadioButton myRadioButton;

        protected After9LaunchBehavior(JRadioButton radioButton) {
            this.myRadioButton = radioButton;
        }

        public JRadioButton getRadioButton() {
            return this.myRadioButton;
        }

        public abstract void activate();

        public abstract void resetEditorFrom(WeblogicModel var1);

        public abstract void applyEditorTo(WeblogicModel var1) throws ConfigurationException;
    }

    private class After9VersionBehavior
    implements VersionBehavior {
        private After9VersionBehavior() {
        }

        @Override
        public void resetEditorFrom(WeblogicModel wl) {
            WeblogicLocalRunConfigurationEditor.this.myRadioPanel.setVisible(true);
            (wl.CONNECT_TO_MANAGED_SERVER ? WeblogicLocalRunConfigurationEditor.this.myManagedRadioButton : WeblogicLocalRunConfigurationEditor.this.myAdminRadioButton).setSelected(true);
            WeblogicLocalRunConfigurationEditor.this.updateAfter9LaunchBehavior();
            WeblogicLocalRunConfigurationEditor.this.myAfter9LaunchBehavior.resetEditorFrom(wl);
        }

        @Override
        public void applyEditorTo(WeblogicModel wl) throws ConfigurationException {
            WeblogicLocalRunConfigurationEditor.this.updateAfter9LaunchBehavior(false);
            WeblogicLocalRunConfigurationEditor.this.myAfter9LaunchBehavior.applyEditorTo(wl);
        }

        @Override
        public void onDomainChanged() {
            boolean hasManagedServers = WeblogicLocalRunConfigurationEditor.this.myManagedServerComboBox.getItemCount() > 0;
            WeblogicLocalRunConfigurationEditor.this.myRadioPanel.setVisible(hasManagedServers);
            if (!hasManagedServers) {
                WeblogicLocalRunConfigurationEditor.this.myAdminRadioButton.setSelected(true);
                WeblogicLocalRunConfigurationEditor.this.updateAfter9LaunchBehavior();
            }
        }
    }

    private static interface VersionBehavior {
        public void onDomainChanged();

        public void resetEditorFrom(WeblogicModel var1);

        public void applyEditorTo(WeblogicModel var1) throws ConfigurationException;
    }
}

