/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.javaee.weblogic.applicationServer;

import com.intellij.javaee.deployment.DeploymentModel;
import com.intellij.javaee.deployment.DeploymentSource;
import com.intellij.javaee.run.configuration.CommonModel;
import com.intellij.javaee.weblogic.WeblogicBundle;
import com.intellij.javaee.weblogic.runDebug.deployment.WLDeploymentModel;
import com.intellij.javaee.weblogic.runDebug.deployment.WeblogicDeploymentProvider;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.fileChooser.FileChooserDescriptor;
import com.intellij.openapi.fileTypes.StdFileTypes;
import com.intellij.openapi.options.ConfigurationException;
import com.intellij.openapi.options.SettingsEditor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.ComboBox;
import com.intellij.openapi.ui.VerticalFlowLayout;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.search.FilenameIndex;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.ui.ComboboxWithBrowseButton;
import com.intellij.uiDesigner.core.GridConstraints;
import com.intellij.uiDesigner.core.GridLayoutManager;
import com.intellij.util.Consumer;
import java.awt.Component;
import java.awt.LayoutManager;
import java.util.ArrayList;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import org.jetbrains.annotations.NotNull;

public class WeblogicDeploymentSettingsEditor
extends SettingsEditor<DeploymentModel> {
    private static final String PLAN_FILE_NAME = "plan.xml";
    private static final Logger LOG = Logger.getInstance(WeblogicDeploymentSettingsEditor.class);
    private final JPanel myPanel = new JPanel((LayoutManager)new VerticalFlowLayout(0, 0));
    private final JCheckBox myCheckEjbCmpDatasources = new JCheckBox(WeblogicBundle.message("checkbox.deployment.settings.check.ejb.cmp.datasources", new Object[0]));
    private final JCheckBox myAsLibrary = new JCheckBox(WeblogicBundle.message("checkbox.deployment.settings.install.as.library", new Object[0]));
    private final JPanel myPlanPanel = new JPanel((LayoutManager)new GridLayoutManager(1, 2));
    private final ComboboxWithBrowseButton myPlan;

    public WeblogicDeploymentSettingsEditor(CommonModel commonModel, DeploymentSource deploymentSource) {
        super(() -> new WLDeploymentModel(commonModel, deploymentSource));
        Project project = commonModel.getProject();
        ArrayList<String> existingPlans = new ArrayList<String>();
        for (VirtualFile file2 : FilenameIndex.getVirtualFilesByName((Project)project, (String)PLAN_FILE_NAME, (GlobalSearchScope)GlobalSearchScope.projectScope((Project)project))) {
            existingPlans.add(VfsUtilCore.virtualToIoFile((VirtualFile)file2).getAbsolutePath());
        }
        ComboBox planComboBox = new ComboBox(existingPlans.toArray());
        planComboBox.setEditable(true);
        this.myPlan = new ComboboxWithBrowseButton((JComboBox)planComboBox);
        this.myPlan.addBrowseFolderListener(project, new FileChooserDescriptor(true, false, false, false, false, false).withFileFilter(file -> file.getFileType() == StdFileTypes.XML));
        this.myPlanPanel.add((Component)new JLabel(WeblogicBundle.message("label.deployment.settings.deployment.plan", new Object[0])), WeblogicDeploymentSettingsEditor.composeGridConstraints(0, 0, (Consumer<GridConstraints>)((Consumer)constraints -> {
            constraints.setVSizePolicy(0);
            constraints.setHSizePolicy(0);
            constraints.setAnchor(8);
        })));
        this.myPlanPanel.add((Component)this.myPlan, WeblogicDeploymentSettingsEditor.composeGridConstraints(0, 1, (Consumer<GridConstraints>)((Consumer)constraints -> {
            constraints.setVSizePolicy(0);
            constraints.setFill(1);
            constraints.setAnchor(8);
        })));
        this.myPanel.add(this.myCheckEjbCmpDatasources);
        this.myPanel.add(this.myAsLibrary);
        this.myPanel.add(this.myPlanPanel);
        this.addSettingsEditorListener(editor -> {
            try {
                this.updateView((WLDeploymentModel)((Object)((Object)this.getSnapshot())));
            }
            catch (ConfigurationException e) {
                LOG.error((Throwable)e);
            }
        });
    }

    private void updateView(@NotNull WLDeploymentModel model) {
        if (model == null) {
            WeblogicDeploymentSettingsEditor.$$$reportNull$$$0(0);
        }
        boolean autoDeploy = model.getCommonModel().isLocal() && model.getDeploymentMethod() == WeblogicDeploymentProvider.AUTODEPLOY;
        boolean asLibraryApplicable = !autoDeploy && (model.AS_LIBRARY || StringUtil.isEmpty((String)model.PLAN));
        this.myAsLibrary.setEnabled(asLibraryApplicable);
        this.myAsLibrary.setVisible(asLibraryApplicable);
        boolean planApplicable = !autoDeploy && !model.AS_LIBRARY;
        this.myPlan.setEnabled(planApplicable);
        this.myPlanPanel.setVisible(planApplicable);
    }

    private static GridConstraints composeGridConstraints(int row, int column, @NotNull Consumer<GridConstraints> composer) {
        if (composer == null) {
            WeblogicDeploymentSettingsEditor.$$$reportNull$$$0(1);
        }
        GridConstraints constraints = new GridConstraints();
        constraints.setRow(row);
        constraints.setColumn(column);
        composer.consume((Object)constraints);
        return constraints;
    }

    protected void resetEditorFrom(@NotNull DeploymentModel settings) {
        if (settings == null) {
            WeblogicDeploymentSettingsEditor.$$$reportNull$$$0(2);
        }
        WLDeploymentModel model = (WLDeploymentModel)settings;
        this.myCheckEjbCmpDatasources.setSelected(model.CHECK_EJB_CMP_DATASOURCES);
        this.myAsLibrary.setSelected(model.AS_LIBRARY);
        this.myPlan.getComboBox().getEditor().setItem(model.PLAN);
        this.updateView(model);
    }

    protected void applyEditorTo(@NotNull DeploymentModel settings) {
        if (settings == null) {
            WeblogicDeploymentSettingsEditor.$$$reportNull$$$0(3);
        }
        WLDeploymentModel model = (WLDeploymentModel)settings;
        model.CHECK_EJB_CMP_DATASOURCES = this.myCheckEjbCmpDatasources.isSelected();
        model.AS_LIBRARY = this.myAsLibrary.isSelected();
        model.PLAN = StringUtil.defaultIfEmpty((String)((String)this.myPlan.getComboBox().getEditor().getItem()), null);
    }

    @NotNull
    protected JComponent createEditor() {
        JPanel jPanel = this.myPanel;
        if (jPanel == null) {
            WeblogicDeploymentSettingsEditor.$$$reportNull$$$0(4);
        }
        return jPanel;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 4: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 4: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "model";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "composer";
                break;
            }
            case 2: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "settings";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/javaee/weblogic/applicationServer/WeblogicDeploymentSettingsEditor";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/javaee/weblogic/applicationServer/WeblogicDeploymentSettingsEditor";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "createEditor";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "updateView";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "composeGridConstraints";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "resetEditorFrom";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "applyEditorTo";
                break;
            }
            case 4: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 4: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

